/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.net.URI;
import java.util.regex.Pattern;

public class SecureContextResolver {
    private static final Pattern LOCALHOST_IPV4 = Pattern.compile("127.\\d{1,3}.\\d{1,3}.\\d{1,3}");

    public static boolean isSecureContext(URI uri) {
        if (uri.getScheme().equals("https")) {
            return true;
        }
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        if (host.equals("[::1]") || host.equals("[0000:0000:0000:0000:0000:0000:0000:0001]")) {
            return true;
        }
        if (LOCALHOST_IPV4.matcher(host).matches()) {
            return true;
        }
        if (host.equals("localhost") || host.equals("localhost.")) {
            return true;
        }
        return host.endsWith(".localhost") || host.endsWith(".localhost.");
    }
}

