/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.keycloak.config.OptionCategory;

public class Option<T> {
    private final Class<T> type;
    private final String key;
    private final OptionCategory category;
    private final boolean hidden;
    private final boolean buildTime;
    private final String description;
    private final Optional<T> defaultValue;
    private final Supplier<List<String>> expectedValues;

    public Option(Class<T> type, String key, OptionCategory category, boolean hidden, boolean buildTime, String description, Optional<T> defaultValue, Supplier<List<String>> expectedValues) {
        this.type = type;
        this.key = key;
        this.category = category;
        this.hidden = hidden;
        this.buildTime = buildTime;
        this.description = this.getDescriptionByCategorySupportLevel(description);
        this.defaultValue = defaultValue;
        this.expectedValues = expectedValues;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isBuildTime() {
        return this.buildTime;
    }

    public String getKey() {
        return this.key;
    }

    public OptionCategory getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<T> getDefaultValue() {
        return this.defaultValue;
    }

    public List<String> getExpectedValues() {
        return this.expectedValues.get();
    }

    public Option<T> withRuntimeSpecificDefault(T defaultValue) {
        return new Option<T>(this.type, this.key, this.category, this.hidden, this.buildTime, this.description, Optional.ofNullable(defaultValue), this.expectedValues);
    }

    private String getDescriptionByCategorySupportLevel(String description) {
        if (description == null || ((String)description).isBlank()) {
            return description;
        }
        switch (this.getCategory().getSupportLevel()) {
            case PREVIEW: {
                description = "Preview: " + (String)description;
                break;
            }
            case EXPERIMENTAL: {
                description = "Experimental: " + (String)description;
                break;
            }
        }
        return description;
    }
}

