/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.keycloak.common.Profile;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;

public class FeatureOptions {
    public static final Option<List> FEATURES = new OptionBuilder<Profile.Feature>("features", List.class, Profile.Feature.class).category(OptionCategory.FEATURE).description("Enables a set of one or more features.").expectedValues(FeatureOptions::getFeatureValues).defaultValue((Profile.Feature)Optional.empty()).buildTime(true).build();
    public static final Option FEATURES_DISABLED = new OptionBuilder<Profile.Feature>("features-disabled", List.class, Profile.Feature.class).category(OptionCategory.FEATURE).description("Disables a set of one or more features.").expectedValues(FeatureOptions::getFeatureValues).buildTime(true).build();

    private static List<String> getFeatureValues() {
        ArrayList<String> features = new ArrayList<String>();
        for (Profile.Feature value : Profile.Feature.values()) {
            features.add(value.name().toLowerCase().replace('_', '-'));
        }
        features.add(Profile.Type.PREVIEW.name().toLowerCase());
        return features;
    }
}

