/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config.database;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Database {
    private static final Map<String, Vendor> DATABASES = new HashMap<String, Vendor>();

    public static boolean isLiquibaseDatabaseSupported(String databaseType, String dbKind) {
        for (Vendor vendor : DATABASES.values()) {
            if (!vendor.liquibaseTypes.contains(databaseType) || !vendor.isOfKind(dbKind)) continue;
            return true;
        }
        return false;
    }

    public static Optional<String> getDatabaseKind(String alias) {
        Vendor vendor = DATABASES.get(alias);
        if (vendor == null) {
            return Optional.empty();
        }
        return Optional.of(vendor.databaseKind);
    }

    public static Optional<String> getDefaultUrl(String alias) {
        Vendor vendor = DATABASES.get(alias);
        if (vendor == null) {
            return Optional.empty();
        }
        return Optional.of(vendor.defaultUrl.apply(alias));
    }

    public static Optional<String> getDriver(String alias, boolean isXaEnabled) {
        Vendor vendor = DATABASES.get(alias);
        if (vendor == null) {
            return Optional.empty();
        }
        if (isXaEnabled) {
            return Optional.of(vendor.xaDriver);
        }
        return Optional.of(vendor.nonXaDriver);
    }

    public static Optional<String> getDialect(String alias) {
        Vendor vendor = DATABASES.get(alias);
        if (vendor == null) {
            return Optional.empty();
        }
        return Optional.of(vendor.dialect.apply(alias));
    }

    public static List<String> getLegacyStoreAliases() {
        return DATABASES.entrySet().stream().filter(e -> ((Vendor)((Object)((Object)e.getValue()))).isEnabledOnLegacyStore()).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    public static List<String> getAvailableMapStoreAliases() {
        return Stream.of(Vendor.values()).filter(Vendor::isEnabledOnNewStore).map(v -> v.aliases).flatMap(Stream::of).collect(Collectors.toList());
    }

    static {
        for (Vendor vendor : Vendor.values()) {
            for (String alias : vendor.aliases) {
                DATABASES.put(alias, vendor);
            }
        }
    }

    private static class Enabled {
        static final Enabled LEGACY_ONLY = new Enabled(true, false);
        static final Enabled MAP_STORE_ONLY = new Enabled(false, true);
        static final Enabled ENABLED = new Enabled(true, true);
        final boolean legacyStore;
        final boolean jpaMapStore;

        private Enabled(boolean legacyStore, boolean jpaMapStore) {
            this.legacyStore = legacyStore;
            this.jpaMapStore = jpaMapStore;
        }
    }

    public static enum Vendor {
        H2("h2", Enabled.LEGACY_ONLY, "org.h2.jdbcx.JdbcDataSource", "org.h2.Driver", "io.quarkus.hibernate.orm.runtime.dialect.QuarkusH2Dialect", new Function<String, String>(){

            @Override
            public String apply(String alias) {
                if ("dev-file".equalsIgnoreCase(alias)) {
                    return this.addH2NonKeywords("jdbc:h2:file:${kc.home.dir:${kc.db-url-path:" + this.escapeReplacements(System.getProperty("user.home")) + "}}" + this.escapeReplacements(File.separator) + "${kc.data.dir:data}" + this.escapeReplacements(File.separator) + "h2" + this.escapeReplacements(File.separator) + "keycloakdb${kc.db-url-properties:;;AUTO_SERVER=TRUE}");
                }
                return this.addH2NonKeywords("jdbc:h2:mem:keycloakdb${kc.db-url-properties:}");
            }

            private String escapeReplacements(String snippet) {
                if (File.separator.equals("\\")) {
                    return snippet.replace("\\", "/");
                }
                return snippet;
            }

            private String addH2NonKeywords(String jdbcUrl) {
                if (!((String)jdbcUrl).contains("NON_KEYWORDS=")) {
                    jdbcUrl = (String)jdbcUrl + ";NON_KEYWORDS=VALUE";
                }
                return jdbcUrl;
            }
        }, Arrays.asList("liquibase.database.core.H2Database"), "dev-mem", "dev-file"),
        MYSQL("mysql", Enabled.LEGACY_ONLY, "com.mysql.cj.jdbc.MysqlXADataSource", "com.mysql.cj.jdbc.Driver", "org.hibernate.dialect.MySQL8Dialect", "jdbc:mysql://${kc.db-url-host:localhost}:${kc.db-url-port:3306}/${kc.db-url-database:keycloak}${kc.db-url-properties:}", Arrays.asList("org.keycloak.connections.jpa.updater.liquibase.UpdatedMySqlDatabase"), new String[0]),
        MARIADB("mariadb", Enabled.LEGACY_ONLY, "org.mariadb.jdbc.MariaDbDataSource", "org.mariadb.jdbc.Driver", "org.hibernate.dialect.MariaDBDialect", "jdbc:mariadb://${kc.db-url-host:localhost}:${kc.db-url-port:3306}/${kc.db-url-database:keycloak}${kc.db-url-properties:}", Arrays.asList("org.keycloak.connections.jpa.updater.liquibase.UpdatedMariaDBDatabase"), new String[0]),
        POSTGRES("postgresql", Enabled.ENABLED, "org.postgresql.xa.PGXADataSource", "org.postgresql.Driver", "io.quarkus.hibernate.orm.runtime.dialect.QuarkusPostgreSQL10Dialect", "jdbc:postgresql://${kc.db-url-host:localhost}:${kc.db-url-port:5432}/${kc.db-url-database:keycloak}${kc.db-url-properties:}", Arrays.asList("liquibase.database.core.PostgresDatabase", "org.keycloak.connections.jpa.updater.liquibase.PostgresPlusDatabase"), "postgres"),
        COCKROACH(Vendor.POSTGRES.databaseKind, Enabled.MAP_STORE_ONLY, Vendor.POSTGRES.xaDriver, Vendor.POSTGRES.nonXaDriver, "org.hibernate.dialect.CockroachDB201Dialect", "jdbc:postgresql://${kc.db-url-host:localhost}:${kc.db-url-port:26257}/${kc.db-url-database:keycloak}${kc.db-url-properties:}", List.of("liquibase.database.core.CockroachDatabase"), "cockroach"),
        MSSQL("mssql", Enabled.LEGACY_ONLY, "com.microsoft.sqlserver.jdbc.SQLServerXADataSource", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "org.hibernate.dialect.SQLServer2016Dialect", "jdbc:sqlserver://${kc.db-url-host:localhost}:${kc.db-url-port:1433};databaseName=${kc.db-url-database:keycloak}${kc.db-url-properties:}", Arrays.asList("org.keycloak.quarkus.runtime.storage.database.liquibase.database.CustomMSSQLDatabase"), "mssql"),
        ORACLE("oracle", Enabled.LEGACY_ONLY, "oracle.jdbc.xa.client.OracleXADataSource", "oracle.jdbc.driver.OracleDriver", "org.hibernate.dialect.Oracle12cDialect", "jdbc:oracle:thin:@//${kc.db-url-host:localhost}:${kc.db-url-port:1521}/${kc.db-url-database:keycloak}", Arrays.asList("liquibase.database.core.OracleDatabase"), new String[0]);

        final String databaseKind;
        final Enabled enabled;
        final String xaDriver;
        final String nonXaDriver;
        final Function<String, String> dialect;
        final Function<String, String> defaultUrl;
        final List<String> liquibaseTypes;
        final String[] aliases;

        private Vendor(String databaseKind, Enabled enabled, String xaDriver, String nonXaDriver, String dialect, String defaultUrl, List<String> liquibaseTypes, String ... aliases) {
            this(databaseKind, enabled, xaDriver, nonXaDriver, (String alias) -> dialect, (String alias) -> defaultUrl, liquibaseTypes, aliases);
        }

        private Vendor(String databaseKind, Enabled enabled, String xaDriver, String nonXaDriver, String dialect, Function<String, String> defaultUrl, List<String> liquibaseTypes, String ... aliases) {
            this(databaseKind, enabled, xaDriver, nonXaDriver, (String alias) -> dialect, defaultUrl, liquibaseTypes, aliases);
        }

        private Vendor(String databaseKind, Enabled enabled, String xaDriver, String nonXaDriver, Function<String, String> dialect, Function<String, String> defaultUrl, List<String> liquibaseTypes, String ... aliases) {
            String[] stringArray;
            this.databaseKind = databaseKind;
            this.enabled = enabled;
            this.xaDriver = xaDriver;
            this.nonXaDriver = nonXaDriver;
            this.dialect = dialect;
            this.defaultUrl = defaultUrl;
            this.liquibaseTypes = liquibaseTypes;
            if (aliases.length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = databaseKind;
            } else {
                stringArray = aliases;
            }
            this.aliases = stringArray;
        }

        public boolean isEnabledOnLegacyStore() {
            return this.enabled.legacyStore;
        }

        public boolean isEnabledOnNewStore() {
            return this.enabled.jpaMapStore;
        }

        public boolean isOfKind(String dbKind) {
            return this.databaseKind.equals(dbKind);
        }

        public String toString() {
            return this.databaseKind.toLowerCase(Locale.ROOT);
        }
    }
}

