/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.Set;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;

public class ProxyOptions {
    public static final Option<Headers> PROXY_HEADERS = new OptionBuilder<Headers>("proxy-headers", Headers.class).category(OptionCategory.PROXY).description("The proxy headers that should be accepted by the server. Misconfiguration might leave the server exposed to security vulnerabilities. Takes precedence over the deprecated proxy option.").build();
    public static final Option<Mode> PROXY = new OptionBuilder<Mode>("proxy", Mode.class).category(OptionCategory.PROXY).description("The proxy address forwarding mode if the server is behind a reverse proxy.").defaultValue(Mode.none).deprecated(Set.of(PROXY_HEADERS.getKey())).build();
    public static final Option<Boolean> PROXY_FORWARDED_HOST = new OptionBuilder<Boolean>("proxy-forwarded-host", Boolean.class).category(OptionCategory.PROXY).defaultValue(Boolean.FALSE).build();
    public static final Option<Boolean> PROXY_FORWARDED_HEADER_ENABLED = new OptionBuilder<Boolean>("proxy-allow-forwarded-header", Boolean.class).category(OptionCategory.PROXY).defaultValue(Boolean.FALSE).build();
    public static final Option<Boolean> PROXY_X_FORWARDED_HEADER_ENABLED = new OptionBuilder<Boolean>("proxy-allow-x-forwarded-header", Boolean.class).category(OptionCategory.PROXY).defaultValue(Boolean.FALSE).build();

    public static enum Headers {
        forwarded,
        xforwarded;

    }

    public static enum Mode {
        none(false),
        edge,
        reencrypt,
        passthrough(false);

        private final boolean proxyHeadersEnabled;

        private Mode(boolean proxyHeadersEnabled) {
            this.proxyHeadersEnabled = proxyHeadersEnabled;
        }

        private Mode() {
            this(true);
        }

        public boolean isProxyHeadersEnabled() {
            return this.proxyHeadersEnabled;
        }
    }
}

