/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.httpclient.HttpClientBuilder;
import org.keycloak.connections.httpclient.HttpClientFactory;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.util.EnvUtil;
import org.keycloak.util.KeystoreUtil;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final Logger logger = Logger.getLogger(DefaultHttpClientFactory.class);
    private volatile CloseableHttpClient httpClient;

    public HttpClientProvider create(KeycloakSession session) {
        return new HttpClientProvider(){

            @Override
            public HttpClient getHttpClient() {
                return DefaultHttpClientFactory.this.httpClient;
            }

            public void close() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int postText(String uri, String text) throws IOException {
                HttpPost request = new HttpPost(uri);
                request.setEntity(EntityBuilder.create().setText(text).setContentType(ContentType.TEXT_PLAIN).build());
                CloseableHttpResponse response = DefaultHttpClientFactory.this.httpClient.execute((HttpUriRequest)request);
                try {
                    int n = response.getStatusLine().getStatusCode();
                    return n;
                }
                finally {
                    InputStream is;
                    HttpEntity entity = response.getEntity();
                    if (entity != null && (is = entity.getContent()) != null) {
                        is.close();
                    }
                }
            }

            @Override
            public InputStream get(String uri) throws IOException {
                HttpGet request = new HttpGet(uri);
                CloseableHttpResponse response = DefaultHttpClientFactory.this.httpClient.execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return null;
                }
                return entity.getContent();
            }
        };
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        long socketTimeout = config.getLong("socket-timeout-millis", Long.valueOf(-1L));
        long establishConnectionTimeout = config.getLong("establish-connection-timeout-millis", Long.valueOf(-1L));
        int maxPooledPerRoute = config.getInt("max-pooled-per-route", Integer.valueOf(0));
        int connectionPoolSize = config.getInt("connection-pool-size", Integer.valueOf(200));
        boolean disableTrustManager = config.getBoolean("disable-trust-manager", Boolean.valueOf(false));
        boolean disableCookies = config.getBoolean("disable-cookies", Boolean.valueOf(true));
        String hostnameVerificationPolicy = config.get("hostname-verification-policy", "WILDCARD");
        HttpClientBuilder.HostnameVerificationPolicy hostnamePolicy = HttpClientBuilder.HostnameVerificationPolicy.valueOf(hostnameVerificationPolicy);
        String truststore = config.get("truststore");
        String truststorePassword = config.get("truststore-password");
        String clientKeystore = config.get("client-keystore");
        String clientKeystorePassword = config.get("client-keystore-password");
        String clientPrivateKeyPassword = config.get("client-key-password");
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.socketTimeout(socketTimeout, TimeUnit.MILLISECONDS).establishConnectionTimeout(establishConnectionTimeout, TimeUnit.MILLISECONDS).maxPooledPerRoute(maxPooledPerRoute).connectionPoolSize(connectionPoolSize).hostnameVerification(hostnamePolicy).disableCookies(disableCookies);
        if (disableTrustManager) {
            builder.disableTrustManager();
        }
        if (truststore != null) {
            truststore = EnvUtil.replace((String)truststore);
            try {
                builder.trustStore(KeystoreUtil.loadKeyStore((String)truststore, (String)truststorePassword));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load truststore", e);
            }
        }
        if (clientKeystore != null) {
            clientKeystore = EnvUtil.replace((String)clientKeystore);
            try {
                KeyStore clientCertKeystore = KeystoreUtil.loadKeyStore((String)clientKeystore, (String)clientKeystorePassword);
                builder.keyStore(clientCertKeystore, clientPrivateKeyPassword);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load keystore", e);
            }
        }
        this.httpClient = builder.build();
    }

    public void postInit(KeycloakSessionFactory factory) {
    }
}

