/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.guides.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.guides.maven.Features;
import org.keycloak.guides.maven.Guide;
import org.keycloak.guides.maven.GuideParser;
import org.keycloak.guides.maven.Options;

public class Context {
    private File srcDir;
    private Options options;
    private Features features;
    private List<Guide> guides;

    public Context(File srcDir) throws IOException {
        this.srcDir = srcDir;
        this.options = new Options();
        this.features = new Features();
        this.guides = new LinkedList<Guide>();
        GuideParser parser = new GuideParser();
        Map<String, Integer> guidePriorities = this.loadPinnedGuides(new File(srcDir, "pinned-guides"));
        for (File f2 : srcDir.listFiles((dir, f) -> f.endsWith(".adoc") && !f.equals("index.adoc"))) {
            Guide guide = parser.parse(f2);
            if (guidePriorities != null) {
                Integer priority = guidePriorities.get(guide.getId());
                guide.setPriority(priority != null ? priority : Integer.MAX_VALUE);
            }
            if (guide == null) continue;
            this.guides.add(guide);
        }
        Collections.sort(this.guides, (o1, o2) -> {
            if (o1.getPriority() == o2.getPriority()) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
            return Integer.compare(o1.getPriority(), o2.getPriority());
        });
    }

    public Options getOptions() {
        return this.options;
    }

    public Features getFeatures() {
        return this.features;
    }

    public List<Guide> getGuides() {
        return this.guides;
    }

    private Map<String, Integer> loadPinnedGuides(File pinnedGuides) throws IOException {
        if (!pinnedGuides.isFile()) {
            return null;
        }
        HashMap<String, Integer> priorities = new HashMap<String, Integer>();
        try (BufferedReader br = new BufferedReader(new FileReader(pinnedGuides));){
            int c = 1;
            String l = br.readLine();
            while (l != null) {
                if (!(l = l.trim()).isEmpty()) {
                    priorities.put(l, c);
                }
                ++c;
                l = br.readLine();
            }
            HashMap<String, Integer> hashMap = priorities;
            return hashMap;
        }
    }
}

