/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.guides.maven;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.common.Profile;

public class Features {
    private List<Feature> features = Arrays.stream(Profile.Feature.values()).filter(f -> !f.getType().equals((Object)Profile.Type.EXPERIMENTAL)).map(f -> new Feature((Profile.Feature)f)).sorted(Comparator.comparing(Feature::getName)).collect(Collectors.toList());

    public List<Feature> getSupported() {
        return this.features.stream().filter(f -> ((Feature)f).getType().equals((Object)Profile.Type.DEFAULT)).collect(Collectors.toList());
    }

    public List<Feature> getSupportedDisabledByDefault() {
        return this.features.stream().filter(f -> ((Feature)f).getType().equals((Object)Profile.Type.DISABLED_BY_DEFAULT)).collect(Collectors.toList());
    }

    public List<Feature> getDeprecated() {
        return this.features.stream().filter(f -> ((Feature)f).getType().equals((Object)Profile.Type.DEPRECATED)).collect(Collectors.toList());
    }

    public List<Feature> getPreview() {
        return this.features.stream().filter(f -> ((Feature)f).getType().equals((Object)Profile.Type.PREVIEW)).collect(Collectors.toList());
    }

    public class Feature {
        private Profile.Feature profileFeature;

        public Feature(Profile.Feature profileFeature) {
            this.profileFeature = profileFeature;
        }

        public String getName() {
            return this.profileFeature.name().toLowerCase().replaceAll("_", "-");
        }

        public String getDescription() {
            return this.profileFeature.getLabel();
        }

        private Profile.Type getType() {
            return this.profileFeature.getType();
        }
    }
}

