/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.guides.maven;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.keycloak.guides.maven.GuideBuilder;

@Mojo(name="keycloak-guide", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GuideMojo
extends AbstractMojo {
    @Parameter(property="project.build.sourceDirectory")
    private String sourceDir;
    @Parameter(property="project.build.directory")
    private String targetDir;

    public void execute() throws MojoFailureException {
        try {
            Log log = this.getLog();
            File topDir = new File(this.sourceDir).getParentFile();
            for (File srcDir : topDir.listFiles(d -> d.isDirectory() && !d.getName().equals("templates"))) {
                File targetDir = new File(new File(this.targetDir, "generated-guides"), srcDir.getName());
                if (!targetDir.isDirectory()) {
                    targetDir.mkdirs();
                }
                if (srcDir.getName().equals("images")) {
                    FileUtils.copyDirectory((File)srcDir, (File)targetDir);
                    continue;
                }
                log.info((CharSequence)("Guide dir: " + srcDir.getAbsolutePath()));
                log.info((CharSequence)("Target dir: " + targetDir.getAbsolutePath()));
                GuideBuilder g = new GuideBuilder(srcDir, targetDir, log);
                g.build();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException("Failed to generated asciidoc files", (Throwable)e);
        }
    }
}

