/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.guides.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ArrayUtils;
import org.keycloak.config.ConfigSupportLevel;
import org.keycloak.config.DeprecatedMetadata;
import org.keycloak.config.OptionCategory;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.Spi;
import org.keycloak.quarkus.runtime.Providers;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public class Options {
    private final Map<String, Option> options;
    private final Map<String, Map<String, List<Option>>> providerOptions = new LinkedHashMap<String, Map<String, List<Option>>>();

    public Options() {
        this.options = PropertyMappers.getMappers().stream().filter(m -> !m.isHidden()).filter(propertyMapper -> Objects.nonNull(propertyMapper.getDescription())).map(m -> new Option(m.getFrom(), m.getCategory(), m.isBuildTime(), null, m.getDescription(), m.getDefaultValue().map(Object::toString).orElse(null), m.getExpectedValues(), m.getDeprecatedMetadata().orElse(null))).sorted(Comparator.comparing(Option::getKey)).collect(Collectors.toMap(Option::getKey, o -> o, (o1, o2) -> o1, LinkedHashMap::new));
        ProviderManager providerManager = Providers.getProviderManager((ClassLoader)Thread.currentThread().getContextClassLoader());
        this.options.forEach((s, option) -> {
            option.description = option.description.replaceAll("'([^ ]*)'", "`$1`");
        });
        for (Spi loadSpi : providerManager.loadSpis().stream().sorted(Comparator.comparing(Spi::getName)).collect(Collectors.toList())) {
            for (ProviderFactory providerFactory : providerManager.load(loadSpi).stream().sorted(Comparator.comparing(ProviderFactory::getId)).collect(Collectors.toList())) {
                List configMetadata = providerFactory.getConfigMetadata();
                if (configMetadata == null) continue;
                String optionPrefix = "kc." + String.join((CharSequence)Configuration.OPTION_PART_SEPARATOR, (CharSequence[])ArrayUtils.insert((int)0, (Object[])new String[]{loadSpi.getName(), providerFactory.getId()}, (Object[])new String[]{"spi"}));
                List<Option> options = configMetadata.stream().map(m -> new Option(Configuration.toDashCase((String)(optionPrefix.concat("-") + m.getName())), OptionCategory.GENERAL, false, m.getType(), m.getHelpText(), m.getDefaultValue() == null ? null : m.getDefaultValue().toString(), m.getOptions() == null ? Collections.emptyList() : m.getOptions(), null)).sorted(Comparator.comparing(Option::getKey)).collect(Collectors.toList());
                ArrayList<String> booleanValues = new ArrayList<String>();
                booleanValues.add("true");
                booleanValues.add("false");
                options.forEach(option -> {
                    if (option.type.equals("boolean")) {
                        option.expectedValues = booleanValues;
                    }
                    option.description = option.description.replaceAll("'([^ ]*)'", "`$1`");
                });
                if (options.isEmpty()) continue;
                this.providerOptions.computeIfAbsent(Configuration.toDashCase((String)loadSpi.getName()), k -> new LinkedHashMap()).put(Configuration.toDashCase((String)providerFactory.getId()), options);
            }
        }
    }

    public List<OptionCategory> getCategories() {
        return Arrays.stream(OptionCategory.values()).filter(c -> c.getSupportLevel() != ConfigSupportLevel.EXPERIMENTAL).collect(Collectors.toList());
    }

    public Collection<Option> getValues() {
        return this.options.values();
    }

    public Collection<Option> getValues(OptionCategory category) {
        return this.options.values().stream().filter(o -> o.category.equals((Object)category)).collect(Collectors.toList());
    }

    public Option getOption(String key) {
        return this.options.get(key);
    }

    public List<Option> getOptions(String includeOptions) {
        String r = includeOptions.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*").replace(' ', '|');
        return this.options.values().stream().filter(o -> o.getKey().matches(r)).collect(Collectors.toList());
    }

    public Map<String, Map<String, List<Option>>> getProviderOptions() {
        return this.providerOptions;
    }

    public class Option {
        private String key;
        private OptionCategory category;
        private boolean build;
        private String type;
        private String description;
        private String defaultValue;
        private List<String> expectedValues;
        private DeprecatedMetadata deprecated;

        public Option(String key, OptionCategory category, boolean build, String type, String description, String defaultValue, Iterable<String> expectedValues, DeprecatedMetadata deprecatedMetadata) {
            this.key = key;
            this.category = category;
            this.build = build;
            this.type = type;
            this.description = description;
            this.defaultValue = defaultValue;
            this.expectedValues = StreamSupport.stream(expectedValues.spliterator(), false).collect(Collectors.toList());
            this.deprecated = deprecatedMetadata;
        }

        public boolean isBuild() {
            return this.build;
        }

        public String getKey() {
            return this.key.substring(3);
        }

        public String getType() {
            return this.type;
        }

        public String getKeyCli() {
            return "--" + this.key.substring(3).replace('.', '-');
        }

        public String getKeyEnv() {
            return this.key.toUpperCase().replace('.', '_').replace('-', '_');
        }

        public String getDescription() {
            int i = this.description.indexOf(46);
            if (i == -1) {
                return this.description;
            }
            return this.description.substring(0, i + 1).trim();
        }

        public String getDescriptionExtended() {
            int i = this.description.indexOf(46);
            if (i == -1) {
                return null;
            }
            String extended = this.description.substring(i + 1).trim();
            return extended.length() > 0 ? extended : null;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public List<String> getExpectedValues() {
            return this.expectedValues;
        }

        public DeprecatedMetadata getDeprecated() {
            return this.deprecated;
        }
    }
}

