/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.guides.maven;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class DirectoryCopyVisitor
extends SimpleFileVisitor<Path> {
    private Path targetDir;
    private Path sourceDir;

    public DirectoryCopyVisitor(Path targetDir) {
        this.targetDir = targetDir;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.sourceDir == null) {
            this.sourceDir = dir;
        } else {
            Path relativePath = this.sourceDir.relativize(dir);
            Files.createDirectories(this.targetDir.resolve(relativePath), new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path relativePath = this.sourceDir.relativize(file);
        Files.copy(file, this.targetDir.resolve(relativePath), StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }
}

