/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.enums.SslRequired;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RealmAdapter
implements RealmModel {
    protected CachedRealm cached;
    protected CacheRealmProvider cacheSession;
    protected RealmModel updated;
    protected RealmCache cache;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;

    public RealmAdapter(CachedRealm cached, CacheRealmProvider cacheSession) {
        this.cached = cached;
        this.cacheSession = cacheSession;
    }

    protected void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerRealmInvalidation(this.getId());
            this.updated = this.cacheSession.getDelegate().getRealm(this.getId());
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public String getId() {
        if (this.updated != null) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getName() {
        if (this.updated != null) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public boolean isEnabled() {
        if (this.updated != null) {
            return this.updated.isEnabled();
        }
        return this.cached.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEnabled(enabled);
    }

    public SslRequired getSslRequired() {
        if (this.updated != null) {
            return this.updated.getSslRequired();
        }
        return this.cached.getSslRequired();
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.getDelegateForUpdate();
        this.updated.setSslRequired(sslRequired);
    }

    public boolean isRegistrationAllowed() {
        if (this.updated != null) {
            return this.updated.isRegistrationAllowed();
        }
        return this.cached.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationAllowed(registrationAllowed);
    }

    public boolean isPasswordCredentialGrantAllowed() {
        if (this.updated != null) {
            return this.updated.isPasswordCredentialGrantAllowed();
        }
        return this.cached.isPasswordCredentialGrantAllowed();
    }

    public void setPasswordCredentialGrantAllowed(boolean passwordCredentialGrantAllowed) {
        this.getDelegateForUpdate();
        this.updated.setPasswordCredentialGrantAllowed(passwordCredentialGrantAllowed);
    }

    public boolean isRememberMe() {
        if (this.updated != null) {
            return this.updated.isRememberMe();
        }
        return this.cached.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.getDelegateForUpdate();
        this.updated.setRememberMe(rememberMe);
    }

    public boolean isBruteForceProtected() {
        if (this.updated != null) {
            return this.updated.isBruteForceProtected();
        }
        return this.cached.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.getDelegateForUpdate();
        this.updated.setBruteForceProtected(value);
    }

    public int getMaxFailureWaitSeconds() {
        if (this.updated != null) {
            return this.updated.getMaxFailureWaitSeconds();
        }
        return this.cached.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMaxFailureWaitSeconds(val);
    }

    public int getWaitIncrementSeconds() {
        if (this.updated != null) {
            return this.updated.getWaitIncrementSeconds();
        }
        return this.cached.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setWaitIncrementSeconds(val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        if (this.updated != null) {
            return this.updated.getMinimumQuickLoginWaitSeconds();
        }
        return this.cached.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMinimumQuickLoginWaitSeconds(val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        if (this.updated != null) {
            return this.updated.getQuickLoginCheckMilliSeconds();
        }
        return this.cached.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.getDelegateForUpdate();
        this.updated.setQuickLoginCheckMilliSeconds(val);
    }

    public int getMaxDeltaTimeSeconds() {
        if (this.updated != null) {
            return this.updated.getMaxDeltaTimeSeconds();
        }
        return this.cached.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMaxDeltaTimeSeconds(val);
    }

    public int getFailureFactor() {
        if (this.updated != null) {
            return this.updated.getFailureFactor();
        }
        return this.cached.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.getDelegateForUpdate();
        this.updated.setFailureFactor(failureFactor);
    }

    public boolean isVerifyEmail() {
        if (this.updated != null) {
            return this.updated.isVerifyEmail();
        }
        return this.cached.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.getDelegateForUpdate();
        this.updated.setVerifyEmail(verifyEmail);
    }

    public boolean isResetPasswordAllowed() {
        if (this.updated != null) {
            return this.updated.isResetPasswordAllowed();
        }
        return this.cached.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.getDelegateForUpdate();
        this.updated.setResetPasswordAllowed(resetPasswordAllowed);
    }

    public int getSsoSessionIdleTimeout() {
        if (this.updated != null) {
            return this.updated.getSsoSessionIdleTimeout();
        }
        return this.cached.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        if (this.updated != null) {
            return this.updated.getSsoSessionMaxLifespan();
        }
        return this.cached.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setSsoSessionMaxLifespan(seconds);
    }

    public int getAccessTokenLifespan() {
        if (this.updated != null) {
            return this.updated.getAccessTokenLifespan();
        }
        return this.cached.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessTokenLifespan(seconds);
    }

    public int getAccessCodeLifespan() {
        if (this.updated != null) {
            return this.updated.getAccessCodeLifespan();
        }
        return this.cached.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespan(seconds);
    }

    public int getAccessCodeLifespanUserAction() {
        if (this.updated != null) {
            return this.updated.getAccessCodeLifespanUserAction();
        }
        return this.cached.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespanUserAction(seconds);
    }

    public String getPublicKeyPem() {
        if (this.updated != null) {
            return this.updated.getPublicKeyPem();
        }
        return this.cached.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.getDelegateForUpdate();
        this.updated.setPublicKeyPem(publicKeyPem);
    }

    public String getPrivateKeyPem() {
        if (this.updated != null) {
            return this.updated.getPrivateKeyPem();
        }
        return this.cached.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.getDelegateForUpdate();
        this.updated.setPrivateKeyPem(privateKeyPem);
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        LinkedList<RequiredCredentialModel> copy = new LinkedList<RequiredCredentialModel>();
        if (this.updated != null) {
            copy.addAll(this.updated.getRequiredCredentials());
        } else {
            copy.addAll(this.cached.getRequiredCredentials());
        }
        return copy;
    }

    public void addRequiredCredential(String cred) {
        this.getDelegateForUpdate();
        this.updated.addRequiredCredential(cred);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.updated != null) {
            return this.updated.getPasswordPolicy();
        }
        return this.cached.getPasswordPolicy();
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.getDelegateForUpdate();
        this.updated.setPasswordPolicy(policy);
    }

    public RoleModel getRoleById(String id) {
        if (this.updated != null) {
            return this.updated.getRoleById(id);
        }
        return this.cacheSession.getRoleById(id, this);
    }

    public List<String> getDefaultRoles() {
        if (this.updated != null) {
            return this.updated.getDefaultRoles();
        }
        return this.cached.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        this.getDelegateForUpdate();
        this.updated.addDefaultRole(name);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        this.getDelegateForUpdate();
        this.updated.updateDefaultRoles(defaultRoles);
    }

    public ClientModel findClient(String clientId) {
        if (this.updated != null) {
            return this.updated.findClient(clientId);
        }
        String appId = this.cached.getApplications().get(clientId);
        if (appId != null) {
            return this.cacheSession.getApplicationById(appId, this);
        }
        String oauth = this.cached.getClients().get(clientId);
        if (oauth != null) {
            return this.cacheSession.getOAuthClientById(oauth, this);
        }
        return null;
    }

    public Map<String, ApplicationModel> getApplicationNameMap() {
        if (this.updated != null) {
            return this.updated.getApplicationNameMap();
        }
        HashMap<String, ApplicationModel> map = new HashMap<String, ApplicationModel>();
        for (String id : this.cached.getApplications().values()) {
            ApplicationModel model = this.cacheSession.getApplicationById(id, this);
            if (model == null) {
                throw new IllegalStateException("Cached application not found: " + id);
            }
            map.put(model.getName(), model);
        }
        return map;
    }

    public List<ApplicationModel> getApplications() {
        if (this.updated != null) {
            return this.updated.getApplications();
        }
        LinkedList<ApplicationModel> apps = new LinkedList<ApplicationModel>();
        for (String id : this.cached.getApplications().values()) {
            ApplicationModel model = this.cacheSession.getApplicationById(id, this);
            if (model == null) {
                throw new IllegalStateException("Cached application not found: " + id);
            }
            apps.add(model);
        }
        return apps;
    }

    public ApplicationModel addApplication(String name) {
        this.getDelegateForUpdate();
        ApplicationModel app = this.updated.addApplication(name);
        this.cacheSession.registerApplicationInvalidation(app.getId());
        return app;
    }

    public ApplicationModel addApplication(String id, String name) {
        this.getDelegateForUpdate();
        ApplicationModel app = this.updated.addApplication(id, name);
        this.cacheSession.registerApplicationInvalidation(app.getId());
        return app;
    }

    public boolean removeApplication(String id) {
        this.cacheSession.registerApplicationInvalidation(id);
        this.getDelegateForUpdate();
        return this.updated.removeApplication(id);
    }

    public ApplicationModel getApplicationById(String id) {
        if (this.updated != null) {
            return this.updated.getApplicationById(id);
        }
        return this.cacheSession.getApplicationById(id, this);
    }

    public ApplicationModel getApplicationByName(String name) {
        if (this.updated != null) {
            return this.updated.getApplicationByName(name);
        }
        String id = this.cached.getApplications().get(name);
        if (id == null) {
            return null;
        }
        return this.getApplicationById(id);
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.getDelegateForUpdate();
        this.updated.updateRequiredCredentials(creds);
    }

    public boolean isSocial() {
        if (this.updated != null) {
            return this.updated.isSocial();
        }
        return this.cached.isSocial();
    }

    public void setSocial(boolean social) {
        this.getDelegateForUpdate();
        this.updated.setSocial(social);
    }

    public boolean isUpdateProfileOnInitialSocialLogin() {
        if (this.updated != null) {
            return this.updated.isUpdateProfileOnInitialSocialLogin();
        }
        return this.cached.isUpdateProfileOnInitialSocialLogin();
    }

    public void setUpdateProfileOnInitialSocialLogin(boolean updateProfileOnInitialSocialLogin) {
        this.getDelegateForUpdate();
        this.updated.setUpdateProfileOnInitialSocialLogin(updateProfileOnInitialSocialLogin);
    }

    public OAuthClientModel addOAuthClient(String name) {
        this.getDelegateForUpdate();
        OAuthClientModel client = this.updated.addOAuthClient(name);
        this.cacheSession.registerOAuthClientInvalidation(client.getId());
        return client;
    }

    public OAuthClientModel addOAuthClient(String id, String name) {
        this.getDelegateForUpdate();
        OAuthClientModel client = this.updated.addOAuthClient(id, name);
        this.cacheSession.registerOAuthClientInvalidation(client.getId());
        return client;
    }

    public OAuthClientModel getOAuthClient(String name) {
        if (this.updated != null) {
            return this.updated.getOAuthClient(name);
        }
        String id = this.cached.getClients().get(name);
        if (id == null) {
            return null;
        }
        return this.getOAuthClientById(id);
    }

    public OAuthClientModel getOAuthClientById(String id) {
        if (this.updated != null) {
            return this.updated.getOAuthClientById(id);
        }
        return this.cacheSession.getOAuthClientById(id, this);
    }

    public boolean removeOAuthClient(String id) {
        this.cacheSession.registerOAuthClientInvalidation(id);
        this.getDelegateForUpdate();
        return this.updated.removeOAuthClient(id);
    }

    public List<OAuthClientModel> getOAuthClients() {
        if (this.updated != null) {
            return this.updated.getOAuthClients();
        }
        LinkedList<OAuthClientModel> clients = new LinkedList<OAuthClientModel>();
        for (String id : this.cached.getClients().values()) {
            OAuthClientModel model = this.cacheSession.getOAuthClientById(id, this);
            if (model == null) {
                throw new IllegalStateException("Cached oauth client not found: " + id);
            }
            clients.add(model);
        }
        return clients;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        if (this.updated != null) {
            return this.updated.getBrowserSecurityHeaders();
        }
        return this.cached.getBrowserSecurityHeaders();
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        this.getDelegateForUpdate();
        this.updated.setBrowserSecurityHeaders(headers);
    }

    public Map<String, String> getSmtpConfig() {
        if (this.updated != null) {
            return this.updated.getSmtpConfig();
        }
        return this.cached.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.getDelegateForUpdate();
        this.updated.setSmtpConfig(smtpConfig);
    }

    public Map<String, String> getSocialConfig() {
        if (this.updated != null) {
            return this.updated.getSocialConfig();
        }
        return this.cached.getSocialConfig();
    }

    public void setSocialConfig(Map<String, String> socialConfig) {
        this.getDelegateForUpdate();
        this.updated.setSocialConfig(socialConfig);
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        if (this.updated != null) {
            return this.updated.getUserFederationProviders();
        }
        return this.cached.getUserFederationProviders();
    }

    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        this.getDelegateForUpdate();
        this.updated.setUserFederationProviders(providers);
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        this.getDelegateForUpdate();
        return this.updated.addUserFederationProvider(providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        this.getDelegateForUpdate();
        this.updated.removeUserFederationProvider(provider);
    }

    public void updateUserFederationProvider(UserFederationProviderModel provider) {
        this.getDelegateForUpdate();
        this.updated.updateUserFederationProvider(provider);
    }

    public String getLoginTheme() {
        if (this.updated != null) {
            return this.updated.getLoginTheme();
        }
        return this.cached.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setLoginTheme(name);
    }

    public String getAccountTheme() {
        if (this.updated != null) {
            return this.updated.getAccountTheme();
        }
        return this.cached.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setAccountTheme(name);
    }

    public String getAdminTheme() {
        if (this.updated != null) {
            return this.updated.getAdminTheme();
        }
        return this.cached.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setAdminTheme(name);
    }

    public String getEmailTheme() {
        if (this.updated != null) {
            return this.updated.getEmailTheme();
        }
        return this.cached.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setEmailTheme(name);
    }

    public int getNotBefore() {
        if (this.updated != null) {
            return this.updated.getNotBefore();
        }
        return this.cached.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getDelegateForUpdate();
        this.updated.setNotBefore(notBefore);
    }

    public boolean removeRoleById(String id) {
        this.cacheSession.registerRoleInvalidation(id);
        this.getDelegateForUpdate();
        return this.updated.removeRoleById(id);
    }

    public boolean isEventsEnabled() {
        if (this.updated != null) {
            return this.updated.isEventsEnabled();
        }
        return this.cached.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEventsEnabled(enabled);
    }

    public long getEventsExpiration() {
        if (this.updated != null) {
            return this.updated.getEventsExpiration();
        }
        return this.cached.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.getDelegateForUpdate();
        this.updated.setEventsExpiration(expiration);
    }

    public Set<String> getEventsListeners() {
        if (this.updated != null) {
            return this.updated.getEventsListeners();
        }
        return this.cached.getEventsListeners();
    }

    public void setEventsListeners(Set<String> listeners) {
        this.getDelegateForUpdate();
        this.updated.setEventsListeners(listeners);
    }

    public ApplicationModel getMasterAdminApp() {
        return this.cacheSession.getRealm(Config.getAdminRealm()).getApplicationById(this.cached.getMasterAdminApp());
    }

    public void setMasterAdminApp(ApplicationModel app) {
        this.getDelegateForUpdate();
        this.updated.setMasterAdminApp(app);
    }

    public RoleModel getRole(String name) {
        if (this.updated != null) {
            return this.updated.getRole(name);
        }
        String id = this.cached.getRealmRoles().get(name);
        if (id == null) {
            return null;
        }
        return this.cacheSession.getRoleById(id, this);
    }

    public RoleModel addRole(String name) {
        this.getDelegateForUpdate();
        RoleModel role = this.updated.addRole(name);
        this.cacheSession.registerRoleInvalidation(role.getId());
        return role;
    }

    public RoleModel addRole(String id, String name) {
        this.getDelegateForUpdate();
        RoleModel role = this.updated.addRole(id, name);
        this.cacheSession.registerRoleInvalidation(role.getId());
        return role;
    }

    public boolean removeRole(RoleModel role) {
        this.cacheSession.registerRoleInvalidation(role.getId());
        this.getDelegateForUpdate();
        return this.updated.removeRole(role);
    }

    public Set<RoleModel> getRoles() {
        if (this.updated != null) {
            return this.updated.getRoles();
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.cached.getRealmRoles().values()) {
            RoleModel roleById = this.cacheSession.getRoleById(id, this);
            if (roleById == null) continue;
            roles.add(roleById);
        }
        return roles;
    }

    public ClientModel findClientById(String id) {
        ApplicationModel model = this.getApplicationById(id);
        if (model != null) {
            return model;
        }
        return this.getOAuthClientById(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

