/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.RealmCache;

public class CachedClient {
    protected String id;
    protected String name;
    protected String realm;
    protected long allowedClaimsMask;
    protected Set<String> redirectUris = new HashSet<String>();
    protected boolean enabled;
    protected String secret;
    protected boolean publicClient;
    protected boolean fullScopeAllowed;
    protected boolean directGrantsOnly;
    protected int notBefore;
    protected Set<String> scope = new HashSet<String>();
    protected Set<String> webOrigins = new HashSet<String>();

    public CachedClient(RealmCache cache, RealmProvider delegate, RealmModel realm, ClientModel model) {
        this.id = model.getId();
        this.secret = model.getSecret();
        this.name = model.getClientId();
        this.realm = realm.getId();
        this.enabled = model.isEnabled();
        this.notBefore = model.getNotBefore();
        this.directGrantsOnly = model.isDirectGrantsOnly();
        this.publicClient = model.isPublicClient();
        this.allowedClaimsMask = model.getAllowedClaimsMask();
        this.fullScopeAllowed = model.isFullScopeAllowed();
        this.redirectUris.addAll(model.getRedirectUris());
        this.webOrigins.addAll(model.getWebOrigins());
        for (RoleModel role : model.getScopeMappings()) {
            this.scope.add(role.getId());
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getRealm() {
        return this.realm;
    }

    public long getAllowedClaimsMask() {
        return this.allowedClaimsMask;
    }

    public Set<String> getRedirectUris() {
        return this.redirectUris;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public boolean isDirectGrantsOnly() {
        return this.directGrantsOnly;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public Set<String> getWebOrigins() {
        return this.webOrigins;
    }

    public boolean isFullScopeAllowed() {
        return this.fullScopeAllowed;
    }
}

