/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.ClientAdapter;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedApplication;

public class ApplicationAdapter
extends ClientAdapter
implements ApplicationModel {
    protected ApplicationModel updated;
    protected CachedApplication cached;

    public ApplicationAdapter(RealmModel cachedRealm, CachedApplication cached, CacheRealmProvider cacheSession, RealmCache cache) {
        super(cachedRealm, cached, cache, cacheSession);
        this.cached = cached;
    }

    @Override
    protected void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerApplicationInvalidation(this.getId());
            this.updated = this.cacheSession.getDelegate().getApplicationById(this.getId(), this.cachedRealm);
            this.updatedClient = this.updated;
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public void updateApplication() {
        if (this.updated != null) {
            this.updated.updateApplication();
        }
    }

    public String getName() {
        if (this.updated != null) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    @Override
    public String getClientId() {
        return this.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public boolean isSurrogateAuthRequired() {
        if (this.updated != null) {
            return this.updated.isSurrogateAuthRequired();
        }
        return this.cached.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.getDelegateForUpdate();
        this.updated.setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public String getManagementUrl() {
        if (this.updated != null) {
            return this.updated.getManagementUrl();
        }
        return this.cached.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.getDelegateForUpdate();
        this.updated.setManagementUrl(url);
    }

    public String getBaseUrl() {
        if (this.updated != null) {
            return this.updated.getBaseUrl();
        }
        return this.cached.getBaseUrl();
    }

    public void setBaseUrl(String url) {
        this.getDelegateForUpdate();
        this.updated.setBaseUrl(url);
    }

    public List<String> getDefaultRoles() {
        if (this.updated != null) {
            return this.updated.getDefaultRoles();
        }
        return this.cached.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        this.getDelegateForUpdate();
        this.updated.addDefaultRole(name);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        this.getDelegateForUpdate();
        this.updated.updateDefaultRoles(defaultRoles);
    }

    public Set<RoleModel> getApplicationScopeMappings(ClientModel client) {
        Set roleMappings = client.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ApplicationModel app;
            RoleContainerModel container = role.getContainer();
            if (container instanceof RealmModel || !(app = (ApplicationModel)container).getId().equals(this.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public boolean isBearerOnly() {
        if (this.updated != null) {
            return this.updated.isBearerOnly();
        }
        return this.cached.isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.getDelegateForUpdate();
        this.updated.setBearerOnly(only);
    }

    public RoleModel getRole(String name) {
        if (this.updated != null) {
            return this.updated.getRole(name);
        }
        String id = this.cached.getRoles().get(name);
        if (id == null) {
            return null;
        }
        return this.cacheSession.getRoleById(id, this.cachedRealm);
    }

    public RoleModel addRole(String name) {
        this.getDelegateForUpdate();
        RoleModel role = this.updated.addRole(name);
        this.cacheSession.registerRoleInvalidation(role.getId());
        return role;
    }

    public RoleModel addRole(String id, String name) {
        this.getDelegateForUpdate();
        RoleModel role = this.updated.addRole(id, name);
        this.cacheSession.registerRoleInvalidation(role.getId());
        return role;
    }

    public boolean removeRole(RoleModel role) {
        this.cacheSession.registerRoleInvalidation(role.getId());
        this.getDelegateForUpdate();
        return this.updated.removeRole(role);
    }

    public Set<RoleModel> getRoles() {
        if (this.updated != null) {
            return this.updated.getRoles();
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.cached.getRoles().values()) {
            RoleModel roleById = this.cacheSession.getRoleById(id, this.cachedRealm);
            if (roleById == null) continue;
            roles.add(roleById);
        }
        return roles;
    }

    @Override
    public boolean hasScope(RoleModel role) {
        if (super.hasScope(role)) {
            return true;
        }
        Set<RoleModel> roles = this.getRoles();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ApplicationModel)) {
            return false;
        }
        ApplicationModel that = (ApplicationModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

