/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedApplicationRole;
import org.keycloak.models.cache.entities.CachedClient;

public class CachedApplication
extends CachedClient {
    private boolean surrogateAuthRequired;
    private String managementUrl;
    private String baseUrl;
    private List<String> defaultRoles = new LinkedList<String>();
    private boolean bearerOnly;
    private Map<String, String> roles = new HashMap<String, String>();
    private int nodeReRegistrationTimeout;
    private Map<String, Integer> registeredNodes;

    public CachedApplication(RealmCache cache, RealmProvider delegate, RealmModel realm, ApplicationModel model) {
        super(cache, delegate, realm, (ClientModel)model);
        this.surrogateAuthRequired = model.isSurrogateAuthRequired();
        this.managementUrl = model.getManagementUrl();
        this.baseUrl = model.getBaseUrl();
        this.defaultRoles.addAll(model.getDefaultRoles());
        this.bearerOnly = model.isBearerOnly();
        for (RoleModel role : model.getRoles()) {
            this.roles.put(role.getName(), role.getId());
            cache.addCachedRole(new CachedApplicationRole(this.id, role, realm));
        }
        this.nodeReRegistrationTimeout = model.getNodeReRegistrationTimeout();
        this.registeredNodes = new TreeMap<String, Integer>(model.getRegisteredNodes());
    }

    public boolean isSurrogateAuthRequired() {
        return this.surrogateAuthRequired;
    }

    public String getManagementUrl() {
        return this.managementUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    public boolean isBearerOnly() {
        return this.bearerOnly;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public int getNodeReRegistrationTimeout() {
        return this.nodeReRegistrationTimeout;
    }

    public Map<String, Integer> getRegisteredNodes() {
        return this.registeredNodes;
    }
}

