/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.List;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.CacheRealmProvider;

public class NoCacheRealmProvider
implements CacheRealmProvider {
    protected KeycloakSession session;
    protected RealmProvider delegate;

    public NoCacheRealmProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public RealmProvider getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = (RealmProvider)this.session.getProvider(RealmProvider.class);
        return this.delegate;
    }

    @Override
    public void registerRealmInvalidation(String id) {
    }

    @Override
    public void registerApplicationInvalidation(String id) {
    }

    @Override
    public void registerRoleInvalidation(String id) {
    }

    public MigrationModel getMigrationModel() {
        return this.getDelegate().getMigrationModel();
    }

    public RealmModel createRealm(String name) {
        return this.getDelegate().createRealm(name);
    }

    public RealmModel createRealm(String id, String name) {
        return this.getDelegate().createRealm(id, name);
    }

    public RealmModel getRealm(String id) {
        return this.getDelegate().getRealm(id);
    }

    public RealmModel getRealmByName(String name) {
        return this.getDelegate().getRealmByName(name);
    }

    public List<RealmModel> getRealms() {
        return this.getDelegate().getRealms();
    }

    public boolean removeRealm(String id) {
        return this.getDelegate().removeRealm(id);
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        return this.getDelegate().getRoleById(id, realm);
    }

    public ClientModel getClientById(String id, RealmModel realm) {
        return this.getDelegate().getClientById(id, realm);
    }
}

