/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedClientRole;

public class CachedClient
implements Serializable {
    private String id;
    private String clientId;
    private String name;
    private String description;
    private String realm;
    private Set<String> redirectUris = new HashSet<String>();
    private boolean enabled;
    private String clientAuthenticatorType;
    private String secret;
    private String registrationToken;
    private String protocol;
    private Map<String, String> attributes = new HashMap<String, String>();
    private boolean publicClient;
    private boolean fullScopeAllowed;
    private boolean frontchannelLogout;
    private int notBefore;
    private Set<String> scope = new HashSet<String>();
    private Set<String> webOrigins = new HashSet<String>();
    private Set<ProtocolMapperModel> protocolMappers = new HashSet<ProtocolMapperModel>();
    private boolean surrogateAuthRequired;
    private String managementUrl;
    private String rootUrl;
    private String baseUrl;
    private List<String> defaultRoles = new LinkedList<String>();
    private boolean bearerOnly;
    private boolean consentRequired;
    private boolean standardFlowEnabled;
    private boolean implicitFlowEnabled;
    private boolean directAccessGrantsEnabled;
    private boolean serviceAccountsEnabled;
    private Map<String, String> roles = new HashMap<String, String>();
    private int nodeReRegistrationTimeout;
    private Map<String, Integer> registeredNodes;

    public CachedClient(RealmCache cache, RealmProvider delegate, RealmModel realm, ClientModel model) {
        this.id = model.getId();
        this.clientAuthenticatorType = model.getClientAuthenticatorType();
        this.secret = model.getSecret();
        this.registrationToken = model.getRegistrationToken();
        this.clientId = model.getClientId();
        this.name = model.getName();
        this.description = model.getDescription();
        this.realm = realm.getId();
        this.enabled = model.isEnabled();
        this.protocol = model.getProtocol();
        this.attributes.putAll(model.getAttributes());
        this.notBefore = model.getNotBefore();
        this.frontchannelLogout = model.isFrontchannelLogout();
        this.publicClient = model.isPublicClient();
        this.fullScopeAllowed = model.isFullScopeAllowed();
        this.redirectUris.addAll(model.getRedirectUris());
        this.webOrigins.addAll(model.getWebOrigins());
        for (RoleModel role : model.getScopeMappings()) {
            this.scope.add(role.getId());
        }
        for (ProtocolMapperModel mapper : model.getProtocolMappers()) {
            this.protocolMappers.add(mapper);
        }
        this.surrogateAuthRequired = model.isSurrogateAuthRequired();
        this.managementUrl = model.getManagementUrl();
        this.rootUrl = model.getRootUrl();
        this.baseUrl = model.getBaseUrl();
        this.defaultRoles.addAll(model.getDefaultRoles());
        this.bearerOnly = model.isBearerOnly();
        this.consentRequired = model.isConsentRequired();
        this.standardFlowEnabled = model.isStandardFlowEnabled();
        this.implicitFlowEnabled = model.isImplicitFlowEnabled();
        this.directAccessGrantsEnabled = model.isDirectAccessGrantsEnabled();
        this.serviceAccountsEnabled = model.isServiceAccountsEnabled();
        for (RoleModel role : model.getRoles()) {
            this.roles.put(role.getName(), role.getId());
            cache.addCachedRole(new CachedClientRole(this.id, role, realm));
        }
        this.nodeReRegistrationTimeout = model.getNodeReRegistrationTimeout();
        this.registeredNodes = new TreeMap<String, Integer>(model.getRegisteredNodes());
    }

    public String getId() {
        return this.id;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRealm() {
        return this.realm;
    }

    public Set<String> getRedirectUris() {
        return this.redirectUris;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getClientAuthenticatorType() {
        return this.clientAuthenticatorType;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getRegistrationToken() {
        return this.registrationToken;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public Set<String> getWebOrigins() {
        return this.webOrigins;
    }

    public boolean isFullScopeAllowed() {
        return this.fullScopeAllowed;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isFrontchannelLogout() {
        return this.frontchannelLogout;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        return this.protocolMappers;
    }

    public boolean isSurrogateAuthRequired() {
        return this.surrogateAuthRequired;
    }

    public String getManagementUrl() {
        return this.managementUrl;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    public boolean isBearerOnly() {
        return this.bearerOnly;
    }

    public boolean isConsentRequired() {
        return this.consentRequired;
    }

    public boolean isStandardFlowEnabled() {
        return this.standardFlowEnabled;
    }

    public boolean isImplicitFlowEnabled() {
        return this.implicitFlowEnabled;
    }

    public boolean isDirectAccessGrantsEnabled() {
        return this.directAccessGrantsEnabled;
    }

    public boolean isServiceAccountsEnabled() {
        return this.serviceAccountsEnabled;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public int getNodeReRegistrationTimeout() {
        return this.nodeReRegistrationTimeout;
    }

    public Map<String, Integer> getRegisteredNodes() {
        return this.registeredNodes;
    }
}

