/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.ipatuura_user_spi;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.component.ComponentModel;
import org.keycloak.ipatuura_user_spi.schemas.SCIMSearchRequest;
import org.keycloak.ipatuura_user_spi.schemas.SCIMUser;
import org.keycloak.models.KeycloakSession;

public class Ipatuura {
    private static final Logger logger = Logger.getLogger(Ipatuura.class);
    private final ComponentModel model;
    public static final String SCHEMA_CORE_USER = "urn:ietf:params:scim:schemas:core:2.0:User";
    public static final String SCHEMA_API_MESSAGES_SEARCHREQUEST = "urn:ietf:params:scim:api:messages:2.0:SearchRequest";
    String sessionid_cookie;
    String csrf_cookie;
    String csrf_value;
    Boolean logged_in = false;
    private final KeycloakSession session;

    public Ipatuura(KeycloakSession session, ComponentModel model) {
        this.model = model;
        this.session = session;
    }

    private void parseSetCookie(SimpleHttp.Response response) throws IOException {
        List setCookieHeaders = response.getHeader("Set-Cookie");
        for (String h : setCookieHeaders) {
            String[] kv;
            for (String s : kv = h.split(";")) {
                if (s.contains("csrftoken")) {
                    this.csrf_cookie = s;
                    this.csrf_value = s.substring(s.lastIndexOf("=") + 1);
                    continue;
                }
                if (!s.contains("sessionid")) continue;
                this.sessionid_cookie = s;
                this.csrf_cookie = this.csrf_cookie + String.format("; %s", this.sessionid_cookie);
            }
        }
    }

    public Integer csrfAuthLogin() {
        SimpleHttp.Response response;
        String server = (String)this.model.getConfig().getFirst((Object)"scimurl");
        String username = (String)this.model.getConfig().getFirst((Object)"loginusername");
        String password = (String)this.model.getConfig().getFirst((Object)"loginpassword");
        String url = String.format("https://%s%s", server, "/admin/login/");
        try {
            response = SimpleHttp.doGet((String)url, (KeycloakSession)this.session).asResponse();
            this.parseSetCookie(response);
            response.close();
        }
        catch (Exception e) {
            logger.errorv("Error: {0}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        try {
            response = SimpleHttp.doPost((String)url, (KeycloakSession)this.session).header("X-CSRFToken", this.csrf_value).header("Cookie", this.csrf_cookie).header("referer", url).param("username", username).param("password", password).asResponse();
            this.parseSetCookie(response);
            response.close();
        }
        catch (Exception e) {
            logger.error((Object)("Error: " + e.getMessage()));
            throw new RuntimeException(e);
        }
        this.logged_in = true;
        return 0;
    }

    public boolean isValid(String username, String password) {
        boolean bl;
        block9: {
            if (!this.logged_in.booleanValue()) {
                this.csrfAuthLogin();
            }
            String server = (String)this.model.getConfig().getFirst((Object)"scimurl");
            String endpointurl = String.format("https://%s/creds/simple_pwd", server);
            logger.debugv("Sending POST request to {0}", (Object)endpointurl);
            SimpleHttp simpleHttp = SimpleHttp.doPost((String)endpointurl, (KeycloakSession)this.session).header("X-CSRFToken", this.csrf_value).header("Cookie", this.csrf_cookie).header("SessionId", this.sessionid_cookie).header("referer", endpointurl).param("username", username).param("password", password);
            SimpleHttp.Response response = simpleHttp.asResponse();
            try {
                JsonNode result = response.asJson();
                bl = result.get("result").get("validated").asBoolean();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.debugv("Failed to authenticate user {0}: {1}", (Object)username, (Object)e);
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    public String gssAuth(String spnegoToken) {
        String string;
        block8: {
            String server = (String)this.model.getConfig().getFirst((Object)"scimurl");
            String endpointurl = String.format("https://%s/bridge/login_kerberos/", server);
            logger.debugv("Sending POST request to {0}", (Object)endpointurl);
            SimpleHttp simpleHttp = SimpleHttp.doPost((String)endpointurl, (KeycloakSession)this.session).header("Authorization", "Negotiate " + spnegoToken).param("username", "");
            SimpleHttp.Response response = simpleHttp.asResponse();
            try {
                logger.debugv("Response status is {0}", (Object)response.getStatus());
                string = response.getFirstHeader("Remote-User");
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.debugv("Failed to authenticate user with GSSAPI: {0}", (Object)e.toString());
                    return null;
                }
            }
            response.close();
        }
        return string;
    }

    public <T> SimpleHttp.Response clientRequest(String endpoint, String method, T entity) throws Exception {
        SimpleHttp.Response response = null;
        if (!this.logged_in.booleanValue()) {
            this.csrfAuthLogin();
        }
        String server = (String)this.model.getConfig().getFirst((Object)"scimurl");
        String endpointurl = endpoint.contains("domain") ? String.format("https://%s/domains/v1/%s/", server, endpoint) : String.format("https://%s/scim/v2/%s", server, endpoint);
        logger.debugv("Sending {0} request to {1}", (Object)method, (Object)endpointurl);
        try {
            switch (method) {
                case "GET": {
                    response = SimpleHttp.doGet((String)endpointurl, (KeycloakSession)this.session).header("X-CSRFToken", this.csrf_value).header("Cookie", this.csrf_cookie).header("SessionId", this.sessionid_cookie).asResponse();
                    break;
                }
                case "DELETE": {
                    response = SimpleHttp.doDelete((String)endpointurl, (KeycloakSession)this.session).header("X-CSRFToken", this.csrf_value).header("Cookie", this.csrf_cookie).header("SessionId", this.sessionid_cookie).header("referer", endpointurl).asResponse();
                    break;
                }
                case "POST": {
                    response = SimpleHttp.doPost((String)endpointurl, (KeycloakSession)this.session).header("X-CSRFToken", this.csrf_value).header("Cookie", this.csrf_cookie).header("SessionId", this.sessionid_cookie).header("referer", endpointurl).json(entity).asResponse();
                    break;
                }
                case "PUT": {
                    response = SimpleHttp.doPut((String)endpointurl, (KeycloakSession)this.session).header("X-CSRFToken", this.csrf_value).header("SessionId", this.sessionid_cookie).header("Cookie", this.csrf_cookie).json(entity).asResponse();
                    break;
                }
                default: {
                    logger.warn((Object)"Unknown HTTP method, skipping");
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new Exception();
        }
        return response;
    }

    private SCIMSearchRequest setupSearch(String username, String attribute) {
        ArrayList<String> schemas = new ArrayList<String>();
        SCIMSearchRequest search = new SCIMSearchRequest();
        schemas.add(SCHEMA_API_MESSAGES_SEARCHREQUEST);
        search.setSchemas(schemas);
        String filter = String.format("%s eq \"%s\"", attribute, username);
        search.setFilter(filter);
        logger.debugv("filter: {0}", (Object)filter);
        logger.debugv("Schema: {0}", (Object)SCHEMA_API_MESSAGES_SEARCHREQUEST);
        return search;
    }

    private SCIMUser getUserByAttr(String username, String attribute) {
        SCIMSearchRequest newSearch = this.setupSearch(username, attribute);
        String usersSearchUrl = "Users/.search";
        SCIMUser user = null;
        try {
            SimpleHttp.Response response = this.clientRequest(usersSearchUrl, "POST", newSearch);
            user = (SCIMUser)response.asJson(SCIMUser.class);
            response.close();
        }
        catch (Exception e) {
            logger.errorv("Error: {0}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return user;
    }

    public SCIMUser getUserByUsername(String username) {
        String attribute = "userName";
        return this.getUserByAttr(username, attribute);
    }

    public SCIMUser getUserByEmail(String username) {
        String attribute = "emails.value";
        return this.getUserByAttr(username, attribute);
    }

    public SCIMUser getUserByFirstName(String username) {
        String attribute = "name.givenName";
        return this.getUserByAttr(username, attribute);
    }

    public SCIMUser getUserByLastName(String username) {
        String attribute = "name.familyName";
        return this.getUserByAttr(username, attribute);
    }

    public SimpleHttp.Response deleteUser(String username) {
        SimpleHttp.Response response;
        SCIMUser userobj = this.getUserByUsername(username);
        SCIMUser.Resource user = userobj.getResources().get(0);
        String userIdUrl = String.format("Users/%s", user.getId());
        try {
            response = this.clientRequest(userIdUrl, "DELETE", null);
        }
        catch (Exception e) {
            logger.errorv("Error: {0}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return response;
    }

    private SCIMUser.Resource setupUser(String username) {
        SCIMUser.Resource user = new SCIMUser.Resource();
        SCIMUser.Resource.Name name = new SCIMUser.Resource.Name();
        SCIMUser.Resource.Email email = new SCIMUser.Resource.Email();
        ArrayList<String> schemas = new ArrayList<String>();
        ArrayList<SCIMUser.Resource.Email> emails = new ArrayList<SCIMUser.Resource.Email>();
        ArrayList<SCIMUser.Resource.Group> groups = new ArrayList<SCIMUser.Resource.Group>();
        schemas.add(SCHEMA_CORE_USER);
        user.setSchemas(schemas);
        user.setUserName(username);
        user.setActive(true);
        user.setGroups(groups);
        name.setGivenName("dummyfirstname");
        name.setMiddleName("");
        name.setFamilyName("dummylastname");
        user.setName(name);
        email.setPrimary(true);
        email.setType("work");
        email.setValue("dummy@example.com");
        emails.add(email);
        user.setEmails(emails);
        return user;
    }

    public SimpleHttp.Response createUser(String username) {
        SimpleHttp.Response response;
        String usersUrl = "Users";
        SCIMUser.Resource newUser = this.setupUser(username);
        try {
            response = this.clientRequest(usersUrl, "POST", newUser);
        }
        catch (Exception e) {
            logger.errorv("Error: {0}", (Object)e.getMessage());
            return null;
        }
        return response;
    }

    private void setUserAttr(SCIMUser.Resource user, String attr, String value) {
        SCIMUser.Resource.Name name = user.getName();
        SCIMUser.Resource.Email email = new SCIMUser.Resource.Email();
        ArrayList<SCIMUser.Resource.Email> emails = new ArrayList<SCIMUser.Resource.Email>();
        switch (attr) {
            case "firstName": {
                name.setGivenName(value);
                user.setName(name);
                break;
            }
            case "lastName": {
                name.setFamilyName(value);
                user.setName(name);
                break;
            }
            case "email": {
                email.setValue(value);
                emails.add(email);
                user.setEmails(emails);
                break;
            }
            case "username": {
                break;
            }
            default: {
                logger.debug((Object)("Unknown user attribute to set: " + attr));
            }
        }
    }

    public SimpleHttp.Response updateUser(Ipatuura ipatuura, String username, String attr, List<String> values) {
        SimpleHttp.Response response;
        logger.debug((Object)String.format("Updating %s attribute for %s", attr, username));
        if (ipatuura.csrfAuthLogin() == null) {
            logger.error((Object)"Error during login");
        }
        SCIMUser userobj = this.getUserByUsername(username);
        SCIMUser.Resource user = userobj.getResources().get(0);
        this.setUserAttr(user, attr, values.get(0));
        String modifyUrl = String.format("Users/%s", user.getId());
        try {
            response = this.clientRequest(modifyUrl, "PUT", user);
        }
        catch (Exception e) {
            logger.errorv("Error: {0}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return response;
    }

    public boolean getActive(SCIMUser user) {
        return user.getResources().get(0).getActive();
    }

    public String getEmail(SCIMUser user) {
        return user.getResources().get(0).getEmails().get(0).getValue();
    }

    public String getFirstName(SCIMUser user) {
        return user.getResources().get(0).getName().getGivenName();
    }

    public String getLastName(SCIMUser user) {
        return user.getResources().get(0).getName().getFamilyName();
    }

    public String getUserName(SCIMUser user) {
        return user.getResources().get(0).getUserName();
    }

    public String getId(SCIMUser user) {
        return user.getResources().get(0).getId();
    }

    public List<String> getGroupsList(SCIMUser user) {
        List<SCIMUser.Resource.Group> groups = user.getResources().get(0).getGroups();
        ArrayList<String> groupnames = new ArrayList<String>();
        for (SCIMUser.Resource.Group group : groups) {
            logger.debug((Object)("Retrieving group: " + group.getDisplay()));
            groupnames.add(group.getDisplay());
        }
        return groupnames;
    }
}

