/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jaxrs;

import java.net.URI;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.AbstractOAuthClient;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.util.TokenUtil;

@Deprecated
public class JaxrsOAuthClient
extends AbstractOAuthClient {
    private static final Logger logger = Logger.getLogger("" + JaxrsOAuthClient.class);
    protected Client client;

    public void stop() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveBearerToken(String redirectUri, String code) {
        redirectUri = this.stripOauthParametersFromRedirect(redirectUri);
        Form codeForm = new Form().param("grant_type", "authorization_code").param("code", code).param("client_id", this.clientId).param("redirect_uri", redirectUri);
        for (Map.Entry entry : this.credentials.entrySet()) {
            codeForm.param((String)entry.getKey(), (String)entry.getValue());
        }
        try (Response res = this.client.target(this.tokenUrl).request().post(Entity.form((Form)codeForm));){
            if (res.getStatus() == 400) {
                throw new BadRequestException();
            }
            if (res.getStatus() != 200) {
                throw new InternalServerErrorException((Throwable)new Exception("Unknown error when getting acess token"));
            }
            AccessTokenResponse tokenResponse = (AccessTokenResponse)res.readEntity(AccessTokenResponse.class);
            String string = tokenResponse.getToken();
            return string;
        }
    }

    public Response redirect(UriInfo uriInfo, String redirectUri) {
        String state = this.getStateCode();
        String scopeParam = TokenUtil.attachOIDCScope((String)this.scope);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.authUrl).queryParam("client_id", new Object[]{this.clientId}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state}).queryParam("scope", new Object[]{scopeParam});
        URI url = uriBuilder.build(new Object[0]);
        NewCookie cookie = new NewCookie(this.getStateCookieName(), state, this.getStateCookiePath(uriInfo), null, null, -1, this.isSecure, true);
        logger.fine("NewCookie: " + cookie.toString());
        logger.fine("Oauth Redirect to: " + url);
        return Response.status((int)302).location(url).cookie(new NewCookie[]{cookie}).build();
    }

    public String getStateCookiePath(UriInfo uriInfo) {
        if (this.stateCookiePath != null) {
            return this.stateCookiePath;
        }
        return uriInfo.getBaseUri().getRawPath();
    }

    public String getBearerToken(UriInfo uriInfo, HttpHeaders headers) throws BadRequestException, InternalServerErrorException {
        String error = this.getError(uriInfo);
        if (error != null) {
            throw new BadRequestException((Throwable)new Exception("OAuth error: " + error));
        }
        this.checkStateCookie(uriInfo, headers);
        String code = this.getAccessCode(uriInfo);
        if (code == null) {
            throw new BadRequestException((Throwable)new Exception("code parameter was null"));
        }
        return this.resolveBearerToken(uriInfo.getRequestUri().toString(), code);
    }

    public String getError(UriInfo uriInfo) {
        return (String)uriInfo.getQueryParameters().getFirst((Object)"error");
    }

    public String getAccessCode(UriInfo uriInfo) {
        return (String)uriInfo.getQueryParameters().getFirst((Object)"code");
    }

    public void checkStateCookie(UriInfo uriInfo, HttpHeaders headers) {
        Cookie stateCookie = (Cookie)headers.getCookies().get(this.stateCookieName);
        if (stateCookie == null) {
            throw new BadRequestException("state cookie not set");
        }
        String state = (String)uriInfo.getQueryParameters().getFirst((Object)"state");
        if (state == null) {
            throw new BadRequestException("state parameter was null");
        }
        if (!state.equals(stateCookie.getValue())) {
            throw new BadRequestException("state parameter invalid");
        }
    }
}

