/*
 * Decompiled with CFR 0.152.
 */
package de.idyl.winzipaes.impl;

import de.idyl.winzipaes.impl.ExtZipEntry;
import de.idyl.winzipaes.impl.ZipConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;

public class ExtZipOutputStream
implements ZipConstants {
    protected String comment;
    protected OutputStream out;
    protected int written;
    protected static final short ZIP_VERSION = 20;
    private List<ExtZipEntry> entries = new ArrayList<ExtZipEntry>();

    public ExtZipOutputStream(File file) throws IOException {
        this.out = new FileOutputStream(file);
    }

    public ExtZipOutputStream(OutputStream out) {
        this.out = out;
    }

    public int getWritten() {
        return this.written;
    }

    public void writeBytes(byte[] b) throws IOException {
        this.out.write(b);
        this.written += b.length;
    }

    public void writeShort(int v) throws IOException {
        this.out.write(v >>> 0 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.written += 2;
    }

    public void writeInt(long v) throws IOException {
        this.out.write((int)(v >>> 0 & 0xFFL));
        this.out.write((int)(v >>> 8 & 0xFFL));
        this.out.write((int)(v >>> 16 & 0xFFL));
        this.out.write((int)(v >>> 24 & 0xFFL));
        this.written += 4;
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.written += len;
    }

    protected void writeFileInfo(ExtZipEntry entry) throws IOException {
        this.writeShort(20);
        this.writeShort(entry.getFlag());
        this.writeShort(entry.getPrimaryCompressionMethod());
        this.writeInt(entry.getDosTime());
        this.writeInt(entry.getCrc());
        this.writeInt((int)entry.getCompressedSize());
        this.writeInt((int)entry.getSize());
        this.writeShort(entry.getName().length());
        if (entry.getExtra() != null) {
            this.writeShort(entry.getExtra().length);
        } else {
            this.writeShort(0);
        }
    }

    protected void writeDirEntry(ExtZipEntry entry) throws IOException {
        this.writeInt(33639248L);
        this.writeShort(20);
        this.writeFileInfo(entry);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(0L);
        this.writeInt(entry.getOffset());
        this.writeBytes(entry.getName().getBytes("iso-8859-1"));
        this.writeExtraBytes(entry);
    }

    protected void writeExtraBytes(ZipEntry entry) throws IOException {
        byte[] extraBytes = entry.getExtra();
        if (extraBytes != null) {
            this.writeBytes(extraBytes);
        }
    }

    public void putNextEntry(ExtZipEntry entry) throws IOException {
        this.entries.add(entry);
        entry.setOffset(this.written);
        this.writeInt(67324752L);
        this.writeFileInfo(entry);
        this.writeBytes(entry.getName().getBytes("iso-8859-1"));
        this.writeExtraBytes(entry);
    }

    public void finish() throws IOException {
        int dirOffset = this.written;
        int startOfCentralDirectory = this.written;
        for (ExtZipEntry entry : this.entries) {
            this.writeDirEntry(entry);
        }
        int centralDirectorySize = this.written - startOfCentralDirectory;
        this.writeInt(101010256L);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.entries.size());
        this.writeShort(this.entries.size());
        this.writeInt(centralDirectorySize);
        this.writeInt(dirOffset);
        byte[] commentBytes = this.comment != null ? this.comment.getBytes() : new byte[]{};
        this.writeShort(commentBytes.length);
        if (commentBytes.length > 0) {
            this.writeBytes(commentBytes);
        }
        this.out.close();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

