/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import java.io.IOException;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.logging.Logger;
import org.keycloak.ClientConnection;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProvider;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ErrorPage;

public abstract class AbstractOAuth2IdentityProvider<C extends OAuth2IdentityProviderConfig>
extends AbstractIdentityProvider<C> {
    protected static final Logger logger = Logger.getLogger(AbstractOAuth2IdentityProvider.class);
    public static final String OAUTH2_GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    public static final String FEDERATED_ACCESS_TOKEN = "FEDERATED_ACCESS_TOKEN";
    public static final String FEDERATED_REFRESH_TOKEN = "FEDERATED_REFRESH_TOKEN";
    public static final String FEDERATED_TOKEN_EXPIRATION = "FEDERATED_TOKEN_EXPIRATION";
    protected static ObjectMapper mapper = new ObjectMapper();
    public static final String OAUTH2_PARAMETER_ACCESS_TOKEN = "access_token";
    public static final String OAUTH2_PARAMETER_SCOPE = "scope";
    public static final String OAUTH2_PARAMETER_STATE = "state";
    public static final String OAUTH2_PARAMETER_RESPONSE_TYPE = "response_type";
    public static final String OAUTH2_PARAMETER_REDIRECT_URI = "redirect_uri";
    public static final String OAUTH2_PARAMETER_CODE = "code";
    public static final String OAUTH2_PARAMETER_CLIENT_ID = "client_id";
    public static final String OAUTH2_PARAMETER_CLIENT_SECRET = "client_secret";
    public static final String OAUTH2_PARAMETER_GRANT_TYPE = "grant_type";

    public AbstractOAuth2IdentityProvider(C config) {
        super(config);
        if (((OAuth2IdentityProviderConfig)((Object)config)).getDefaultScope() == null || ((OAuth2IdentityProviderConfig)((Object)config)).getDefaultScope().isEmpty()) {
            ((OAuth2IdentityProviderConfig)((Object)config)).setDefaultScope(this.getDefaultScopes());
        }
    }

    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new Endpoint(callback, realm, event);
    }

    public Response performLogin(AuthenticationRequest request) {
        try {
            URI authorizationUrl = this.createAuthorizationUrl(request).build(new Object[0]);
            return Response.temporaryRedirect((URI)authorizationUrl).build();
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not create authentication request.", (Throwable)e);
        }
    }

    public Response retrieveToken(FederatedIdentityModel identity) {
        return Response.ok((Object)identity.getToken()).build();
    }

    public C getConfig() {
        return (C)((Object)((OAuth2IdentityProviderConfig)super.getConfig()));
    }

    protected String extractTokenFromResponse(String response, String tokenName) {
        if (response == null) {
            return null;
        }
        if (response.startsWith("{")) {
            try {
                JsonNode node = mapper.readTree(response);
                if (node.has(tokenName)) {
                    String s = node.get(tokenName).getTextValue();
                    if (s == null || s.trim().isEmpty()) {
                        return null;
                    }
                    return s;
                }
                return null;
            }
            catch (IOException e) {
                throw new IdentityBrokerException("Could not extract token [" + tokenName + "] from response [" + response + "] due: " + e.getMessage(), (Throwable)e);
            }
        }
        Matcher matcher = Pattern.compile(tokenName + "=([^&]+)").matcher(response);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected BrokeredIdentityContext getFederatedIdentity(String response) {
        String accessToken = this.extractTokenFromResponse(response, OAUTH2_PARAMETER_ACCESS_TOKEN);
        if (accessToken == null) {
            throw new IdentityBrokerException("No access token available in OAuth server response: " + response);
        }
        return this.doGetFederatedIdentity(accessToken);
    }

    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        return null;
    }

    protected UriBuilder createAuthorizationUrl(AuthenticationRequest request) {
        return UriBuilder.fromUri((String)this.getConfig().getAuthorizationUrl()).queryParam(OAUTH2_PARAMETER_SCOPE, new Object[]{this.getConfig().getDefaultScope()}).queryParam(OAUTH2_PARAMETER_STATE, new Object[]{request.getState()}).queryParam(OAUTH2_PARAMETER_RESPONSE_TYPE, new Object[]{OAUTH2_PARAMETER_CODE}).queryParam(OAUTH2_PARAMETER_CLIENT_ID, new Object[]{this.getConfig().getClientId()}).queryParam(OAUTH2_PARAMETER_REDIRECT_URI, new Object[]{request.getRedirectUri()});
    }

    protected String getJsonProperty(JsonNode jsonNode, String name) {
        if (jsonNode.has(name) && !jsonNode.get(name).isNull()) {
            String s = jsonNode.get(name).asText();
            if (s != null && !s.isEmpty()) {
                return s;
            }
            return null;
        }
        return null;
    }

    protected JsonNode asJsonNode(String json) throws IOException {
        return mapper.readTree(json);
    }

    protected abstract String getDefaultScopes();

    protected class Endpoint {
        protected IdentityProvider.AuthenticationCallback callback;
        protected RealmModel realm;
        protected EventBuilder event;
        @Context
        protected KeycloakSession session;
        @Context
        protected ClientConnection clientConnection;
        @Context
        protected HttpHeaders headers;
        @Context
        protected UriInfo uriInfo;

        public Endpoint(IdentityProvider.AuthenticationCallback callback, RealmModel realm, EventBuilder event) {
            this.callback = callback;
            this.realm = realm;
            this.event = event;
        }

        @GET
        public Response authResponse(@QueryParam(value="state") String state, @QueryParam(value="code") String authorizationCode, @QueryParam(value="error") String error) {
            if (error != null) {
                this.event.event(EventType.LOGIN);
                this.event.error(error);
                return ErrorPage.error((KeycloakSession)this.session, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
            }
            try {
                if (authorizationCode != null) {
                    String response = this.generateTokenRequest(authorizationCode).asString();
                    BrokeredIdentityContext federatedIdentity = AbstractOAuth2IdentityProvider.this.getFederatedIdentity(response);
                    if (AbstractOAuth2IdentityProvider.this.getConfig().isStoreToken()) {
                        federatedIdentity.setToken(response);
                    }
                    federatedIdentity.setCode(state);
                    federatedIdentity.setIdpConfig(AbstractOAuth2IdentityProvider.this.getConfig());
                    federatedIdentity.setIdp((IdentityProvider)AbstractOAuth2IdentityProvider.this);
                    return this.callback.authenticated(federatedIdentity);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to make identity provider oauth callback", (Throwable)e);
            }
            this.event.event(EventType.LOGIN);
            this.event.error("identity_provider_login_failure");
            return ErrorPage.error((KeycloakSession)this.session, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
        }

        public SimpleHttp generateTokenRequest(String authorizationCode) {
            return SimpleHttp.doPost((String)AbstractOAuth2IdentityProvider.this.getConfig().getTokenUrl()).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_CODE, authorizationCode).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_CLIENT_ID, AbstractOAuth2IdentityProvider.this.getConfig().getClientId()).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_CLIENT_SECRET, AbstractOAuth2IdentityProvider.this.getConfig().getClientSecret()).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_REDIRECT_URI, this.uriInfo.getAbsolutePath().toString()).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_GRANT_TYPE, AbstractOAuth2IdentityProvider.OAUTH2_GRANT_TYPE_AUTHORIZATION_CODE);
        }
    }
}

