/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat;

import java.security.Principal;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.tomcat.CatalinaHttpFacade;
import org.keycloak.adapters.tomcat.GenericPrincipalFactory;

public class CatalinaRequestAuthenticator
extends RequestAuthenticator {
    private static final Logger log = Logger.getLogger("" + CatalinaRequestAuthenticator.class);
    protected Request request;
    protected GenericPrincipalFactory principalFactory;

    public CatalinaRequestAuthenticator(KeycloakDeployment deployment, AdapterTokenStore tokenStore, CatalinaHttpFacade facade, Request request, GenericPrincipalFactory principalFactory) {
        super((HttpFacade)facade, deployment, tokenStore, request.getConnector().getRedirectPort());
        this.request = request;
        this.principalFactory = principalFactory;
    }

    protected OAuthRequestAuthenticator createOAuthAuthenticator() {
        return new OAuthRequestAuthenticator((RequestAuthenticator)this, this.facade, this.deployment, this.sslRedirectPort, this.tokenStore);
    }

    protected void completeOAuthAuthentication(final KeycloakPrincipal<RefreshableKeycloakSecurityContext> skp) {
        final RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)skp.getKeycloakSecurityContext();
        final Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
        KeycloakAccount account = new KeycloakAccount(){

            public Principal getPrincipal() {
                return skp;
            }

            public Set<String> getRoles() {
                return roles;
            }

            public KeycloakSecurityContext getKeycloakSecurityContext() {
                return securityContext;
            }
        };
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        this.tokenStore.saveAccountInfo(account);
    }

    protected void completeBearerAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal, String method) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Completing bearer authentication. Bearer roles: " + roles);
        }
        GenericPrincipal generalPrincipal = this.principalFactory.createPrincipal(this.request.getContext().getRealm(), (Principal)principal, roles, (KeycloakSecurityContext)securityContext);
        this.request.setUserPrincipal((Principal)generalPrincipal);
        this.request.setAuthType(method);
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
    }

    protected String getHttpSessionId(boolean create) {
        HttpSession session = this.request.getSession(create);
        return session != null ? session.getId() : null;
    }
}

