/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.impl.types;

import com.mongodb.BasicDBObject;
import java.util.Collection;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.types.Mapper;
import org.keycloak.connections.mongo.api.types.MapperContext;
import org.keycloak.connections.mongo.api.types.MapperRegistry;
import org.keycloak.connections.mongo.impl.EntityInfo;
import org.keycloak.connections.mongo.impl.MongoStoreImpl;
import org.keycloak.models.utils.reflection.Property;

public class MongoEntityMapper<T>
implements Mapper<T, BasicDBObject> {
    private final MongoStoreImpl mongoStoreImpl;
    private final MapperRegistry mapperRegistry;
    private final Class<T> expectedMongoEntityType;

    public MongoEntityMapper(MongoStoreImpl mongoStoreImpl, MapperRegistry mapperRegistry, Class<T> expectedMongoEntityType) {
        this.mongoStoreImpl = mongoStoreImpl;
        this.mapperRegistry = mapperRegistry;
        this.expectedMongoEntityType = expectedMongoEntityType;
    }

    @Override
    public BasicDBObject convertObject(MapperContext<T, BasicDBObject> context) {
        T applicationObject = context.getObjectToConvert();
        EntityInfo entityInfo = this.mongoStoreImpl.getEntityInfo(applicationObject.getClass());
        BasicDBObject dbObject = new BasicDBObject();
        Collection<Property<Object>> props = entityInfo.getProperties();
        for (Property<Object> property : props) {
            Object propValue;
            String propName = property.getName();
            if ("id".equals(propName) && applicationObject instanceof MongoIdentifiableEntity || (propValue = property.getValue(applicationObject)) == null) continue;
            Object dbValue = propValue == null ? null : this.mapperRegistry.convertApplicationObjectToDBObject(propValue, Object.class);
            dbObject.put(propName, dbValue);
        }
        return dbObject;
    }

    @Override
    public Class<? extends T> getTypeOfObjectToConvert() {
        return this.expectedMongoEntityType;
    }

    @Override
    public Class<BasicDBObject> getExpectedReturnType() {
        return BasicDBObject.class;
    }
}

