/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.ResultSetCache;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotGeneratorChain;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.snapshot.SnapshotListener;
import liquibase.structure.DatabaseObject;
import liquibase.structure.DatabaseObjectCollection;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;

public abstract class DatabaseSnapshot
implements LiquibaseSerializable {
    private final DatabaseObject[] originalExamples;
    private HashSet<String> serializableFields;
    private SnapshotControl snapshotControl;
    private Database database;
    private DatabaseObjectCollection allFound;
    private Map<Class<? extends DatabaseObject>, Set<DatabaseObject>> knownNull = new HashMap<Class<? extends DatabaseObject>, Set<DatabaseObject>>();
    private Map<String, ResultSetCache> resultSetCaches = new HashMap<String, ResultSetCache>();

    DatabaseSnapshot(DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        this.database = database;
        this.allFound = new DatabaseObjectCollection(database);
        this.snapshotControl = snapshotControl;
        this.originalExamples = examples;
        this.init(examples);
        this.serializableFields = new HashSet();
        this.serializableFields.add("snapshotControl");
        this.serializableFields.add("objects");
    }

    protected void init(DatabaseObject[] examples) throws DatabaseException, InvalidExampleException {
        if (examples != null) {
            HashSet<Catalog> catalogs = new HashSet<Catalog>();
            for (DatabaseObject object : examples) {
                if (!(object instanceof Schema)) continue;
                catalogs.add(((Schema)object).getCatalog());
            }
            for (Catalog catalog : catalogs) {
                this.snapshotControl.addType(catalog.getClass(), this.database);
                this.include(catalog);
            }
            for (DatabaseObject obj : examples) {
                this.snapshotControl.addType(obj.getClass(), this.database);
                this.include(obj);
            }
        }
    }

    public DatabaseSnapshot(DatabaseObject[] examples, Database database) throws DatabaseException, InvalidExampleException {
        this(examples, database, new SnapshotControl(database));
    }

    public SnapshotControl getSnapshotControl() {
        return this.snapshotControl;
    }

    @Override
    public String getSerializedObjectName() {
        return "databaseSnapshot";
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/snapshot";
    }

    @Override
    public String getSerializableFieldNamespace(String field) {
        return this.getSerializedObjectNamespace();
    }

    @Override
    public Set<String> getSerializableFields() {
        return this.serializableFields;
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        if (field.equals("snapshotControl")) {
            return this.snapshotControl;
        }
        if (field.equals("objects")) {
            return this.allFound;
        }
        throw new UnexpectedLiquibaseException("Unknown field: " + field);
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        if (field.equals("snapshotControl")) {
            return LiquibaseSerializable.SerializationType.NESTED_OBJECT;
        }
        if (field.equals("objects")) {
            return LiquibaseSerializable.SerializationType.NESTED_OBJECT;
        }
        throw new UnexpectedLiquibaseException("Unknown field: " + field);
    }

    public Database getDatabase() {
        return this.database;
    }

    public ResultSetCache getResultSetCache(String key) {
        if (!this.resultSetCaches.containsKey(key)) {
            this.resultSetCaches.put(key, new ResultSetCache());
        }
        return this.resultSetCaches.get(key);
    }

    protected <T extends DatabaseObject> T include(T example) throws DatabaseException, InvalidExampleException {
        Object object;
        if (example == null) {
            return null;
        }
        if (this.database.isSystemObject((DatabaseObject)example)) {
            return null;
        }
        if (example instanceof Schema && example.getName() == null && (((Schema)example).getCatalog() == null || ((Schema)example).getCatalogName() == null)) {
            CatalogAndSchema catalogAndSchema = ((Schema)example).toCatalogAndSchema().customize(this.database);
            example = new Schema(catalogAndSchema.getCatalogName(), catalogAndSchema.getSchemaName());
        }
        if (!this.snapshotControl.shouldInclude(example.getClass())) {
            return (T)example;
        }
        T existing = this.get(example);
        if (existing != null) {
            return existing;
        }
        if (this.isKnownNull((DatabaseObject)example)) {
            return null;
        }
        SnapshotListener snapshotListener = this.snapshotControl.getSnapshotListener();
        SnapshotGeneratorChain chain = this.createGeneratorChain(example.getClass(), this.database);
        if (snapshotListener != null) {
            snapshotListener.willSnapshot((DatabaseObject)example, this.database);
        }
        if ((object = chain.snapshot(example, this)) == null) {
            Set<DatabaseObject> collection = this.knownNull.get(example.getClass());
            if (collection == null) {
                collection = new HashSet<DatabaseObject>();
                this.knownNull.put(example.getClass(), collection);
            }
            collection.add((DatabaseObject)example);
        } else {
            this.allFound.add((DatabaseObject)object);
            try {
                this.includeNestedObjects((DatabaseObject)object);
            }
            catch (InstantiationException e) {
                throw new UnexpectedLiquibaseException(e);
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
        if (snapshotListener != null) {
            snapshotListener.finishedSnapshot((DatabaseObject)example, (DatabaseObject)object, this.database);
        }
        return (T)object;
    }

    private void includeNestedObjects(DatabaseObject object) throws DatabaseException, InvalidExampleException, InstantiationException, IllegalAccessException {
        for (String field : new HashSet<String>(object.getAttributes())) {
            Object newFieldValue;
            Class<Object> fieldValue = object.getAttribute(field, Object.class);
            if (fieldValue == (newFieldValue = this.replaceObject(fieldValue)) || newFieldValue == null) continue;
            object.setAttribute(field, newFieldValue);
        }
    }

    private Object replaceObject(Object fieldValue) throws DatabaseException, InvalidExampleException, IllegalAccessException, InstantiationException {
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof DatabaseObject) {
            if (((DatabaseObject)fieldValue).getSnapshotId() != null) {
                return fieldValue;
            }
            if (!this.snapshotControl.shouldInclude(((DatabaseObject)fieldValue).getClass())) {
                return fieldValue;
            }
            if (this.isWrongSchema((DatabaseObject)fieldValue)) {
                return fieldValue;
            }
            if (((DatabaseObject)fieldValue).getSnapshotId() == null) {
                return this.include((DatabaseObject)fieldValue);
            }
            return fieldValue;
        }
        if (fieldValue instanceof Collection) {
            Iterator fieldValueIterator = ((Collection)fieldValue).iterator();
            ArrayList newValues = new ArrayList();
            while (fieldValueIterator.hasNext()) {
                Object obj = fieldValueIterator.next();
                if (fieldValue instanceof DatabaseObject && !this.snapshotControl.shouldInclude(((DatabaseObject)fieldValue).getClass())) {
                    return fieldValue;
                }
                if (obj instanceof DatabaseObject && ((DatabaseObject)obj).getSnapshotId() == null) {
                    obj = this.include((DatabaseObject)obj);
                }
                if (obj == null) continue;
                newValues.add(obj);
            }
            Collection newCollection = null;
            Class<Object> collectionClass = fieldValue.getClass();
            if (List.class.isAssignableFrom(collectionClass)) {
                collectionClass = ArrayList.class;
            }
            newCollection = (Collection)collectionClass.newInstance();
            newCollection.addAll(newValues);
            return newCollection;
        }
        if (fieldValue instanceof Map) {
            Map newMap = (Map)fieldValue.getClass().newInstance();
            for (Map.Entry entry : new HashSet(((Map)fieldValue).entrySet())) {
                Object key = this.replaceObject(entry.getKey());
                Object value = this.replaceObject(entry.getValue());
                if (key == null) continue;
                newMap.put(key, value);
            }
            return newMap;
        }
        return fieldValue;
    }

    protected boolean isWrongSchema(DatabaseObject fieldValue) {
        boolean isSchemaExamples = true;
        if (this.originalExamples == null) {
            return false;
        }
        for (DatabaseObject obj : this.originalExamples) {
            if (obj instanceof Schema) continue;
            isSchemaExamples = false;
            break;
        }
        if (!isSchemaExamples) {
            return false;
        }
        for (DatabaseObject obj : this.originalExamples) {
            if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(fieldValue.getSchema(), obj, this.database)) continue;
            return false;
        }
        return true;
    }

    public <DatabaseObjectType extends DatabaseObject> DatabaseObjectType get(DatabaseObjectType example) {
        return this.allFound.get(example);
    }

    public <DatabaseObjectType extends DatabaseObject> Set<DatabaseObjectType> get(Class<DatabaseObjectType> type) {
        return this.allFound.get(type);
    }

    protected SnapshotGeneratorChain createGeneratorChain(Class<? extends DatabaseObject> databaseObjectType, Database database) {
        SortedSet<SnapshotGenerator> generators = SnapshotGeneratorFactory.getInstance().getGenerators(databaseObjectType, database);
        if (generators == null || generators.size() == 0) {
            return null;
        }
        return new SnapshotGeneratorChain(generators);
    }

    private boolean isKnownNull(DatabaseObject example) {
        Set<DatabaseObject> databaseObjects = this.knownNull.get(example.getClass());
        if (databaseObjects == null) {
            return false;
        }
        for (DatabaseObject obj : databaseObjects) {
            if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(obj, example, this.database)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        throw new RuntimeException("TODO");
    }

    @Override
    public ParsedNode serialize() {
        throw new RuntimeException("TODO");
    }
}

