/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class UniqueConstraint
extends AbstractDatabaseObject {
    public UniqueConstraint() {
        this.setAttribute("columns", new ArrayList());
        this.setAttribute("deferrable", false);
        this.setAttribute("initiallyDeferred", false);
        this.setAttribute("disabled", false);
    }

    public UniqueConstraint(String name, String tableCatalog, String tableSchema, String tableName, Column ... columns) {
        this();
        this.setName(name);
        if (tableName != null && columns != null) {
            this.setTable(new Table(tableCatalog, tableSchema, tableName));
            this.setColumns(new ArrayList<Column>(Arrays.asList(columns)));
        }
    }

    @Override
    public DatabaseObject[] getContainingObjects() {
        return this.getColumns().toArray(new Column[this.getColumns().size()]);
    }

    @Override
    public String getName() {
        return (String)((Object)this.getAttribute("name", String.class));
    }

    public UniqueConstraint setName(String constraintName) {
        this.setAttribute("name", constraintName);
        return this;
    }

    @Override
    public Schema getSchema() {
        if (this.getTable() == null) {
            return null;
        }
        return this.getTable().getSchema();
    }

    public Table getTable() {
        return (Table)((Object)this.getAttribute("table", Table.class));
    }

    public UniqueConstraint setTable(Table table) {
        this.setAttribute("table", table);
        return this;
    }

    public List<Column> getColumns() {
        return (List)((Object)this.getAttribute("columns", List.class));
    }

    public UniqueConstraint setColumns(List<Column> columns) {
        this.setAttribute("columns", columns);
        for (Column column : this.getColumns()) {
            column.setRelation(this.getTable());
        }
        return this;
    }

    public UniqueConstraint addColumn(int position, Column column) {
        if (position >= this.getColumns().size()) {
            for (int i = this.getColumns().size() - 1; i < position; ++i) {
                this.getColumns().add(null);
            }
        }
        this.getColumns().set(position, column);
        return this;
    }

    public boolean isDeferrable() {
        return (Boolean)((Object)this.getAttribute("deferrable", Boolean.class));
    }

    public UniqueConstraint setDeferrable(boolean deferrable) {
        this.setAttribute("deferrable", deferrable);
        return this;
    }

    public boolean isInitiallyDeferred() {
        return (Boolean)((Object)this.getAttribute("initiallyDeferred", Boolean.class));
    }

    public UniqueConstraint setInitiallyDeferred(boolean initiallyDeferred) {
        this.setAttribute("initiallyDeferred", initiallyDeferred);
        return this;
    }

    public String getColumnNames() {
        return StringUtils.join(this.getColumns(), ", ", new StringUtils.StringUtilsFormatter(){

            public String toString(Object obj) {
                return ((Column)obj).toString(false);
            }
        });
    }

    public UniqueConstraint setDisabled(boolean disabled) {
        this.setAttribute("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        return (Boolean)((Object)this.getAttribute("disabled", Boolean.class));
    }

    public Index getBackingIndex() {
        return (Index)((Object)this.getAttribute("backingIndex", Index.class));
    }

    public UniqueConstraint setBackingIndex(Index backingIndex) {
        this.setAttribute("backingIndex", backingIndex);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (null == this.getColumnNames()) {
            return false;
        }
        UniqueConstraint that = (UniqueConstraint)o;
        boolean result = false;
        if (this.getColumnNames() != null) {
            if (!this.getColumnNames().equalsIgnoreCase(that.getColumnNames())) {
                return false;
            }
        } else if (that.getColumnNames() != null) return false;
        if (this.isDeferrable() != that.isDeferrable()) return false;
        if (this.isInitiallyDeferred() != that.isInitiallyDeferred()) return false;
        if (this.isDisabled() != that.isDisabled()) return false;
        boolean bl = true;
        result = bl;
        if (!result) return result;
        if (null == this.getTable()) {
            if (null != that.getTable()) return false;
            return true;
        }
        if (null != that.getTable()) return this.getTable().getName().equals(that.getTable().getName());
        return false;
    }

    @Override
    public int compareTo(Object other) {
        String thatTableName;
        UniqueConstraint o = (UniqueConstraint)other;
        String thisTableName = null == this.getTable() ? "" : this.getTable().getName();
        int returnValue = thisTableName.compareTo(thatTableName = null == o.getTable() ? "" : o.getTable().getName());
        if (returnValue == 0) {
            returnValue = this.getName().compareTo(o.getName());
        }
        if (returnValue == 0) {
            returnValue = this.getColumnNames().compareTo(o.getColumnNames());
        }
        return returnValue;
    }

    public int hashCode() {
        int result = 0;
        if (this.getTable() != null) {
            result = this.getTable().hashCode();
        }
        if (this.getName() != null) {
            result = 31 * result + this.getName().toUpperCase().hashCode();
        }
        if (this.getColumnNames() != null) {
            result = 31 * result + this.getColumnNames().hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getName() + " on " + this.getTable().getName() + "(" + this.getColumnNames() + ")";
    }
}

