/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.DependencyBuilder;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.keycloak.common.Version;
import org.keycloak.common.crypto.FipsMode;
import org.keycloak.config.DatabaseOptions;
import org.keycloak.config.HttpOptions;
import org.keycloak.config.LoggingOptions;
import org.keycloak.config.Option;
import org.keycloak.config.SecurityOptions;
import org.keycloak.config.StorageOptions;
import org.keycloak.platform.Platform;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class Keycloak {
    private CuratedApplication curated;
    private RunningQuarkusApplication application;
    private ApplicationModel applicationModel;
    private Path homeDir;
    private List<Dependency> dependencies;
    private boolean fipsEnabled;

    public static void main(String[] args) {
        Keycloak.builder().start(args);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Keycloak() {
        this(null, Version.VERSION, List.of(), false);
    }

    public Keycloak(Path homeDir, String version, List<Dependency> dependencies, boolean fipsEnabled) {
        this.homeDir = homeDir;
        this.dependencies = dependencies;
        this.fipsEnabled = fipsEnabled;
        try {
            this.applicationModel = this.createApplicationModel(version);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Keycloak start(List<String> args) {
        QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setExistingModel(this.applicationModel).setApplicationRoot(this.applicationModel.getApplicationModule().getModuleDir().toPath()).setTargetDirectory(this.applicationModel.getApplicationModule().getModuleDir().toPath()).setIsolateDeployment(true).setFlatClassPath(true).setMode(QuarkusBootstrap.Mode.TEST);
        try {
            this.curated = builder.build().bootstrap();
            AugmentAction action = this.curated.createAugmentor();
            Environment.setHomeDir((Path)this.homeDir);
            ConfigArgsConfigSource.setCliArgs((String[])args.toArray(new String[0]));
            StartupAction startupAction = action.createInitialRuntimeApplication();
            this.application = startupAction.runMainClass(args.toArray(new String[0]));
            return this;
        }
        catch (Exception cause) {
            throw new RuntimeException("Fail to start the server", cause);
        }
    }

    public void stop() throws TimeoutException {
        if (this.isRunning()) {
            this.closeApplication();
        }
    }

    private ApplicationModel createApplicationModel(String keycloakVersion) throws AppModelResolverException {
        BootstrapAppModelResolver appModelResolver = new BootstrapAppModelResolver(this.getMavenArtifactResolver());
        WorkspaceModule module = this.createWorkspaceModule(keycloakVersion);
        return appModelResolver.resolveModel(module);
    }

    private WorkspaceModule createWorkspaceModule(String keycloakVersion) {
        Path moduleDir = Keycloak.createModuleDir();
        DependencyBuilder serverDependency = (DependencyBuilder)((DependencyBuilder)((DependencyBuilder)((DependencyBuilder)DependencyBuilder.newInstance().setGroupId("org.keycloak")).setArtifactId("keycloak-quarkus-server")).setVersion(keycloakVersion)).addExclusion("org.jboss.logmanager", "log4j-jboss-logmanager");
        if (this.fipsEnabled) {
            serverDependency.addExclusion("org.bouncycastle", "bcprov-jdk18on");
            serverDependency.addExclusion("org.bouncycastle", "bcpkix-jdk18on");
            serverDependency.addExclusion("org.keycloak", "keycloak-crypto-default");
        } else {
            serverDependency.addExclusion("org.keycloak", "keycloak-crypto-fips1402");
        }
        WorkspaceModule.Mutable builder = WorkspaceModule.builder().setModuleId(WorkspaceModuleId.of((String)"org.keycloak", (String)"keycloak-embedded", (String)"1")).setModuleDir(moduleDir).setBuildDir(moduleDir).addDependencyConstraint(Dependency.pomImport((String)"org.keycloak", (String)"keycloak-quarkus-parent", (String)keycloakVersion)).addDependency(serverDependency.build());
        if (this.fipsEnabled) {
            builder.addDependency(Dependency.of((String)"org.bouncycastle", (String)"bc-fips"));
            builder.addDependency(Dependency.of((String)"org.bouncycastle", (String)"bctls-fips"));
            builder.addDependency(Dependency.of((String)"org.bouncycastle", (String)"bcpkix-fips"));
        }
        for (Dependency dependency : this.dependencies) {
            builder.addDependency(dependency);
        }
        return builder.build();
    }

    private static Path createModuleDir() {
        Path moduleDir;
        try {
            moduleDir = Files.createTempDirectory("kc-embedded", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return moduleDir;
    }

    MavenArtifactResolver getMavenArtifactResolver() throws BootstrapMavenException {
        return ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setWorkspaceDiscovery(true)).setOffline(false)).build();
    }

    private boolean isRunning() {
        return this.application != null;
    }

    private void closeApplication() {
        if (this.application != null) {
            try {
                this.application.close();
            }
            catch (Exception cause) {
                cause.printStackTrace();
            }
        }
        QuarkusConfigFactory.setConfig(null);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigProviderResolver cpr = ConfigProviderResolver.instance();
            cpr.releaseConfig(cpr.getConfig());
        }
        catch (Throwable throwable) {
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        this.application = null;
        this.curated = null;
    }

    static {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        System.setProperty("quarkus.http.test-port", "${kc.http-port}");
        System.setProperty("quarkus.http.test-ssl-port", "${kc.https-port}");
    }

    public static class Builder {
        private String version;
        private Path homeDir;
        private List<Dependency> dependencies = new ArrayList<Dependency>();

        private Builder() {
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setHomeDir(Path path) {
            this.homeDir = path;
            return this;
        }

        public Builder addDependency(String groupId, String artifactId, String version) {
            this.addDependency(groupId, artifactId, version, null);
            return this;
        }

        public Builder addDependency(String groupId, String artifactId, String version, String classifier) {
            this.dependencies.add(((DependencyBuilder)((DependencyBuilder)((DependencyBuilder)((DependencyBuilder)DependencyBuilder.newInstance().setGroupId(groupId)).setArtifactId(artifactId)).setVersion(version)).setClassifier(classifier)).build());
            return this;
        }

        public Keycloak start(String ... args) {
            return this.start(List.of(args));
        }

        public Keycloak start(List<String> rawArgs) {
            String logLevel;
            boolean isFipsEnabled;
            if (this.homeDir == null) {
                this.homeDir = Platform.getPlatform().getTmpDirectory().toPath();
            }
            ArrayList<String> args = new ArrayList<String>(rawArgs);
            this.addOptionIfNotSet(args, HttpOptions.HTTP_ENABLED, true);
            this.addOptionIfNotSet(args, HttpOptions.HTTP_PORT);
            this.addOptionIfNotSet(args, HttpOptions.HTTPS_PORT);
            if (this.getOptionValue(args, DatabaseOptions.DB) == null) {
                this.addOptionIfNotSet(args, StorageOptions.STORAGE, StorageOptions.StorageType.chm);
            }
            if ((isFipsEnabled = Optional.ofNullable((FipsMode)this.getOptionValue(args, SecurityOptions.FIPS_MODE)).orElse(FipsMode.DISABLED).isFipsEnabled()) && (logLevel = (String)this.getOptionValue(args, LoggingOptions.LOG_LEVEL)) == null) {
                args.add("--log-level=org.keycloak.common.crypto:TRACE,org.keycloak.crypto:TRACE");
            }
            return new Keycloak(this.homeDir, this.version, this.dependencies, isFipsEnabled).start(args);
        }

        private <T> void addOptionIfNotSet(List<String> args, Option<T> option) {
            this.addOptionIfNotSet(args, option, null);
        }

        private <T> void addOptionIfNotSet(List<String> args, Option<T> option, T defaultValue) {
            T value = this.getOptionValue(args, option);
            if (value == null) {
                defaultValue = Optional.ofNullable(defaultValue).orElseGet(option.getDefaultValue()::get);
                args.add(Configuration.toCliFormat((String)option.getKey()) + "=" + defaultValue);
            }
        }

        private <T> T getOptionValue(List<String> args, Option<T> option) {
            for (String arg : args) {
                if (!arg.contains(option.getKey())) continue;
                if (arg.endsWith(option.getKey())) {
                    throw new IllegalArgumentException("Option '" + arg + "' value must be set using '=' as a separator");
                }
                String value = arg.substring("--".length() + option.getKey().length() + 1);
                Class type = option.getType();
                if (type.equals(String.class)) {
                    return (T)value;
                }
                if (type.isEnum()) {
                    return Enum.valueOf(type, value);
                }
                if (Integer.class.isAssignableFrom(type)) {
                    return (T)Integer.valueOf(value);
                }
                if (Boolean.class.isAssignableFrom(type)) {
                    return (T)Boolean.valueOf(value);
                }
                throw new RuntimeException("Unsupported option type '" + type + "'");
            }
            return null;
        }
    }
}

