/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.UserCredentialManager;
import org.keycloak.federation.kerberos.KerberosConfig;
import org.keycloak.federation.kerberos.KerberosFederationProviderFactory;
import org.keycloak.federation.kerberos.KerberosPrincipal;
import org.keycloak.federation.kerberos.ReadOnlyKerberosUserModelDelegate;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserRegistrationProvider;
import org.keycloak.userprofile.AttributeGroupMetadata;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.UserProfileDecorator;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileUtil;

public class KerberosFederationProvider
implements UserStorageProvider,
UserLookupProvider,
CredentialInputValidator,
CredentialInputUpdater,
CredentialAuthentication,
ImportedUserValidation,
UserProfileDecorator,
UserRegistrationProvider {
    private static final Logger logger = Logger.getLogger(KerberosFederationProvider.class);
    public static final String KERBEROS_PRINCIPAL = "KERBEROS_PRINCIPAL";
    protected KeycloakSession session;
    protected UserStorageProviderModel model;
    protected KerberosConfig kerberosConfig;
    protected KerberosFederationProviderFactory factory;

    public KerberosFederationProvider(KeycloakSession session, UserStorageProviderModel model, KerberosFederationProviderFactory factory) {
        this.session = session;
        this.model = model;
        this.kerberosConfig = new KerberosConfig((ComponentModel)model);
        this.factory = factory;
    }

    public UserModel validate(RealmModel realm, UserModel user) {
        if (this.kerberosConfig.getEditMode() == UserStorageProvider.EditMode.READ_ONLY) {
            return new ReadOnlyKerberosUserModelDelegate(user, this);
        }
        return user;
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
        if (authenticator.isUserAvailable(username)) {
            try {
                String kerberosPrincipal = authenticator.getKerberosPrincipal(username);
                return this.findOrCreateAuthenticatedUser(realm, new KerberosPrincipal(kerberosPrincipal));
            }
            catch (LoginException le) {
                throw new IllegalStateException("Should not happen", le);
            }
        }
        return null;
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        return null;
    }

    public UserModel getUserById(RealmModel realm, String id) {
        return null;
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel) || !"password".equals(input.getType())) {
            return false;
        }
        if (this.kerberosConfig.getEditMode() == UserStorageProvider.EditMode.READ_ONLY) {
            throw new ReadOnlyException("Can't change password in Keycloak database. Change password with your Kerberos server");
        }
        return false;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        return Stream.empty();
    }

    public boolean supportsCredentialType(String credentialType) {
        return credentialType.equals("kerberos") || this.kerberosConfig.isAllowPasswordAuthentication() && credentialType.equals("password");
    }

    public boolean supportsCredentialAuthenticationFor(String type) {
        return "kerberos".equals(type);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.supportsCredentialType(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password") && !((UserCredentialManager)user.credentialManager()).isConfiguredLocally("password")) {
            return this.validPassword(user.getFirstAttribute(KERBEROS_PRINCIPAL), input.getChallengeResponse());
        }
        return false;
    }

    protected boolean validPassword(String kerberosPrincipal, String password) {
        if (this.kerberosConfig.isAllowPasswordAuthentication()) {
            KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
            return authenticator.validUser(kerberosPrincipal, password);
        }
        return false;
    }

    public CredentialValidationOutput authenticate(RealmModel realm, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return null;
        }
        UserCredentialModel credential = (UserCredentialModel)input;
        if (credential.getType().equals("kerberos")) {
            SPNEGOAuthenticator spnegoAuthenticator = (SPNEGOAuthenticator)credential.getNote("authenticatedSpnegoContext");
            if (spnegoAuthenticator != null) {
                logger.debugf("SPNEGO authentication already performed by previous provider. Provider '%s' will try to lookup user with kerberos principal '%s'", (Object)this, (Object)spnegoAuthenticator.getAuthenticatedKerberosPrincipal());
            } else {
                String spnegoToken = credential.getChallengeResponse();
                spnegoAuthenticator = this.factory.createSPNEGOAuthenticator(spnegoToken, this.kerberosConfig);
                spnegoAuthenticator.authenticate();
            }
            HashMap<String, String> state = new HashMap<String, String>();
            if (spnegoAuthenticator.isAuthenticated()) {
                KerberosPrincipal kerberosPrincipal = spnegoAuthenticator.getAuthenticatedKerberosPrincipal();
                UserModel user = this.findOrCreateAuthenticatedUser(realm, kerberosPrincipal);
                if (user == null) {
                    credential.setNote("authenticatedSpnegoContext", (Object)spnegoAuthenticator);
                    return CredentialValidationOutput.fallback();
                }
                String delegationCredential = spnegoAuthenticator.getSerializedDelegationCredential();
                if (delegationCredential != null) {
                    state.put("gss_delegation_credential", delegationCredential);
                }
                return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
            }
            if (spnegoAuthenticator.getResponseToken() != null) {
                logger.tracef("SPNEGO Handshake will continue", new Object[0]);
                state.put("SpnegoResponseToken", spnegoAuthenticator.getResponseToken());
                return new CredentialValidationOutput(null, CredentialValidationOutput.Status.CONTINUE, state);
            }
            logger.tracef("SPNEGO Handshake not successful", new Object[0]);
            return CredentialValidationOutput.fallback();
        }
        return null;
    }

    public void close() {
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, KerberosPrincipal kerberosPrincipal) {
        UserModel user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).searchForUserByUserAttributeStream(realm, KERBEROS_PRINCIPAL, kerberosPrincipal.toString()).findFirst().orElse(null);
        if (user != null) {
            user = this.session.users().getUserById(realm, user.getId());
            logger.debug((Object)("Kerberos authenticated user " + kerberosPrincipal + " found in Keycloak storage"));
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warn((Object)("User with username " + kerberosPrincipal + " already exists, but is not linked to provider [" + this.model.getName() + "]"));
                return null;
            }
            UserModel proxied = this.validate(realm, user);
            if (proxied != null) {
                return proxied;
            }
            logger.warn((Object)("User with username " + kerberosPrincipal.getPrefix() + " already exists and is linked to provider [" + this.model.getName() + "] but kerberos principal is not correct. Kerberos principal on user is: " + user.getFirstAttribute(KERBEROS_PRINCIPAL)));
            logger.warn((Object)"Will re-create user");
            new UserManager(this.session).removeUser(realm, user, UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session));
        }
        logger.debug((Object)("Kerberos authenticated user " + kerberosPrincipal + " not in Keycloak storage. Creating him"));
        return this.importUserToKeycloak(realm, kerberosPrincipal);
    }

    protected UserModel importUserToKeycloak(RealmModel realm, KerberosPrincipal kerberosPrincipal) {
        String email = kerberosPrincipal.getPrefix() + "@" + kerberosPrincipal.getRealm().toLowerCase();
        Object username = kerberosPrincipal.getRealm().equalsIgnoreCase(this.kerberosConfig.getKerberosRealm()) ? kerberosPrincipal.getPrefix() : email;
        logger.debugf("Creating kerberos user %s with username: %s, email: %s to local Keycloak storage", (Object)kerberosPrincipal, username, (Object)email);
        UserModel user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).addUser(realm, (String)username);
        user.setEnabled(true);
        user.setEmail(email);
        user.setFederationLink(this.model.getId());
        user.setSingleAttribute(KERBEROS_PRINCIPAL, kerberosPrincipal.toString());
        if (this.kerberosConfig.isUpdateProfileFirstLogin()) {
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL)) {
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_EMAIL);
            }
            user.addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
        }
        return this.validate(realm, user);
    }

    public String toString() {
        return "KerberosFederationProvider - " + this.model.getName();
    }

    public List<AttributeMetadata> decorateUserProfile(String providerId, UserProfileMetadata metadata) {
        int guiOrder = (int)metadata.getAttributes().stream().map(AttributeMetadata::getName).distinct().count();
        AttributeGroupMetadata metadataGroup = UserProfileUtil.lookupUserMetadataGroup((KeycloakSession)this.session);
        return Collections.singletonList(UserProfileUtil.createAttributeMetadata((String)KERBEROS_PRINCIPAL, (UserProfileMetadata)metadata, (AttributeGroupMetadata)metadataGroup, (int)guiOrder++, (String)this.model.getName()));
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return true;
    }

    public UserModel addUser(RealmModel realm, String username) {
        return null;
    }
}

