/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.idm.model.LDAPDn;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.QueryParameter;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;

public class RoleLDAPFederationMapper
extends AbstractLDAPFederationMapper {
    private static final Logger logger = Logger.getLogger(RoleLDAPFederationMapper.class);
    public static final String ROLES_DN = "roles.dn";
    public static final String ROLE_NAME_LDAP_ATTRIBUTE = "role.name.ldap.attribute";
    public static final String MEMBERSHIP_LDAP_ATTRIBUTE = "membership.ldap.attribute";
    public static final String ROLE_OBJECT_CLASSES = "role.object.classes";
    public static final String USE_REALM_ROLES_MAPPING = "use.realm.roles.mapping";
    public static final String CLIENT_ID = "client.id";
    public static final String MODE = "mode";
    private Set<String> rolesSyncedModels = new TreeSet<String>();

    @Override
    public void onImportUserFromLDAP(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        this.syncRolesFromLDAP(mapperModel, ldapProvider, realm);
        Mode mode = this.getMode(mapperModel);
        if (mode == Mode.IMPORT && isCreate) {
            List<LDAPObject> ldapRoles = this.getLDAPRoleMappings(mapperModel, ldapProvider, ldapUser);
            String roleNameAttr = this.getRoleNameLdapAttribute(mapperModel);
            for (LDAPObject ldapRole : ldapRoles) {
                String roleName = ldapRole.getAttributeAsString(roleNameAttr);
                RoleContainerModel roleContainer = this.getTargetRoleContainer(mapperModel, realm);
                RoleModel role = roleContainer.getRole(roleName);
                logger.debugf("Granting role [%s] to user [%s] during import from LDAP", (Object)roleName, (Object)user.getUsername());
                user.grantRole(role);
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
        this.syncRolesFromLDAP(mapperModel, ldapProvider, realm);
    }

    protected void syncRolesFromLDAP(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, RealmModel realm) {
        if (!this.rolesSyncedModels.contains(mapperModel.getId())) {
            logger.debugf("Syncing roles from LDAP into Keycloak DB. Mapper is [%s], LDAP provider is [%s]", (Object)mapperModel.getName(), (Object)ldapProvider.getModel().getDisplayName());
            LDAPQuery ldapQuery = this.createRoleQuery(mapperModel, ldapProvider);
            List<LDAPObject> ldapRoles = ldapQuery.getResultList();
            RoleContainerModel roleContainer = this.getTargetRoleContainer(mapperModel, realm);
            String rolesRdnAttr = this.getRoleNameLdapAttribute(mapperModel);
            for (LDAPObject ldapRole : ldapRoles) {
                String roleName = ldapRole.getAttributeAsString(rolesRdnAttr);
                if (roleContainer.getRole(roleName) != null) continue;
                logger.infof("Syncing role [%s] from LDAP to keycloak DB", (Object)roleName);
                roleContainer.addRole(roleName);
            }
            this.rolesSyncedModels.add(mapperModel.getId());
        }
    }

    public LDAPQuery createRoleQuery(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider) {
        LDAPQuery ldapQuery = new LDAPQuery(ldapProvider);
        ldapQuery.setSearchScope(ldapProvider.getLdapIdentityStore().getConfig().getSearchScope());
        String rolesDn = this.getRolesDn(mapperModel);
        ldapQuery.setSearchDn(rolesDn);
        Collection<String> roleObjectClasses = this.getRoleObjectClasses(mapperModel, ldapProvider);
        ldapQuery.addObjectClasses(roleObjectClasses);
        String rolesRdnAttr = this.getRoleNameLdapAttribute(mapperModel);
        String membershipAttr = this.getMembershipLdapAttribute(mapperModel);
        ldapQuery.addReturningLdapAttribute(rolesRdnAttr);
        ldapQuery.addReturningLdapAttribute(membershipAttr);
        return ldapQuery;
    }

    protected RoleContainerModel getTargetRoleContainer(UserFederationMapperModel mapperModel, RealmModel realm) {
        boolean realmRolesMapping = this.parseBooleanParameter(mapperModel, USE_REALM_ROLES_MAPPING);
        if (realmRolesMapping) {
            return realm;
        }
        String clientId = (String)mapperModel.getConfig().get(CLIENT_ID);
        if (clientId == null) {
            throw new ModelException("Using client roles mapping is requested, but parameter client.id not found!");
        }
        ClientModel client = realm.getClientByClientId(clientId);
        if (client == null) {
            throw new ModelException("Can't found requested client with clientId: " + clientId);
        }
        return client;
    }

    protected String getRolesDn(UserFederationMapperModel mapperModel) {
        String rolesDn = (String)mapperModel.getConfig().get(ROLES_DN);
        if (rolesDn == null) {
            throw new ModelException("Roles DN is null! Check your configuration");
        }
        return rolesDn;
    }

    protected String getRoleNameLdapAttribute(UserFederationMapperModel mapperModel) {
        String rolesRdnAttr = (String)mapperModel.getConfig().get(ROLE_NAME_LDAP_ATTRIBUTE);
        return rolesRdnAttr != null ? rolesRdnAttr : "cn";
    }

    protected String getMembershipLdapAttribute(UserFederationMapperModel mapperModel) {
        String membershipAttrName = (String)mapperModel.getConfig().get(MEMBERSHIP_LDAP_ATTRIBUTE);
        return membershipAttrName != null ? membershipAttrName : "member";
    }

    protected Collection<String> getRoleObjectClasses(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider) {
        String objectClasses = (String)mapperModel.getConfig().get(ROLE_OBJECT_CLASSES);
        if (objectClasses == null) {
            objectClasses = ldapProvider.getLdapIdentityStore().getConfig().isActiveDirectory() ? "group" : "groupOfNames";
        }
        String[] objClasses = objectClasses.split(",");
        HashSet<String> trimmed = new HashSet<String>();
        for (String objectClass : objClasses) {
            if ((objectClass = objectClass.trim()).length() <= 0) continue;
            trimmed.add(objectClass);
        }
        return trimmed;
    }

    private Mode getMode(UserFederationMapperModel mapperModel) {
        String modeString = (String)mapperModel.getConfig().get(MODE);
        if (modeString == null || modeString.isEmpty()) {
            throw new ModelException("Mode is missing! Check your configuration");
        }
        return Enum.valueOf(Mode.class, modeString.toUpperCase());
    }

    public LDAPObject createLDAPRole(UserFederationMapperModel mapperModel, String roleName, LDAPFederationProvider ldapProvider) {
        LDAPObject ldapObject = new LDAPObject();
        String roleNameAttribute = this.getRoleNameLdapAttribute(mapperModel);
        ldapObject.setRdnAttributeName(roleNameAttribute);
        ldapObject.setObjectClasses(this.getRoleObjectClasses(mapperModel, ldapProvider));
        ldapObject.setSingleAttribute(roleNameAttribute, roleName);
        LDAPDn roleDn = LDAPDn.fromString(this.getRolesDn(mapperModel));
        roleDn.addFirst(roleNameAttribute, roleName);
        ldapObject.setDn(roleDn);
        logger.infof("Creating role [%s] to LDAP with DN [%s]", (Object)roleName, (Object)roleDn.toString());
        ldapProvider.getLdapIdentityStore().add(ldapObject);
        return ldapObject;
    }

    public void addRoleMappingInLDAP(UserFederationMapperModel mapperModel, String roleName, LDAPFederationProvider ldapProvider, LDAPObject ldapUser) {
        LDAPObject ldapRole = this.loadLDAPRoleByName(mapperModel, ldapProvider, roleName);
        if (ldapRole == null) {
            ldapRole = this.createLDAPRole(mapperModel, roleName, ldapProvider);
        }
        Set<String> memberships = this.getExistingMemberships(mapperModel, ldapRole);
        for (String membership : memberships) {
            if (membership.trim().length() != 0) continue;
            memberships.remove(membership);
            break;
        }
        memberships.add(ldapUser.getDn().toString());
        ldapRole.setAttribute(this.getMembershipLdapAttribute(mapperModel), memberships);
        ldapProvider.getLdapIdentityStore().update(ldapRole);
    }

    public void deleteRoleMappingInLDAP(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, LDAPObject ldapRole) {
        Set<String> memberships = this.getExistingMemberships(mapperModel, ldapRole);
        memberships.remove(ldapUser.getDn().toString());
        if (memberships.size() == 0 && !ldapProvider.getLdapIdentityStore().getConfig().isActiveDirectory()) {
            memberships.add("cn=empty-membership-placeholder");
        }
        ldapRole.setAttribute(this.getMembershipLdapAttribute(mapperModel), memberships);
        ldapProvider.getLdapIdentityStore().update(ldapRole);
    }

    public LDAPObject loadLDAPRoleByName(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, String roleName) {
        LDAPQuery ldapQuery = this.createRoleQuery(mapperModel, ldapProvider);
        Condition roleNameCondition = new LDAPQueryConditionsBuilder().equal(new QueryParameter(this.getRoleNameLdapAttribute(mapperModel)), roleName);
        ldapQuery.where(roleNameCondition);
        return ldapQuery.getFirstResult();
    }

    protected Set<String> getExistingMemberships(UserFederationMapperModel mapperModel, LDAPObject ldapRole) {
        String memberAttrName = this.getMembershipLdapAttribute(mapperModel);
        Set<String> memberships = ldapRole.getAttributeAsSet(memberAttrName);
        if (memberships == null) {
            memberships = new HashSet<String>();
        }
        return memberships;
    }

    protected List<LDAPObject> getLDAPRoleMappings(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser) {
        LDAPQuery ldapQuery = this.createRoleQuery(mapperModel, ldapProvider);
        String membershipAttr = this.getMembershipLdapAttribute(mapperModel);
        Condition membershipCondition = new LDAPQueryConditionsBuilder().equal(new QueryParameter(membershipAttr), ldapUser.getDn().toString());
        ldapQuery.where(membershipCondition);
        return ldapQuery.getResultList();
    }

    @Override
    public UserModel proxy(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        Mode mode = this.getMode(mapperModel);
        if (mode == Mode.IMPORT) {
            return delegate;
        }
        return new LDAPRoleMappingsUserDelegate(delegate, mapperModel, ldapProvider, ldapUser, realm, mode);
    }

    @Override
    public void beforeLDAPQuery(UserFederationMapperModel mapperModel, LDAPQuery query) {
    }

    public static enum Mode {
        LDAP_ONLY,
        IMPORT,
        READ_ONLY;

    }

    public class LDAPRoleMappingsUserDelegate
    extends UserModelDelegate {
        private final UserFederationMapperModel mapperModel;
        private final LDAPFederationProvider ldapProvider;
        private final LDAPObject ldapUser;
        private final RealmModel realm;
        private final Mode mode;
        private Set<RoleModel> cachedLDAPRoleMappings;

        public LDAPRoleMappingsUserDelegate(UserModel user, UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, RealmModel realm, Mode mode) {
            super(user);
            this.mapperModel = mapperModel;
            this.ldapProvider = ldapProvider;
            this.ldapUser = ldapUser;
            this.realm = realm;
            this.mode = mode;
        }

        public Set<RoleModel> getRealmRoleMappings() {
            RoleContainerModel roleContainer = RoleLDAPFederationMapper.this.getTargetRoleContainer(this.mapperModel, this.realm);
            if (roleContainer.equals(this.realm)) {
                Set<RoleModel> ldapRoleMappings = this.getLDAPRoleMappingsConverted(this.mapperModel, this.ldapProvider, this.ldapUser, roleContainer);
                if (this.mode == Mode.LDAP_ONLY) {
                    return ldapRoleMappings;
                }
                Set modelRoleMappings = super.getRealmRoleMappings();
                ldapRoleMappings.addAll(modelRoleMappings);
                return ldapRoleMappings;
            }
            return super.getRealmRoleMappings();
        }

        public Set<RoleModel> getClientRoleMappings(ClientModel client) {
            RoleContainerModel roleContainer = RoleLDAPFederationMapper.this.getTargetRoleContainer(this.mapperModel, this.realm);
            if (roleContainer.equals(client)) {
                Set<RoleModel> ldapRoleMappings = this.getLDAPRoleMappingsConverted(this.mapperModel, this.ldapProvider, this.ldapUser, roleContainer);
                if (this.mode == Mode.LDAP_ONLY) {
                    return ldapRoleMappings;
                }
                Set modelRoleMappings = super.getClientRoleMappings(client);
                ldapRoleMappings.addAll(modelRoleMappings);
                return ldapRoleMappings;
            }
            return super.getClientRoleMappings(client);
        }

        public boolean hasRole(RoleModel role) {
            Set<RoleModel> roles = this.getRoleMappings();
            return KeycloakModelUtils.hasRole(roles, (RoleModel)role);
        }

        public void grantRole(RoleModel role) {
            if (this.mode == Mode.LDAP_ONLY) {
                RoleContainerModel roleContainer = RoleLDAPFederationMapper.this.getTargetRoleContainer(this.mapperModel, this.realm);
                if (role.getContainer().equals(roleContainer)) {
                    this.cachedLDAPRoleMappings = null;
                    RoleLDAPFederationMapper.this.addRoleMappingInLDAP(this.mapperModel, role.getName(), this.ldapProvider, this.ldapUser);
                } else {
                    super.grantRole(role);
                }
            } else {
                super.grantRole(role);
            }
        }

        public Set<RoleModel> getRoleMappings() {
            Set modelRoleMappings = super.getRoleMappings();
            RoleContainerModel targetRoleContainer = RoleLDAPFederationMapper.this.getTargetRoleContainer(this.mapperModel, this.realm);
            Set<RoleModel> ldapRoleMappings = this.getLDAPRoleMappingsConverted(this.mapperModel, this.ldapProvider, this.ldapUser, targetRoleContainer);
            if (this.mode == Mode.LDAP_ONLY) {
                HashSet modelRolesCopy = new HashSet(modelRoleMappings);
                for (RoleModel role : modelRolesCopy) {
                    if (!role.getContainer().equals(targetRoleContainer)) continue;
                    modelRoleMappings.remove(role);
                }
            }
            modelRoleMappings.addAll(ldapRoleMappings);
            return modelRoleMappings;
        }

        protected Set<RoleModel> getLDAPRoleMappingsConverted(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, RoleContainerModel roleContainer) {
            if (this.cachedLDAPRoleMappings != null) {
                return new HashSet<RoleModel>(this.cachedLDAPRoleMappings);
            }
            List<LDAPObject> ldapRoles = RoleLDAPFederationMapper.this.getLDAPRoleMappings(mapperModel, ldapProvider, ldapUser);
            HashSet<RoleModel> roles = new HashSet<RoleModel>();
            String roleNameLdapAttr = RoleLDAPFederationMapper.this.getRoleNameLdapAttribute(mapperModel);
            for (LDAPObject role : ldapRoles) {
                String roleName = role.getAttributeAsString(roleNameLdapAttr);
                RoleModel modelRole = roleContainer.getRole(roleName);
                if (modelRole == null) {
                    modelRole = roleContainer.addRole(roleName);
                }
                roles.add(modelRole);
            }
            this.cachedLDAPRoleMappings = new HashSet<RoleModel>(roles);
            return roles;
        }

        public void deleteRoleMapping(RoleModel role) {
            RoleContainerModel roleContainer = RoleLDAPFederationMapper.this.getTargetRoleContainer(this.mapperModel, this.realm);
            if (role.getContainer().equals(roleContainer)) {
                LDAPQuery ldapQuery = RoleLDAPFederationMapper.this.createRoleQuery(this.mapperModel, this.ldapProvider);
                LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
                Condition roleNameCondition = conditionsBuilder.equal(new QueryParameter(RoleLDAPFederationMapper.this.getRoleNameLdapAttribute(this.mapperModel)), role.getName());
                Condition membershipCondition = conditionsBuilder.equal(new QueryParameter(RoleLDAPFederationMapper.this.getMembershipLdapAttribute(this.mapperModel)), this.ldapUser.getDn().toString());
                ldapQuery.where(roleNameCondition).where(membershipCondition);
                LDAPObject ldapRole = ldapQuery.getFirstResult();
                if (ldapRole == null) {
                    if (this.mode == Mode.READ_ONLY) {
                        super.deleteRoleMapping(role);
                    }
                } else {
                    if (this.mode == Mode.READ_ONLY) {
                        throw new ModelException("Not possible to delete LDAP role mappings as mapper mode is READ_ONLY");
                    }
                    this.cachedLDAPRoleMappings = null;
                    RoleLDAPFederationMapper.this.deleteRoleMappingInLDAP(this.mapperModel, this.ldapProvider, this.ldapUser, ldapRole);
                }
            } else {
                super.deleteRoleMapping(role);
            }
        }
    }
}

