/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import org.keycloak.Config;
import org.keycloak.mappers.MapperConfigValidationException;
import org.keycloak.mappers.UserFederationMapperFactory;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.provider.ProviderConfigProperty;

public abstract class AbstractLDAPFederationMapperFactory
implements UserFederationMapperFactory {
    public static final String ATTRIBUTE_MAPPER_CATEGORY = "Attribute Mapper";
    public static final String ROLE_MAPPER_CATEGORY = "Role Mapper";

    public void init(Config.Scope config) {
    }

    public String getFederationProviderType() {
        return "ldap";
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public static ProviderConfigProperty createConfigProperty(String name, String label, String helpText, String type, Object defaultValue) {
        ProviderConfigProperty configProperty = new ProviderConfigProperty();
        configProperty.setName(name);
        configProperty.setLabel(label);
        configProperty.setHelpText(helpText);
        configProperty.setType(type);
        configProperty.setDefaultValue(defaultValue);
        return configProperty;
    }

    protected void checkMandatoryConfigAttribute(String name, String displayName, UserFederationMapperModel mapperModel) throws MapperConfigValidationException {
        String attrConfigValue = (String)mapperModel.getConfig().get(name);
        if (attrConfigValue == null || attrConfigValue.trim().isEmpty()) {
            throw new MapperConfigValidationException("Missing configuration for '" + displayName + "'");
        }
    }
}

