/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.query.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.Sort;
import org.keycloak.federation.ldap.mappers.LDAPFederationMapper;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.UserFederationMapperModel;

public class LDAPQuery {
    private final LDAPFederationProvider ldapFedProvider;
    private int offset;
    private int limit;
    private byte[] paginationContext;
    private String searchDn;
    private final Set<Condition> conditions = new LinkedHashSet<Condition>();
    private final Set<Sort> ordering = new LinkedHashSet<Sort>();
    private final Set<String> returningLdapAttributes = new LinkedHashSet<String>();
    private final Set<String> returningReadOnlyLdapAttributes = new LinkedHashSet<String>();
    private final Set<String> objectClasses = new LinkedHashSet<String>();
    private final List<UserFederationMapperModel> mappers = new ArrayList<UserFederationMapperModel>();
    private int searchScope = 2;
    private String ldapFilter = null;

    public LDAPQuery(LDAPFederationProvider ldapProvider) {
        this.ldapFedProvider = ldapProvider;
    }

    public LDAPQuery where(Condition ... condition) {
        this.conditions.addAll(Arrays.asList(condition));
        return this;
    }

    public LDAPQuery sortBy(Sort ... sorts) {
        this.ordering.addAll(Arrays.asList(sorts));
        return this;
    }

    public LDAPQuery setSearchDn(String searchDn) {
        this.searchDn = searchDn;
        return this;
    }

    public LDAPQuery addObjectClasses(Collection<String> objectClasses) {
        this.objectClasses.addAll(objectClasses);
        return this;
    }

    public LDAPQuery addReturningLdapAttribute(String ldapAttributeName) {
        this.returningLdapAttributes.add(ldapAttributeName);
        return this;
    }

    public LDAPQuery addReturningReadOnlyLdapAttribute(String ldapAttributeName) {
        this.returningReadOnlyLdapAttributes.add(ldapAttributeName.toLowerCase());
        return this;
    }

    public LDAPQuery addMappers(Collection<UserFederationMapperModel> mappers) {
        this.mappers.addAll(mappers);
        return this;
    }

    public LDAPQuery setSearchScope(int searchScope) {
        this.searchScope = searchScope;
        return this;
    }

    public Set<Sort> getSorting() {
        return Collections.unmodifiableSet(this.ordering);
    }

    public String getSearchDn() {
        return this.searchDn;
    }

    public Set<String> getObjectClasses() {
        return Collections.unmodifiableSet(this.objectClasses);
    }

    public Set<String> getReturningLdapAttributes() {
        return Collections.unmodifiableSet(this.returningLdapAttributes);
    }

    public Set<String> getReturningReadOnlyLdapAttributes() {
        return Collections.unmodifiableSet(this.returningReadOnlyLdapAttributes);
    }

    public List<UserFederationMapperModel> getMappers() {
        return this.mappers;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getPaginationContext() {
        return this.paginationContext;
    }

    public List<LDAPObject> getResultList() {
        for (UserFederationMapperModel userFederationMapperModel : this.mappers) {
            LDAPFederationMapper fedMapper = this.ldapFedProvider.getMapper(userFederationMapperModel);
            fedMapper.beforeLDAPQuery(userFederationMapperModel, this);
        }
        ArrayList<LDAPObject> result = new ArrayList<LDAPObject>();
        try {
            for (LDAPObject ldapObject : this.ldapFedProvider.getLdapIdentityStore().fetchQueryResults(this)) {
                result.add(ldapObject);
            }
        }
        catch (Exception exception) {
            throw new ModelException("LDAP Query failed", (Throwable)exception);
        }
        return result;
    }

    public LDAPObject getFirstResult() {
        List<LDAPObject> results = this.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new ModelDuplicateException("Error - multiple LDAP objects found but expected just one");
    }

    public int getResultCount() {
        return this.ldapFedProvider.getLdapIdentityStore().countQueryResults(this);
    }

    public LDAPQuery setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public LDAPQuery setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public LDAPQuery setPaginationContext(byte[] paginationContext) {
        this.paginationContext = paginationContext;
        return this;
    }

    public Set<Condition> getConditions() {
        return this.conditions;
    }

    public String getLdapFilter() {
        return this.ldapFilter;
    }

    public void setLdapFilter(String ldapFilter) {
        this.ldapFilter = ldapFilter;
    }
}

