/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.keycloak.models.LDAPConstants;
import org.keycloak.models.UserFederationProvider;

public class LDAPConfig {
    private final Map<String, String> config;

    public LDAPConfig(Map<String, String> config) {
        this.config = config;
    }

    public String getConnectionUrl() {
        return this.config.get("connectionUrl");
    }

    public String getFactoryName() {
        return "com.sun.jndi.ldap.LdapCtxFactory";
    }

    public String getAuthType() {
        String value = this.config.get("authType");
        if (value == null) {
            return "simple";
        }
        return value;
    }

    public String getSecurityProtocol() {
        return this.config.get("securityProtocol");
    }

    public String getUsersDn() {
        String usersDn = this.config.get("usersDn");
        if (usersDn == null) {
            usersDn = this.config.get("userDnSuffix");
        }
        return usersDn;
    }

    public Collection<String> getUserObjectClasses() {
        String objClassesCfg = this.config.get("userObjectClasses");
        String objClassesStr = objClassesCfg != null && objClassesCfg.length() > 0 ? objClassesCfg.trim() : "inetOrgPerson,organizationalPerson";
        String[] objectClasses = objClassesStr.split(",");
        HashSet<String> userObjClasses = new HashSet<String>();
        for (int i = 0; i < objectClasses.length; ++i) {
            userObjClasses.add(objectClasses[i].trim());
        }
        return userObjClasses;
    }

    public String getBindDN() {
        return this.config.get("bindDn");
    }

    public String getBindCredential() {
        return this.config.get("bindCredential");
    }

    public String getVendor() {
        return this.config.get("vendor");
    }

    public boolean isActiveDirectory() {
        String vendor = this.getVendor();
        return vendor != null && vendor.equals("ad");
    }

    public String getConnectionPooling() {
        return this.config.get("connectionPooling");
    }

    public Properties getAdditionalConnectionProperties() {
        return null;
    }

    public int getSearchScope() {
        String searchScope = this.config.get("searchScope");
        return searchScope == null ? 2 : Integer.parseInt(searchScope);
    }

    public String getUuidLDAPAttributeName() {
        String uuidAttrName = this.config.get("uuidLDAPAttribute");
        if (uuidAttrName == null) {
            String vendor = this.getVendor();
            uuidAttrName = LDAPConstants.getUuidAttributeName((String)vendor);
        }
        return uuidAttrName;
    }

    public boolean isPagination() {
        String pagination = this.config.get("pagination");
        return pagination == null ? false : Boolean.parseBoolean(pagination);
    }

    public String getUsernameLdapAttribute() {
        String username = this.config.get("usernameLDAPAttribute");
        if (username == null) {
            username = this.isActiveDirectory() ? "cn" : "uid";
        }
        return username;
    }

    public String getRdnLdapAttribute() {
        String rdn = this.config.get("rdnLDAPAttribute");
        if (rdn == null && (rdn = this.getUsernameLdapAttribute()).equalsIgnoreCase("sAMAccountName")) {
            rdn = "cn";
        }
        return rdn;
    }

    public String getCustomUserSearchFilter() {
        String customFilter = this.config.get("customUserSearchFilter");
        if (customFilter != null && (customFilter = customFilter.trim()).length() > 0) {
            return customFilter;
        }
        return null;
    }

    public UserFederationProvider.EditMode getEditMode() {
        String editModeString = this.config.get("editMode");
        if (editModeString == null) {
            return UserFederationProvider.EditMode.READ_ONLY;
        }
        return UserFederationProvider.EditMode.valueOf((String)editModeString);
    }
}

