/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.model;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import javax.naming.ldap.Rdn;

public class LDAPDn {
    private final Deque<Entry> entries = new LinkedList<Entry>();

    public static LDAPDn fromString(String dnString) {
        String[] rdns;
        LDAPDn dn = new LDAPDn();
        for (String entryStr : rdns = dnString.split("(?<!\\\\),")) {
            String[] rdn = entryStr.split("(?<!\\\\)=");
            dn.addLast(rdn[0].trim(), rdn[1].trim());
        }
        return dn;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LDAPDn)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return LDAPDn.toString(this.entries);
    }

    private static String toString(Collection<Entry> entries) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Entry rdn : entries) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(rdn.attrName).append("=").append(rdn.attrValue);
        }
        return builder.toString();
    }

    public String getFirstRdn() {
        Entry firstEntry = this.entries.getFirst();
        return firstEntry.attrName + "=" + firstEntry.attrValue;
    }

    public String getFirstRdnAttrName() {
        Entry firstEntry = this.entries.getFirst();
        return firstEntry.attrName;
    }

    public String getFirstRdnAttrValue() {
        Entry firstEntry = this.entries.getFirst();
        return firstEntry.attrValue;
    }

    public String getParentDn() {
        LinkedList<Entry> parentDnEntries = new LinkedList<Entry>(this.entries);
        parentDnEntries.remove();
        return LDAPDn.toString(parentDnEntries);
    }

    public boolean isDescendantOf(LDAPDn expectedParentDn) {
        int parentEntriesCount = expectedParentDn.entries.size();
        LinkedList<Entry> myEntries = new LinkedList<Entry>(this.entries);
        boolean someRemoved = false;
        while (myEntries.size() > parentEntriesCount) {
            myEntries.removeFirst();
            someRemoved = true;
        }
        String myEntriesParentStr = LDAPDn.toString(myEntries).toLowerCase();
        String expectedParentDnStr = expectedParentDn.toString().toLowerCase();
        return someRemoved && myEntriesParentStr.equals(expectedParentDnStr);
    }

    public void addFirst(String rdnName, String rdnValue) {
        rdnValue = Rdn.escapeValue(rdnValue);
        this.entries.addFirst(new Entry(rdnName, rdnValue));
    }

    private void addLast(String rdnName, String rdnValue) {
        this.entries.addLast(new Entry(rdnName, rdnValue));
    }

    private static class Entry {
        private final String attrName;
        private final String attrValue;

        private Entry(String attrName, String attrValue) {
            this.attrName = attrName;
            this.attrValue = attrValue;
        }
    }
}

