/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.LDAPCapabilityRepresentation;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.LDAPServerCapabilitiesManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class LdapServerCapabilitiesResource {
    private static final Logger logger = Logger.getLogger(LdapServerCapabilitiesResource.class);
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public LdapServerCapabilitiesResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
    }

    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response ldapServerCapabilities(TestLdapConnectionRepresentation config) {
        this.auth.realm().requireManageRealm();
        try {
            Set<LDAPCapabilityRepresentation> ldapCapabilities = LDAPServerCapabilitiesManager.queryServerCapabilities(config, this.session, this.realm);
            return Response.ok().entity(ldapCapabilities).build();
        }
        catch (Exception e) {
            return ErrorResponse.error((String)"ldapServerCapabilities error", (Response.Status)Response.Status.BAD_REQUEST);
        }
    }
}

