/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.query.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.Sort;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPContextManager;
import org.keycloak.storage.ldap.mappers.LDAPMappersComparator;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;

public class LDAPQuery
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(LDAPQuery.class);
    private final LDAPStorageProvider ldapFedProvider;
    private int offset;
    private int limit;
    private PaginationContext paginationContext;
    private LDAPContextManager ldapContextManager;
    private String searchDn;
    private final Set<Condition> conditions = new LinkedHashSet<Condition>();
    private final Set<Sort> ordering = new LinkedHashSet<Sort>();
    private final Set<String> returningLdapAttributes = new LinkedHashSet<String>();
    private final Set<String> returningReadOnlyLdapAttributes = new LinkedHashSet<String>();
    private final Set<String> objectClasses = new LinkedHashSet<String>();
    private final List<ComponentModel> mappers = new ArrayList<ComponentModel>();
    private int searchScope = 2;

    public LDAPQuery(LDAPStorageProvider ldapProvider) {
        this.ldapFedProvider = ldapProvider;
    }

    public LDAPQuery addWhereCondition(Condition ... condition) {
        this.conditions.addAll(Arrays.asList(condition));
        return this;
    }

    public LDAPQuery sortBy(Sort ... sorts) {
        this.ordering.addAll(Arrays.asList(sorts));
        return this;
    }

    public LDAPQuery setSearchDn(String searchDn) {
        this.searchDn = searchDn;
        return this;
    }

    public LDAPQuery addObjectClasses(Collection<String> objectClasses) {
        this.objectClasses.addAll(objectClasses);
        return this;
    }

    public LDAPQuery addReturningLdapAttribute(String ldapAttributeName) {
        this.returningLdapAttributes.add(ldapAttributeName);
        return this;
    }

    public LDAPQuery addReturningReadOnlyLdapAttribute(String ldapAttributeName) {
        this.returningReadOnlyLdapAttributes.add(ldapAttributeName.toLowerCase());
        return this;
    }

    public LDAPQuery addMappers(Collection<ComponentModel> mappers) {
        this.mappers.addAll(mappers);
        return this;
    }

    public LDAPQuery setSearchScope(int searchScope) {
        this.searchScope = searchScope;
        return this;
    }

    public Set<Sort> getSorting() {
        return Collections.unmodifiableSet(this.ordering);
    }

    public String getSearchDn() {
        return this.searchDn;
    }

    public Set<String> getObjectClasses() {
        return Collections.unmodifiableSet(this.objectClasses);
    }

    public Set<String> getReturningLdapAttributes() {
        return Collections.unmodifiableSet(this.returningLdapAttributes);
    }

    public Set<String> getReturningReadOnlyLdapAttributes() {
        return Collections.unmodifiableSet(this.returningReadOnlyLdapAttributes);
    }

    public List<ComponentModel> getMappers() {
        return this.mappers;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public PaginationContext getPaginationContext() {
        return this.paginationContext;
    }

    public List<LDAPObject> getResultList() {
        LDAPMappersComparator ldapMappersComparator = new LDAPMappersComparator(this.ldapFedProvider.getLdapIdentityStore().getConfig());
        Collections.sort(this.mappers, ldapMappersComparator.sortAsc());
        for (ComponentModel componentModel : this.mappers) {
            LDAPStorageMapper fedMapper = this.ldapFedProvider.getMapperManager().getMapper(componentModel);
            fedMapper.beforeLDAPQuery(this);
        }
        ArrayList<LDAPObject> result = new ArrayList<LDAPObject>();
        try {
            for (LDAPObject ldapObject : this.ldapFedProvider.getLdapIdentityStore().fetchQueryResults(this)) {
                result.add(ldapObject);
            }
        }
        catch (Exception exception) {
            throw new ModelException("LDAP Query failed", (Throwable)exception);
        }
        return result;
    }

    public LDAPObject getFirstResult() {
        List<LDAPObject> results = this.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new ModelDuplicateException("Error - multiple LDAP objects found but expected just one");
    }

    public int getResultCount() {
        return this.ldapFedProvider.getLdapIdentityStore().countQueryResults(this);
    }

    public LDAPQuery setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public LDAPQuery setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public LDAPQuery initPagination() throws NamingException {
        this.ldapContextManager = LDAPContextManager.create(this.ldapFedProvider.getSession(), this.ldapFedProvider.getLdapIdentityStore().getConfig());
        this.paginationContext = new PaginationContext(this.ldapContextManager.getLdapContext());
        return this;
    }

    public Set<Condition> getConditions() {
        return this.conditions;
    }

    public LDAPStorageProvider getLdapProvider() {
        return this.ldapFedProvider;
    }

    @Override
    public void close() {
        if (this.ldapContextManager != null) {
            this.ldapContextManager.close();
        }
    }

    public static class PaginationContext {
        private final LdapContext ldapContext;
        private byte[] cookie;

        private PaginationContext(LdapContext ldapContext) {
            if (ldapContext == null) {
                throw new IllegalArgumentException("Bad usage. Ldap context must be not null");
            }
            this.ldapContext = ldapContext;
        }

        public LdapContext getLdapContext() {
            return this.ldapContext;
        }

        public byte[] getCookie() {
            return this.cookie;
        }

        public void setCookie(byte[] cookie) {
            this.cookie = cookie;
        }

        public boolean hasNextPage() {
            return this.cookie != null;
        }
    }
}

