/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.models.utils.reflection.PropertyCriteria;
import org.keycloak.models.utils.reflection.PropertyQueries;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.mappers.LDAPMappersComparator;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;

public class LDAPUtils {
    private static final Logger log = Logger.getLogger(LDAPUtils.class);

    public static LDAPObject addUserToLDAP(LDAPStorageProvider ldapProvider, RealmModel realm, UserModel user) {
        return LDAPUtils.addUserToLDAP(ldapProvider, realm, user, null);
    }

    public static LDAPObject addUserToLDAP(LDAPStorageProvider ldapProvider, RealmModel realm, UserModel user, Consumer<LDAPObject> consumerOnCreated) {
        LDAPObject ldapUser = new LDAPObject();
        LDAPIdentityStore ldapStore = ldapProvider.getLdapIdentityStore();
        LDAPConfig ldapConfig = ldapStore.getConfig();
        ldapUser.setRdnAttributeName(ldapConfig.getRdnLdapAttribute());
        ldapUser.setObjectClasses(ldapConfig.getUserObjectClasses());
        LDAPMappersComparator ldapMappersComparator = new LDAPMappersComparator(ldapConfig);
        Set<String> mandatoryAttrs = realm.getComponentsStream(ldapProvider.getModel().getId(), LDAPStorageMapper.class.getName()).sorted(ldapMappersComparator.sortAsc()).map(mapperModel -> {
            LDAPStorageMapper ldapMapper = ldapProvider.getMapperManager().getMapper((ComponentModel)mapperModel);
            ldapMapper.onRegisterUserToLDAP(ldapUser, user, realm);
            return ldapMapper.mandatoryAttributeNames();
        }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        mandatoryAttrs.add(ldapConfig.getRdnLdapAttribute());
        ldapUser.executeOnMandatoryAttributesComplete(mandatoryAttrs, ldapObject -> {
            LDAPUtils.computeAndSetDn(ldapConfig, ldapObject);
            ldapStore.add((LDAPObject)ldapObject);
            if (consumerOnCreated != null) {
                consumerOnCreated.accept((LDAPObject)ldapObject);
            }
        });
        return ldapUser;
    }

    public static LDAPQuery createQueryForUserSearch(LDAPStorageProvider ldapProvider, RealmModel realm) {
        LDAPQuery ldapQuery = new LDAPQuery(ldapProvider);
        LDAPConfig config = ldapProvider.getLdapIdentityStore().getConfig();
        ldapQuery.setSearchScope(config.getSearchScope());
        ldapQuery.setSearchDn(config.getUsersDn());
        ldapQuery.addObjectClasses(config.getUserObjectClasses());
        String customFilter = config.getCustomUserSearchFilter();
        if (customFilter != null) {
            Condition customFilterCondition = new LDAPQueryConditionsBuilder().addCustomLDAPFilter(customFilter);
            ldapQuery.addWhereCondition(customFilterCondition);
        }
        List<ComponentModel> mapperModels = realm.getComponentsStream(ldapProvider.getModel().getId(), LDAPStorageMapper.class.getName()).collect(Collectors.toList());
        ldapQuery.addMappers(mapperModels);
        String kerberosPrincipalAttr = ldapProvider.getKerberosConfig().getKerberosPrincipalAttribute();
        if (kerberosPrincipalAttr != null) {
            ldapQuery.addReturningLdapAttribute(kerberosPrincipalAttr);
            ldapQuery.addReturningReadOnlyLdapAttribute(kerberosPrincipalAttr);
        }
        if (config.isActiveDirectory()) {
            ldapQuery.addReturningLdapAttribute("pwdLastSet");
        } else {
            ldapQuery.addReturningLdapAttribute("pwdChangedTime");
        }
        return ldapQuery;
    }

    public static void computeAndSetDn(LDAPConfig config, LDAPObject ldapUser) {
        String rdnLdapAttrName = config.getRdnLdapAttribute();
        String rdnLdapAttrValue = ldapUser.getAttributeAsString(rdnLdapAttrName);
        if (rdnLdapAttrValue == null) {
            throw new ModelException("RDN Attribute [" + rdnLdapAttrName + "] is not filled. Filled attributes: " + String.valueOf(ldapUser.getAttributes()));
        }
        LDAPDn dn = LDAPDn.fromString(config.getRelativeCreateDn() + config.getUsersDn());
        dn.addFirst(rdnLdapAttrName, rdnLdapAttrValue);
        ldapUser.setDn(dn);
    }

    public static String getUsername(LDAPObject ldapUser, LDAPConfig config) {
        String usernameAttr = config.getUsernameLdapAttribute();
        String ldapUsername = ldapUser.getAttributeAsString(usernameAttr);
        if (ldapUsername == null) {
            throw new ModelException("User returned from LDAP has null username! Check configuration of your LDAP mappings. Mapped username LDAP attribute: " + config.getUsernameLdapAttribute() + ", user DN: " + String.valueOf(ldapUser.getDn()) + ", attributes from LDAP: " + String.valueOf(ldapUser.getAttributes()));
        }
        return ldapUsername;
    }

    public static void checkUuid(LDAPObject ldapUser, LDAPConfig config) {
        if (ldapUser.getUuid() == null) {
            throw new ModelException("User returned from LDAP has null uuid! Check configuration of your LDAP settings. UUID Attribute must be unique among your LDAP records and available on all the LDAP user records. If your LDAP server really doesn't support the notion of UUID, you can use any other attribute, which is supposed to be unique among LDAP users in tree. For example 'uid' or 'entryDN' . Mapped UUID LDAP attribute: " + config.getUuidLDAPAttributeName() + ", user DN: " + String.valueOf(ldapUser.getDn()));
        }
    }

    public static LDAPObject createLDAPGroup(LDAPStorageProvider ldapProvider, String groupName, String groupNameAttribute, Collection<String> objectClasses, String parentDn, Map<String, Set<String>> additionalAttributes, String membershipLdapAttribute) {
        LDAPObject ldapObject = new LDAPObject();
        ldapObject.setRdnAttributeName(groupNameAttribute);
        ldapObject.setObjectClasses(objectClasses);
        ldapObject.setSingleAttribute(groupNameAttribute, groupName);
        for (String objectClassValue : objectClasses) {
            if (!objectClassValue.equalsIgnoreCase("groupOfNames") && !objectClassValue.equalsIgnoreCase("groupOfEntries") && !objectClassValue.equalsIgnoreCase("groupOfUniqueNames") || additionalAttributes.get(membershipLdapAttribute) != null) continue;
            ldapObject.setSingleAttribute(membershipLdapAttribute, "cn=empty-membership-placeholder");
        }
        LDAPDn roleDn = LDAPDn.fromString(parentDn);
        roleDn.addFirst(groupNameAttribute, groupName);
        ldapObject.setDn(roleDn);
        for (Map.Entry<String, Set<String>> attrEntry : additionalAttributes.entrySet()) {
            ldapObject.setAttribute(attrEntry.getKey(), attrEntry.getValue());
        }
        ldapProvider.getLdapIdentityStore().add(ldapObject);
        return ldapObject;
    }

    public static LDAPObject updateLDAPGroup(LDAPStorageProvider ldapProvider, LDAPObject ldapObject) {
        ldapProvider.getLdapIdentityStore().update(ldapObject);
        return ldapObject;
    }

    public static void addMember(LDAPStorageProvider ldapProvider, MembershipType membershipType, String memberAttrName, String memberChildAttrName, LDAPObject ldapParent, LDAPObject ldapChild) {
        String membership = LDAPUtils.getMemberValueOfChildObject(ldapChild, membershipType, memberChildAttrName);
        ldapProvider.getLdapIdentityStore().addMemberToGroup(ldapParent.getDn().getLdapName(), memberAttrName, membership);
    }

    public static void deleteMember(LDAPStorageProvider ldapProvider, MembershipType membershipType, String memberAttrName, String memberChildAttrName, LDAPObject ldapParent, LDAPObject ldapChild) {
        String userMembership = LDAPUtils.getMemberValueOfChildObject(ldapChild, membershipType, memberChildAttrName);
        ldapProvider.getLdapIdentityStore().removeMemberFromGroup(ldapParent.getDn().getLdapName(), memberAttrName, userMembership);
    }

    public static Set<String> getExistingMemberships(LDAPStorageProvider ldapProvider, String memberAttrName, LDAPObject ldapRole) {
        LDAPUtils.fillRangedAttribute(ldapProvider, ldapRole, memberAttrName);
        Set<String> memberships = ldapRole.getAttributeAsSet(memberAttrName);
        if (memberships == null) {
            memberships = new HashSet<String>();
        }
        return memberships;
    }

    public static String getMemberValueOfChildObject(LDAPObject ldapUser, MembershipType membershipType, String memberChildAttrName) {
        if (membershipType == MembershipType.DN) {
            return ldapUser.getDn().toString();
        }
        return ldapUser.getAttributeAsString(memberChildAttrName);
    }

    public static List<LDAPObject> loadAllLDAPObjects(LDAPQuery ldapQuery, LDAPStorageProvider ldapProvider) {
        LDAPConfig ldapConfig = ldapProvider.getLdapIdentityStore().getConfig();
        return LDAPUtils.loadAllLDAPObjects(ldapQuery, ldapConfig);
    }

    public static List<LDAPObject> loadAllLDAPObjects(LDAPQuery ldapQuery, LDAPConfig ldapConfig) {
        boolean pagination = ldapConfig.isPagination();
        if (pagination) {
            int pageSize = ldapConfig.getBatchSizeForSync();
            LinkedList<LDAPObject> result = new LinkedList<LDAPObject>();
            boolean nextPage = true;
            while (nextPage) {
                ldapQuery.setLimit(pageSize);
                List<LDAPObject> currentPageGroups = ldapQuery.getResultList();
                result.addAll(currentPageGroups);
                nextPage = ldapQuery.getPaginationContext().hasNextPage();
            }
            return result;
        }
        return ldapQuery.getResultList();
    }

    public static void validateCustomLdapFilter(String customFilter) throws ComponentValidationException {
        if (customFilter != null) {
            if ((customFilter = customFilter.trim()).isEmpty()) {
                return;
            }
            if (!customFilter.startsWith("(") || !customFilter.endsWith(")")) {
                throw new ComponentValidationException("ldapErrorInvalidCustomFilter", new Object[0]);
            }
        }
    }

    private static LDAPQuery createLdapQueryForRangeAttribute(LDAPStorageProvider ldapProvider, LDAPObject ldapObject, String name) {
        LDAPQuery q = new LDAPQuery(ldapProvider);
        q.setSearchDn(ldapObject.getDn().getLdapName());
        q.setSearchScope(0);
        q.addReturningLdapAttribute(name + ";range=" + (ldapObject.getCurrentRange(name) + 1) + "-*");
        return q;
    }

    public static void fillRangedAttribute(LDAPStorageProvider ldapProvider, LDAPObject ldapObject, String name) {
        LDAPObject newObject = ldapObject;
        while (!newObject.isRangeComplete(name)) {
            LDAPQuery q = LDAPUtils.createLdapQueryForRangeAttribute(ldapProvider, ldapObject, name);
            try {
                newObject = q.getFirstResult();
                ldapObject.populateRangedAttribute(newObject, name);
            }
            finally {
                if (q == null) continue;
                q.close();
            }
        }
    }

    public static Map<String, Property<Object>> getUserModelProperties() {
        Map userModelProps = PropertyQueries.createQuery(UserModel.class).addCriteria(new PropertyCriteria(){

            public boolean methodMatches(Method m) {
                return !m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getParameterCount() <= 0;
            }
        }).getResultList();
        HashMap<String, Property<Object>> userModelProperties = new HashMap<String, Property<Object>>();
        for (Map.Entry entry : userModelProps.entrySet()) {
            userModelProperties.put(((String)entry.getKey()).toLowerCase(), (Property<Object>)((Property)entry.getValue()));
        }
        return userModelProperties;
    }

    public static String getDefaultKerberosUserPrincipalAttribute(String vendor) {
        if (vendor != null) {
            switch (vendor) {
                case "rhds": {
                    return "krbPrincipalName";
                }
                case "ad": {
                    return "userPrincipalName";
                }
            }
        }
        return "krb5PrincipalName";
    }

    static Date generalizedTimeToDate(String generalized) {
        String[] parts = generalized.split("[Z+-]");
        String[] timeFraction = parts[0].split("[.,]");
        String time = timeFraction[0];
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.setLenient(false);
        calendar.set(1, Integer.parseInt(time.substring(0, 4)));
        calendar.set(2, Integer.parseInt(time.substring(4, 6)) - 1);
        calendar.set(5, Integer.parseInt(time.substring(6, 8)));
        calendar.set(11, Integer.parseInt(time.substring(8, 10)));
        if (time.length() >= 12) {
            calendar.set(12, Integer.parseInt(time.substring(10, 12)));
        }
        if (time.length() >= 14) {
            calendar.set(13, Integer.parseInt(time.substring(12, 14)));
        }
        if (timeFraction.length >= 2) {
            double fraction = Double.parseDouble("0." + timeFraction[1]);
            if (time.length() >= 14) {
                calendar.set(14, (int)Math.round(fraction * 1000.0));
            } else if (time.length() >= 12) {
                calendar.set(13, (int)Math.round(fraction * 60.0));
            } else {
                calendar.set(12, (int)Math.round(fraction * 60.0));
            }
        }
        if (generalized.length() > parts[0].length()) {
            char delimiter = generalized.charAt(parts[0].length());
            if (delimiter == 'Z') {
                calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                calendar.setTimeZone(TimeZone.getTimeZone("GMT" + delimiter + parts[1]));
            }
        }
        return calendar.getTime();
    }
}

