/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;

public class LDAPTransaction
implements KeycloakTransaction {
    public static final Logger logger = Logger.getLogger(LDAPTransaction.class);
    protected TransactionState state = TransactionState.NOT_STARTED;
    private final LDAPStorageProvider ldapProvider;
    private final LDAPObject ldapUser;

    public LDAPTransaction(LDAPStorageProvider ldapProvider, LDAPObject ldapUser) {
        this.ldapProvider = ldapProvider;
        this.ldapUser = ldapUser;
    }

    public void begin() {
        if (this.state != TransactionState.NOT_STARTED) {
            throw new IllegalStateException("Transaction already started");
        }
        this.state = TransactionState.STARTED;
    }

    public void commit() {
        if (this.state != TransactionState.STARTED) {
            throw new IllegalStateException("Transaction in illegal state for commit: " + (Object)((Object)this.state));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Transaction commit! Updating LDAP attributes for object " + this.ldapUser.getDn().toString() + ", attributes: " + this.ldapUser.getAttributes()));
        }
        this.ldapProvider.getLdapIdentityStore().update(this.ldapUser);
        this.state = TransactionState.FINISHED;
    }

    public void rollback() {
        if (this.state != TransactionState.STARTED && this.state != TransactionState.ROLLBACK_ONLY) {
            throw new IllegalStateException("Transaction in illegal state for rollback: " + (Object)((Object)this.state));
        }
        logger.warn((Object)("Transaction rollback! Ignoring LDAP updates for object " + this.ldapUser.getDn().toString()));
        this.state = TransactionState.FINISHED;
    }

    public void setRollbackOnly() {
        this.state = TransactionState.ROLLBACK_ONLY;
    }

    public boolean getRollbackOnly() {
        return this.state == TransactionState.ROLLBACK_ONLY;
    }

    public boolean isActive() {
        return this.state == TransactionState.STARTED || this.state == TransactionState.ROLLBACK_ONLY;
    }

    protected static enum TransactionState {
        NOT_STARTED,
        STARTED,
        ROLLBACK_ONLY,
        FINISHED;

    }
}

