/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserFederationMapperRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;

public class ModelToRepresentation {
    public static UserRepresentation toRepresentation(UserModel user) {
        UserRepresentation rep = new UserRepresentation();
        rep.setId(user.getId());
        rep.setUsername(user.getUsername());
        rep.setCreatedTimestamp(user.getCreatedTimestamp());
        rep.setLastName(user.getLastName());
        rep.setFirstName(user.getFirstName());
        rep.setEmail(user.getEmail());
        rep.setEnabled(user.isEnabled());
        rep.setEmailVerified(user.isEmailVerified());
        rep.setTotp(user.isOtpEnabled());
        rep.setFederationLink(user.getFederationLink());
        ArrayList<String> reqActions = new ArrayList<String>();
        Set<String> requiredActions = user.getRequiredActions();
        for (String ra : requiredActions) {
            reqActions.add(ra);
        }
        rep.setRequiredActions(reqActions);
        if (user.getAttributes() != null && !user.getAttributes().isEmpty()) {
            HashMap<String, List<String>> attrs = new HashMap<String, List<String>>();
            attrs.putAll(user.getAttributes());
            rep.setAttributes(attrs);
        }
        return rep;
    }

    public static RoleRepresentation toRepresentation(RoleModel role) {
        RoleRepresentation rep = new RoleRepresentation();
        rep.setId(role.getId());
        rep.setName(role.getName());
        rep.setDescription(role.getDescription());
        rep.setScopeParamRequired(Boolean.valueOf(role.isScopeParamRequired()));
        rep.setComposite(role.isComposite());
        return rep;
    }

    public static RealmRepresentation toRepresentation(RealmModel realm, boolean internal) {
        List<UserFederationProviderModel> fedProviderModels;
        List<RequiredCredentialModel> requiredCredentialModels;
        List<String> defaultRoles;
        RealmRepresentation rep = new RealmRepresentation();
        rep.setId(realm.getId());
        rep.setRealm(realm.getName());
        rep.setEnabled(Boolean.valueOf(realm.isEnabled()));
        rep.setNotBefore(Integer.valueOf(realm.getNotBefore()));
        rep.setSslRequired(realm.getSslRequired().name().toLowerCase());
        rep.setPublicKey(realm.getPublicKeyPem());
        if (internal) {
            rep.setPrivateKey(realm.getPrivateKeyPem());
            String privateKeyPem = realm.getPrivateKeyPem();
            if (realm.getCertificatePem() == null && privateKeyPem != null) {
                KeycloakModelUtils.generateRealmCertificate(realm);
            }
            rep.setCodeSecret(realm.getCodeSecret());
        }
        rep.setCertificate(realm.getCertificatePem());
        rep.setRegistrationAllowed(Boolean.valueOf(realm.isRegistrationAllowed()));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(realm.isRegistrationEmailAsUsername()));
        rep.setRememberMe(Boolean.valueOf(realm.isRememberMe()));
        rep.setBruteForceProtected(Boolean.valueOf(realm.isBruteForceProtected()));
        rep.setMaxFailureWaitSeconds(Integer.valueOf(realm.getMaxFailureWaitSeconds()));
        rep.setMinimumQuickLoginWaitSeconds(Integer.valueOf(realm.getMinimumQuickLoginWaitSeconds()));
        rep.setWaitIncrementSeconds(Integer.valueOf(realm.getWaitIncrementSeconds()));
        rep.setQuickLoginCheckMilliSeconds(Long.valueOf(realm.getQuickLoginCheckMilliSeconds()));
        rep.setMaxDeltaTimeSeconds(Integer.valueOf(realm.getMaxDeltaTimeSeconds()));
        rep.setFailureFactor(Integer.valueOf(realm.getFailureFactor()));
        rep.setEventsEnabled(realm.isEventsEnabled());
        if (realm.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(realm.getEventsExpiration());
        }
        if (realm.getEventsListeners() != null) {
            rep.setEventsListeners(new LinkedList<String>(realm.getEventsListeners()));
        }
        if (realm.getEnabledEventTypes() != null) {
            rep.setEnabledEventTypes(new LinkedList<String>(realm.getEnabledEventTypes()));
        }
        rep.setAdminEventsEnabled(Boolean.valueOf(realm.isAdminEventsEnabled()));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(realm.isAdminEventsDetailsEnabled()));
        rep.setVerifyEmail(Boolean.valueOf(realm.isVerifyEmail()));
        rep.setResetPasswordAllowed(Boolean.valueOf(realm.isResetPasswordAllowed()));
        rep.setEditUsernameAllowed(Boolean.valueOf(realm.isEditUsernameAllowed()));
        rep.setRevokeRefreshToken(Boolean.valueOf(realm.isRevokeRefreshToken()));
        rep.setAccessTokenLifespan(Integer.valueOf(realm.getAccessTokenLifespan()));
        rep.setSsoSessionIdleTimeout(Integer.valueOf(realm.getSsoSessionIdleTimeout()));
        rep.setSsoSessionMaxLifespan(Integer.valueOf(realm.getSsoSessionMaxLifespan()));
        rep.setOfflineSessionIdleTimeout(Integer.valueOf(realm.getOfflineSessionIdleTimeout()));
        rep.setAccessCodeLifespan(Integer.valueOf(realm.getAccessCodeLifespan()));
        rep.setAccessCodeLifespanUserAction(Integer.valueOf(realm.getAccessCodeLifespanUserAction()));
        rep.setAccessCodeLifespanLogin(Integer.valueOf(realm.getAccessCodeLifespanLogin()));
        rep.setSmtpServer(realm.getSmtpConfig());
        rep.setBrowserSecurityHeaders(realm.getBrowserSecurityHeaders());
        rep.setAccountTheme(realm.getAccountTheme());
        rep.setLoginTheme(realm.getLoginTheme());
        rep.setAdminTheme(realm.getAdminTheme());
        rep.setEmailTheme(realm.getEmailTheme());
        if (realm.getPasswordPolicy() != null) {
            rep.setPasswordPolicy(realm.getPasswordPolicy().toString());
        }
        OTPPolicy otpPolicy = realm.getOTPPolicy();
        rep.setOtpPolicyAlgorithm(otpPolicy.getAlgorithm());
        rep.setOtpPolicyPeriod(Integer.valueOf(otpPolicy.getPeriod()));
        rep.setOtpPolicyDigits(Integer.valueOf(otpPolicy.getDigits()));
        rep.setOtpPolicyInitialCounter(Integer.valueOf(otpPolicy.getInitialCounter()));
        rep.setOtpPolicyType(otpPolicy.getType());
        rep.setOtpPolicyLookAheadWindow(Integer.valueOf(otpPolicy.getLookAheadWindow()));
        if (realm.getBrowserFlow() != null) {
            rep.setBrowserFlow(realm.getBrowserFlow().getAlias());
        }
        if (realm.getRegistrationFlow() != null) {
            rep.setRegistrationFlow(realm.getRegistrationFlow().getAlias());
        }
        if (realm.getDirectGrantFlow() != null) {
            rep.setDirectGrantFlow(realm.getDirectGrantFlow().getAlias());
        }
        if (realm.getResetCredentialsFlow() != null) {
            rep.setResetCredentialsFlow(realm.getResetCredentialsFlow().getAlias());
        }
        if (realm.getClientAuthenticationFlow() != null) {
            rep.setClientAuthenticationFlow(realm.getClientAuthenticationFlow().getAlias());
        }
        if (!(defaultRoles = realm.getDefaultRoles()).isEmpty()) {
            ArrayList<String> roleStrings = new ArrayList<String>();
            roleStrings.addAll(defaultRoles);
            rep.setDefaultRoles(roleStrings);
        }
        if ((requiredCredentialModels = realm.getRequiredCredentials()).size() > 0) {
            rep.setRequiredCredentials(new HashSet());
            for (RequiredCredentialModel cred : requiredCredentialModels) {
                rep.getRequiredCredentials().add(cred.getType());
            }
        }
        if ((fedProviderModels = realm.getUserFederationProviders()).size() > 0) {
            ArrayList<UserFederationProviderRepresentation> fedProviderReps = new ArrayList<UserFederationProviderRepresentation>();
            for (UserFederationProviderModel model : fedProviderModels) {
                UserFederationProviderRepresentation fedProvRep = ModelToRepresentation.toRepresentation(model);
                fedProviderReps.add(fedProvRep);
            }
            rep.setUserFederationProviders(fedProviderReps);
        }
        for (UserFederationMapperModel userFederationMapperModel : realm.getUserFederationMappers()) {
            rep.addUserFederationMapper(ModelToRepresentation.toRepresentation(realm, userFederationMapperModel));
        }
        for (IdentityProviderModel identityProviderModel : realm.getIdentityProviders()) {
            rep.addIdentityProvider(ModelToRepresentation.toRepresentation(identityProviderModel));
        }
        for (IdentityProviderMapperModel identityProviderMapperModel : realm.getIdentityProviderMappers()) {
            rep.addIdentityProviderMapper(ModelToRepresentation.toRepresentation(identityProviderMapperModel));
        }
        rep.setInternationalizationEnabled(Boolean.valueOf(realm.isInternationalizationEnabled()));
        if (realm.getSupportedLocales() != null) {
            rep.setSupportedLocales(new HashSet());
            rep.getSupportedLocales().addAll(realm.getSupportedLocales());
        }
        rep.setDefaultLocale(realm.getDefaultLocale());
        if (internal) {
            ModelToRepresentation.exportAuthenticationFlows(realm, rep);
            ModelToRepresentation.exportRequiredActions(realm, rep);
        }
        return rep;
    }

    public static void exportAuthenticationFlows(RealmModel realm, RealmRepresentation rep) {
        rep.setAuthenticationFlows(new LinkedList());
        rep.setAuthenticatorConfig(new LinkedList());
        for (AuthenticationFlowModel authenticationFlowModel : realm.getAuthenticationFlows()) {
            AuthenticationFlowRepresentation flowRep = ModelToRepresentation.toRepresentation(realm, authenticationFlowModel);
            rep.getAuthenticationFlows().add(flowRep);
        }
        for (AuthenticatorConfigModel authenticatorConfigModel : realm.getAuthenticatorConfigs()) {
            rep.getAuthenticatorConfig().add(ModelToRepresentation.toRepresentation(authenticatorConfigModel));
        }
    }

    public static void exportRequiredActions(RealmModel realm, RealmRepresentation rep) {
        rep.setRequiredActions(new LinkedList());
        for (RequiredActionProviderModel model : realm.getRequiredActionProviders()) {
            RequiredActionProviderRepresentation action = ModelToRepresentation.toRepresentation(model);
            rep.getRequiredActions().add(action);
        }
    }

    public static RealmEventsConfigRepresentation toEventsConfigReprensetation(RealmModel realm) {
        RealmEventsConfigRepresentation rep = new RealmEventsConfigRepresentation();
        rep.setEventsEnabled(realm.isEventsEnabled());
        if (realm.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(Long.valueOf(realm.getEventsExpiration()));
        }
        if (realm.getEventsListeners() != null) {
            rep.setEventsListeners(new LinkedList<String>(realm.getEventsListeners()));
        }
        if (realm.getEnabledEventTypes() != null) {
            rep.setEnabledEventTypes(new LinkedList<String>(realm.getEnabledEventTypes()));
        }
        rep.setAdminEventsEnabled(Boolean.valueOf(realm.isAdminEventsEnabled()));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(realm.isAdminEventsDetailsEnabled()));
        return rep;
    }

    public static CredentialRepresentation toRepresentation(UserCredentialModel cred) {
        CredentialRepresentation rep = new CredentialRepresentation();
        rep.setType("secret");
        rep.setValue(cred.getValue());
        return rep;
    }

    public static FederatedIdentityRepresentation toRepresentation(FederatedIdentityModel socialLink) {
        FederatedIdentityRepresentation rep = new FederatedIdentityRepresentation();
        rep.setUserName(socialLink.getUserName());
        rep.setIdentityProvider(socialLink.getIdentityProvider());
        rep.setUserId(socialLink.getUserId());
        return rep;
    }

    public static UserSessionRepresentation toRepresentation(UserSessionModel session) {
        UserSessionRepresentation rep = new UserSessionRepresentation();
        rep.setId(session.getId());
        rep.setStart(Time.toMillis((int)session.getStarted()));
        rep.setLastAccess(Time.toMillis((int)session.getLastSessionRefresh()));
        rep.setUsername(session.getUser().getUsername());
        rep.setUserId(session.getUser().getId());
        rep.setIpAddress(session.getIpAddress());
        for (ClientSessionModel clientSession : session.getClientSessions()) {
            ClientModel client = clientSession.getClient();
            rep.getClients().put(client.getId(), client.getClientId());
        }
        return rep;
    }

    public static ClientRepresentation toRepresentation(ClientModel clientModel) {
        Set<String> webOrigins;
        ClientRepresentation rep = new ClientRepresentation();
        rep.setId(clientModel.getId());
        rep.setClientId(clientModel.getClientId());
        rep.setName(clientModel.getName());
        rep.setDescription(clientModel.getDescription());
        rep.setEnabled(Boolean.valueOf(clientModel.isEnabled()));
        rep.setAdminUrl(clientModel.getManagementUrl());
        rep.setPublicClient(Boolean.valueOf(clientModel.isPublicClient()));
        rep.setFrontchannelLogout(Boolean.valueOf(clientModel.isFrontchannelLogout()));
        rep.setProtocol(clientModel.getProtocol());
        rep.setAttributes(clientModel.getAttributes());
        rep.setFullScopeAllowed(Boolean.valueOf(clientModel.isFullScopeAllowed()));
        rep.setBearerOnly(Boolean.valueOf(clientModel.isBearerOnly()));
        rep.setConsentRequired(Boolean.valueOf(clientModel.isConsentRequired()));
        rep.setServiceAccountsEnabled(Boolean.valueOf(clientModel.isServiceAccountsEnabled()));
        rep.setDirectGrantsOnly(Boolean.valueOf(clientModel.isDirectGrantsOnly()));
        rep.setSurrogateAuthRequired(Boolean.valueOf(clientModel.isSurrogateAuthRequired()));
        rep.setRootUrl(clientModel.getRootUrl());
        rep.setBaseUrl(clientModel.getBaseUrl());
        rep.setNotBefore(Integer.valueOf(clientModel.getNotBefore()));
        rep.setNodeReRegistrationTimeout(Integer.valueOf(clientModel.getNodeReRegistrationTimeout()));
        rep.setClientAuthenticatorType(clientModel.getClientAuthenticatorType());
        Set<String> redirectUris = clientModel.getRedirectUris();
        if (redirectUris != null) {
            rep.setRedirectUris(new LinkedList<String>(redirectUris));
        }
        if ((webOrigins = clientModel.getWebOrigins()) != null) {
            rep.setWebOrigins(new LinkedList<String>(webOrigins));
        }
        if (!clientModel.getDefaultRoles().isEmpty()) {
            rep.setDefaultRoles(clientModel.getDefaultRoles().toArray(new String[0]));
        }
        if (!clientModel.getRegisteredNodes().isEmpty()) {
            rep.setRegisteredNodes(new HashMap<String, Integer>(clientModel.getRegisteredNodes()));
        }
        if (!clientModel.getProtocolMappers().isEmpty()) {
            LinkedList<ProtocolMapperRepresentation> mappings = new LinkedList<ProtocolMapperRepresentation>();
            for (ProtocolMapperModel model : clientModel.getProtocolMappers()) {
                mappings.add(ModelToRepresentation.toRepresentation(model));
            }
            rep.setProtocolMappers(mappings);
        }
        return rep;
    }

    public static UserFederationProviderRepresentation toRepresentation(UserFederationProviderModel model) {
        UserFederationProviderRepresentation rep = new UserFederationProviderRepresentation();
        rep.setId(model.getId());
        rep.setConfig(model.getConfig());
        rep.setProviderName(model.getProviderName());
        rep.setPriority(model.getPriority());
        rep.setDisplayName(model.getDisplayName());
        rep.setFullSyncPeriod(model.getFullSyncPeriod());
        rep.setChangedSyncPeriod(model.getChangedSyncPeriod());
        rep.setLastSync(model.getLastSync());
        return rep;
    }

    public static UserFederationMapperRepresentation toRepresentation(RealmModel realm, UserFederationMapperModel model) {
        UserFederationMapperRepresentation rep = new UserFederationMapperRepresentation();
        rep.setId(model.getId());
        rep.setName(model.getName());
        rep.setFederationMapperType(model.getFederationMapperType());
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(model.getConfig());
        rep.setConfig(config);
        UserFederationProviderModel fedProvider = KeycloakModelUtils.findUserFederationProviderById(model.getFederationProviderId(), realm);
        if (fedProvider == null) {
            throw new ModelException("Couldn't find federation provider with ID " + model.getId());
        }
        rep.setFederationProviderDisplayName(fedProvider.getDisplayName());
        return rep;
    }

    public static IdentityProviderRepresentation toRepresentation(IdentityProviderModel identityProviderModel) {
        IdentityProviderRepresentation providerRep = new IdentityProviderRepresentation();
        providerRep.setInternalId(identityProviderModel.getInternalId());
        providerRep.setProviderId(identityProviderModel.getProviderId());
        providerRep.setAlias(identityProviderModel.getAlias());
        providerRep.setEnabled(identityProviderModel.isEnabled());
        providerRep.setStoreToken(identityProviderModel.isStoreToken());
        providerRep.setUpdateProfileFirstLoginMode(identityProviderModel.getUpdateProfileFirstLoginMode());
        providerRep.setTrustEmail(identityProviderModel.isTrustEmail());
        providerRep.setAuthenticateByDefault(identityProviderModel.isAuthenticateByDefault());
        providerRep.setConfig(identityProviderModel.getConfig());
        providerRep.setAddReadTokenRoleOnCreate(identityProviderModel.isAddReadTokenRoleOnCreate());
        return providerRep;
    }

    public static ProtocolMapperRepresentation toRepresentation(ProtocolMapperModel model) {
        ProtocolMapperRepresentation rep = new ProtocolMapperRepresentation();
        rep.setId(model.getId());
        rep.setProtocol(model.getProtocol());
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(model.getConfig());
        rep.setConfig(config);
        rep.setName(model.getName());
        rep.setProtocolMapper(model.getProtocolMapper());
        rep.setConsentText(model.getConsentText());
        rep.setConsentRequired(model.isConsentRequired());
        return rep;
    }

    public static IdentityProviderMapperRepresentation toRepresentation(IdentityProviderMapperModel model) {
        IdentityProviderMapperRepresentation rep = new IdentityProviderMapperRepresentation();
        rep.setId(model.getId());
        rep.setIdentityProviderMapper(model.getIdentityProviderMapper());
        rep.setIdentityProviderAlias(model.getIdentityProviderAlias());
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(model.getConfig());
        rep.setConfig(config);
        rep.setName(model.getName());
        return rep;
    }

    public static UserConsentRepresentation toRepresentation(UserConsentModel model) {
        String clientId = model.getClient().getClientId();
        HashMap<Object, LinkedList<String>> grantedProtocolMappers = new HashMap<Object, LinkedList<String>>();
        for (ProtocolMapperModel protocolMapper : model.getGrantedProtocolMappers()) {
            String protocol = protocolMapper.getProtocol();
            LinkedList<String> currentProtocolMappers = (LinkedList<String>)grantedProtocolMappers.get(protocol);
            if (currentProtocolMappers == null) {
                currentProtocolMappers = new LinkedList<String>();
                grantedProtocolMappers.put(protocol, currentProtocolMappers);
            }
            currentProtocolMappers.add(protocolMapper.getName());
        }
        LinkedList<String> grantedRealmRoles = new LinkedList<String>();
        HashMap<String, LinkedList<String>> grantedClientRoles = new HashMap<String, LinkedList<String>>();
        for (RoleModel role : model.getGrantedRoles()) {
            if (role.getContainer() instanceof RealmModel) {
                grantedRealmRoles.add(role.getName());
                continue;
            }
            ClientModel client2 = (ClientModel)role.getContainer();
            String clientId2 = client2.getClientId();
            LinkedList<String> currentClientRoles = (LinkedList<String>)grantedClientRoles.get(clientId2);
            if (currentClientRoles == null) {
                currentClientRoles = new LinkedList<String>();
                grantedClientRoles.put(clientId2, currentClientRoles);
            }
            currentClientRoles.add(role.getName());
        }
        UserConsentRepresentation consentRep = new UserConsentRepresentation();
        consentRep.setClientId(clientId);
        consentRep.setGrantedProtocolMappers(grantedProtocolMappers);
        consentRep.setGrantedRealmRoles(grantedRealmRoles);
        consentRep.setGrantedClientRoles(grantedClientRoles);
        return consentRep;
    }

    public static AuthenticationFlowRepresentation toRepresentation(RealmModel realm, AuthenticationFlowModel model) {
        AuthenticationFlowRepresentation rep = new AuthenticationFlowRepresentation();
        rep.setBuiltIn(model.isBuiltIn());
        rep.setTopLevel(model.isTopLevel());
        rep.setProviderId(model.getProviderId());
        rep.setAlias(model.getAlias());
        rep.setDescription(model.getDescription());
        rep.setAuthenticationExecutions(new LinkedList());
        for (AuthenticationExecutionModel execution : realm.getAuthenticationExecutions(model.getId())) {
            rep.getAuthenticationExecutions().add(ModelToRepresentation.toRepresentation(realm, execution));
        }
        return rep;
    }

    public static AuthenticationExecutionRepresentation toRepresentation(RealmModel realm, AuthenticationExecutionModel model) {
        AuthenticationExecutionRepresentation rep = new AuthenticationExecutionRepresentation();
        if (model.getAuthenticatorConfig() != null) {
            AuthenticatorConfigModel config = realm.getAuthenticatorConfigById(model.getAuthenticatorConfig());
            rep.setAuthenticatorConfig(config.getAlias());
        }
        rep.setAuthenticator(model.getAuthenticator());
        rep.setAutheticatorFlow(model.isAuthenticatorFlow());
        if (model.getFlowId() != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(model.getFlowId());
            rep.setFlowAlias(flow.getAlias());
        }
        rep.setPriority(model.getPriority());
        rep.setRequirement(model.getRequirement().name());
        return rep;
    }

    public static AuthenticatorConfigRepresentation toRepresentation(AuthenticatorConfigModel model) {
        AuthenticatorConfigRepresentation rep = new AuthenticatorConfigRepresentation();
        rep.setAlias(model.getAlias());
        rep.setConfig(model.getConfig());
        return rep;
    }

    public static RequiredActionProviderRepresentation toRepresentation(RequiredActionProviderModel model) {
        RequiredActionProviderRepresentation rep = new RequiredActionProviderRepresentation();
        rep.setAlias(model.getAlias());
        rep.setDefaultAction(model.isDefaultAction());
        rep.setEnabled(model.isEnabled());
        rep.setConfig(model.getConfig());
        rep.setName(model.getName());
        rep.setProviderId(model.getProviderId());
        return rep;
    }
}

