/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NullType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.keycloak.models.map.annotations.GenerateHotRodEntityImplementation;
import org.keycloak.models.map.exceptions.CannotMigrateTypeException;
import org.keycloak.models.map.processor.AbstractGenerateEntityImplementationsProcessor;
import org.keycloak.models.map.processor.FieldAccessorType;
import org.keycloak.models.map.processor.GenerateEntityImplementationsProcessor;
import org.keycloak.models.map.processor.PrintWriterNoJavaLang;
import org.keycloak.models.map.processor.Util;

@SupportedAnnotationTypes(value={"org.keycloak.models.map.annotations.GenerateHotRodEntityImplementation"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class GenerateHotRodEntityImplementationsProcessor
extends AbstractGenerateEntityImplementationsProcessor {
    private static Collection<String> autogenerated = new TreeSet<String>();

    @Override
    protected AbstractGenerateEntityImplementationsProcessor.Generator[] getGenerators() {
        return new AbstractGenerateEntityImplementationsProcessor.Generator[]{new HotRodGettersAndSettersDelegateGenerator(), new HotRodEntityDescriptorGenerator()};
    }

    @Override
    protected void afterAnnotationProcessing() {
        if (!autogenerated.isEmpty()) {
            try {
                JavaFileObject file = this.processingEnv.getFiler().createSourceFile("org.keycloak.models.map.storage.hotRod.common.AutogeneratedHotRodDescriptors", new Element[0]);
                try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                    ((PrintWriter)pw).println("package org.keycloak.models.map.storage.hotRod.common;");
                    ((PrintWriter)pw).println("// DO NOT CHANGE THIS CLASS, IT IS GENERATED AUTOMATICALLY BY " + GenerateHotRodEntityImplementationsProcessor.class.getSimpleName());
                    this.generatedAnnotation(pw);
                    ((PrintWriter)pw).println("public final class AutogeneratedHotRodDescriptors {");
                    ((PrintWriter)pw).println("    public static final java.util.Map<Class<?>, HotRodEntityDescriptor<?,?>> ENTITY_DESCRIPTOR_MAP = new java.util.HashMap<>();");
                    ((PrintWriter)pw).println("    static {");
                    autogenerated.forEach(pw::println);
                    ((PrintWriter)pw).println("    }");
                    ((PrintWriter)pw).println("}");
                }
            }
            catch (IOException ex) {
                Logger.getLogger(GenerateEntityImplementationsProcessor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private class HotRodGettersAndSettersDelegateGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private static final String ENTITY_VARIABLE = "hotRodEntity";
        private String hotRodSimpleClassName;
        private TypeElement generalHotRodDelegate;
        private TypeElement abstractEntity;
        private TypeElement abstractHotRodEntity;
        private TypeElement enumWithStableId;
        private TypeElement hotRodUtils;

        private HotRodGettersAndSettersDelegateGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            GenerateHotRodEntityImplementation hotRodAnnotation = e.getAnnotation(GenerateHotRodEntityImplementation.class);
            String interfaceClass = hotRodAnnotation.implementInterface();
            if (interfaceClass == null || interfaceClass.isEmpty()) {
                return;
            }
            TypeElement parentClassElement = GenerateHotRodEntityImplementationsProcessor.this.elements.getTypeElement(hotRodAnnotation.inherits());
            if (parentClassElement == null) {
                return;
            }
            boolean parentClassHasGeneric = !Util.getGenericsDeclaration(parentClassElement.asType()).isEmpty();
            TypeElement parentInterfaceElement = GenerateHotRodEntityImplementationsProcessor.this.elements.getTypeElement(interfaceClass);
            if (parentInterfaceElement == null) {
                return;
            }
            Map<String, HashSet<ExecutableElement>> methodsPerAttribute = GenerateHotRodEntityImplementationsProcessor.this.methodsPerAttributeMapping(parentInterfaceElement);
            List<? extends Element> allMembers = GenerateHotRodEntityImplementationsProcessor.this.elements.getAllMembers(parentClassElement);
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String hotRodImplClassName = className + "Delegate";
            this.hotRodSimpleClassName = simpleClassName + "Delegate";
            this.generalHotRodDelegate = GenerateHotRodEntityImplementationsProcessor.this.elements.getTypeElement("org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate");
            this.abstractEntity = GenerateHotRodEntityImplementationsProcessor.this.elements.getTypeElement("org.keycloak.models.map.common.AbstractEntity");
            this.abstractHotRodEntity = GenerateHotRodEntityImplementationsProcessor.this.elements.getTypeElement("org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity");
            this.enumWithStableId = GenerateHotRodEntityImplementationsProcessor.this.elements.getTypeElement("org.keycloak.util.EnumWithStableIndex");
            this.hotRodUtils = GenerateHotRodEntityImplementationsProcessor.this.elements.getTypeElement("org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils");
            boolean hasDeepClone = allMembers.stream().filter(el -> el.getKind() == ElementKind.METHOD && !el.getModifiers().contains((Object)Modifier.ABSTRACT)).anyMatch(el -> "deepClone".equals(el.getSimpleName().toString()));
            boolean needsDeepClone = GenerateHotRodEntityImplementationsProcessor.this.fieldGetters(methodsPerAttribute).map(ExecutableElement::getReturnType).anyMatch(fieldType -> !GenerateHotRodEntityImplementationsProcessor.this.isKnownCollectionOfImmutableFinalTypes((TypeMirror)fieldType) && !GenerateHotRodEntityImplementationsProcessor.this.isImmutableFinalType((TypeMirror)fieldType));
            boolean usingGeneratedCloner = !hasDeepClone && needsDeepClone;
            boolean hasId = methodsPerAttribute.containsKey("Id") || allMembers.stream().anyMatch(el -> "getId".equals(el.getSimpleName().toString()));
            boolean hasFieldId = GenerateHotRodEntityImplementationsProcessor.this.elements.getAllMembers(e).stream().filter(VariableElement.class::isInstance).map(VariableElement.class::cast).anyMatch(variableElement -> variableElement.getSimpleName().toString().equals("id"));
            JavaFileObject file = GenerateHotRodEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(hotRodImplClassName, new Element[0]);
            try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                if (packageName != null) {
                    ((PrintWriter)pw).println("package " + packageName + ";");
                }
                ((PrintWriter)pw).println("import java.util.Objects;");
                ((PrintWriter)pw).println("import org.keycloak.models.map.common.DeepCloner;");
                ((PrintWriter)pw).println("import java.util.Optional;");
                ((PrintWriter)pw).println("import java.util.stream.Collectors;");
                pw.println();
                ((PrintWriter)pw).println("// DO NOT CHANGE THIS CLASS, IT IS GENERATED AUTOMATICALLY BY " + GenerateHotRodEntityImplementationsProcessor.class.getSimpleName());
                GenerateHotRodEntityImplementationsProcessor.this.generatedAnnotation(pw);
                ((PrintWriter)pw).println("public class " + this.hotRodSimpleClassName + " extends " + parentClassElement.getQualifiedName().toString() + (String)(parentClassHasGeneric ? "<" + e.getQualifiedName().toString() + ">" : "") + " implements " + parentInterfaceElement.getQualifiedName().toString() + " {");
                pw.println();
                ((PrintWriter)pw).println("    private final " + className + " hotRodEntity;");
                pw.println();
                allMembers.stream().filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(ee -> ee.getKind() == ElementKind.CONSTRUCTOR).forEach(ee -> {
                    if (usingGeneratedCloner) {
                        pw.println("    /**");
                        pw.println("     * @deprecated This constructor uses a {@link DeepCloner#DUMB_CLONER} that does not clone anything. Use {@link #" + this.hotRodSimpleClassName + "(DeepCloner)} variant instead");
                        pw.println("     */");
                    }
                    pw.println("    " + ee.getModifiers().stream().map(Object::toString).collect(Collectors.joining(" ")) + " " + this.hotRodSimpleClassName + "(" + Util.methodParameters(ee.getParameters()) + ") {");
                    pw.println("        super(" + ee.getParameters() + ");");
                    if (usingGeneratedCloner) {
                        pw.println("        this.cloner = DeepCloner.DUMB_CLONER;");
                    }
                    pw.println("        this.hotRodEntity = new " + className + "();");
                    pw.println("    }");
                });
                if (usingGeneratedCloner) {
                    ((PrintWriter)pw).println("    /**");
                    ((PrintWriter)pw).println("     * @deprecated This constructor uses a {@link DeepCloner#DUMB_CLONER} that does not clone anything. Use {@link #" + this.hotRodSimpleClassName + "(DeepCloner)} variant instead");
                    ((PrintWriter)pw).println("     */");
                }
                ((PrintWriter)pw).println("    public " + this.hotRodSimpleClassName + "(" + className + " hotRodEntity) {");
                ((PrintWriter)pw).println("        java.util.Objects.requireNonNull(hotRodEntity);");
                ((PrintWriter)pw).println("        this.hotRodEntity = hotRodEntity;");
                if (usingGeneratedCloner) {
                    ((PrintWriter)pw).println("        this.cloner = DeepCloner.DUMB_CLONER;");
                }
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    public " + this.hotRodSimpleClassName + "(DeepCloner cloner) {");
                ((PrintWriter)pw).println("        super();");
                ((PrintWriter)pw).println("        this.hotRodEntity = new " + className + "();");
                if (usingGeneratedCloner) {
                    ((PrintWriter)pw).println("        this.cloner = cloner;");
                }
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    @Override public boolean equals(Object o) {");
                ((PrintWriter)pw).println("        if (o == this) return true; ");
                ((PrintWriter)pw).println("        if (! (o instanceof " + this.hotRodSimpleClassName + ")) return false; ");
                ((PrintWriter)pw).println("        " + this.hotRodSimpleClassName + " other = (" + this.hotRodSimpleClassName + ") o; ");
                ((PrintWriter)pw).println("        return " + GenerateHotRodEntityImplementationsProcessor.this.fieldGetters(methodsPerAttribute).map(ExecutableElement::getSimpleName).map(Object::toString).sorted(AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.GET_ID_INSTANCE).map(v -> "Objects.equals(" + v + "(), other." + v + "())").collect(Collectors.joining("\n          && ")) + ";");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    @Override public int hashCode() {");
                ((PrintWriter)pw).println("        return " + (String)(hasId ? "(getId() == null ? super.hashCode() : getId().hashCode())" : "Objects.hash(" + GenerateHotRodEntityImplementationsProcessor.this.fieldGetters(methodsPerAttribute).filter(ee -> GenerateHotRodEntityImplementationsProcessor.this.isImmutableFinalType(ee.getReturnType())).map(ExecutableElement::getSimpleName).map(Object::toString).sorted(AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.GET_ID_INSTANCE).map(v -> v + "()").collect(Collectors.joining(",\n          ")) + ")") + ";");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    @Override public String toString() {");
                ((PrintWriter)pw).println("        return String.format(\"%s@%08x\", " + (String)(hasId ? "getId()" : "\"" + this.hotRodSimpleClassName + "\"") + ", System.identityHashCode(this));");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    public static boolean entityEquals(Object o1, Object o2) {");
                ((PrintWriter)pw).println("        if (!(o1 instanceof " + className + ")) return false;");
                ((PrintWriter)pw).println("        if (!(o2 instanceof " + className + ")) return false;");
                ((PrintWriter)pw).println("        if (o1 == o2) return true;");
                ((PrintWriter)pw).println("        " + className + " e1 = (" + className + ") o1;");
                ((PrintWriter)pw).println("        " + className + " e2 = (" + className + ") o2;");
                pw.print("        return ");
                ((PrintWriter)pw).println(GenerateHotRodEntityImplementationsProcessor.this.elements.getAllMembers(e).stream().filter(Util::isNotIgnored).filter(VariableElement.class::isInstance).map(VariableElement.class::cast).map(var -> "Objects.equals(e1." + var.getSimpleName().toString() + ", e2." + var.getSimpleName().toString() + ")").collect(Collectors.joining("\n            && ")));
                ((PrintWriter)pw).println("            ;");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    public static int entityHashCode(" + className + " e) {");
                ((PrintWriter)pw).println("        return " + (String)(hasFieldId ? "(e.id == null ? Objects.hash(e) : e.id.hashCode())" : "Objects.hash(" + GenerateHotRodEntityImplementationsProcessor.this.elements.getAllMembers(e).stream().filter(VariableElement.class::isInstance).map(VariableElement.class::cast).map(var -> "e." + var.getSimpleName().toString()).collect(Collectors.joining(",\n          ")) + ")") + ";");
                ((PrintWriter)pw).println("    }");
                if (!hasDeepClone && needsDeepClone) {
                    ((PrintWriter)pw).println("    private final DeepCloner cloner;");
                    ((PrintWriter)pw).println("    public <V> V deepClone(V obj) {");
                    ((PrintWriter)pw).println("        return cloner.from(obj);");
                    ((PrintWriter)pw).println("    }");
                }
                methodsPerAttribute.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey, AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.ID_INSTANCE)).forEach(me -> {
                    HashSet methods = (HashSet)me.getValue();
                    TypeMirror fieldType = GenerateHotRodEntityImplementationsProcessor.this.determineFieldType((String)me.getKey(), methods);
                    if (fieldType == null) {
                        return;
                    }
                    char[] c = ((String)me.getKey()).toCharArray();
                    c[0] = Character.toLowerCase(c[0]);
                    String hotRodEntityFieldName = new String(c);
                    Optional<VariableElement> hotRodVariable = GenerateHotRodEntityImplementationsProcessor.this.elements.getAllMembers(e).stream().filter(VariableElement.class::isInstance).map(VariableElement.class::cast).filter(variableElement -> variableElement.getSimpleName().toString().equals(hotRodEntityFieldName)).findFirst();
                    for (ExecutableElement method : methods) {
                        FieldAccessorType fat = FieldAccessorType.determineType(method, (String)me.getKey(), GenerateHotRodEntityImplementationsProcessor.this.types, fieldType);
                        Optional<ExecutableElement> parentMethod = allMembers.stream().filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(ee -> Objects.equals(ee.toString(), method.toString())).filter(ee -> !ee.getModifiers().contains((Object)Modifier.ABSTRACT)).findAny();
                        try {
                            if (parentMethod.isPresent()) {
                                GenerateHotRodEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, "Method " + method + " is declared in a parent class.", method);
                                continue;
                            }
                            if (fat == FieldAccessorType.UNKNOWN || this.printMethodBody(pw, fat, method, hotRodEntityFieldName, fieldType, hotRodVariable.get().asType())) continue;
                            GenerateHotRodEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not determine desired semantics of method from its signature", method);
                        }
                        catch (CannotMigrateTypeException ex) {
                            GenerateHotRodEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getFormattedMessage(), method);
                        }
                    }
                });
                ((PrintWriter)pw).println("    public " + className + " getHotRodEntity() {");
                ((PrintWriter)pw).println("        return this.hotRodEntity;");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("}");
            }
        }

        private String hotRodEntityField(String fieldName) {
            return "this.hotRodEntity." + fieldName;
        }

        private String getFieldNameForCollectionKey(TypeMirror fieldType, ExecutableElement callingMethod) {
            ExecutableElement collectionKey = GenerateHotRodEntityImplementationsProcessor.this.getCollectionKey(fieldType, callingMethod);
            char[] c = GenerateHotRodEntityImplementationsProcessor.this.determineAttributeFromMethodName(collectionKey).toCharArray();
            c[0] = Character.toLowerCase(c[0]);
            return new String(c);
        }

        private boolean printMethodBody(PrintWriter pw, FieldAccessorType accessorType, ExecutableElement method, String fieldName, TypeMirror fieldType, TypeMirror hotRodFieldType) {
            NullType firstParameterType = method.getParameters().isEmpty() ? GenerateHotRodEntityImplementationsProcessor.this.types.getNullType() : method.getParameters().get(0).asType();
            TypeElement typeElement = GenerateHotRodEntityImplementationsProcessor.this.elements.getTypeElement(GenerateHotRodEntityImplementationsProcessor.this.types.erasure(fieldType).toString());
            switch (accessorType) {
                case GETTER: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method + " {");
                    pw.println("        return " + this.hotRodEntityField(fieldName) + " == null ? null : " + this.migrateToType(method.getReturnType(), hotRodFieldType, this.hotRodEntityField(fieldName)) + ";");
                    pw.println("    }");
                    return true;
                }
                case SETTER: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    if (!GenerateHotRodEntityImplementationsProcessor.this.isImmutableFinalType(firstParameterType)) {
                        pw.println("        p0 = " + GenerateHotRodEntityImplementationsProcessor.this.deepClone(firstParameterType, "p0") + ";");
                    }
                    if (GenerateHotRodEntityImplementationsProcessor.this.isCollection(firstParameterType)) {
                        pw.println("        if (p0 != null) {");
                        pw.println("            " + GenerateHotRodEntityImplementationsProcessor.this.removeUndefined(firstParameterType, "p0") + ";");
                        pw.println("            if (" + GenerateHotRodEntityImplementationsProcessor.this.isUndefined("p0") + ") p0 = null;");
                        pw.println("        }");
                    }
                    pw.println("        " + hotRodFieldType.toString() + " migrated = p0 == null ? null : " + this.migrateToType(hotRodFieldType, firstParameterType, "p0") + ";");
                    pw.println("        " + this.hotRodEntityField("updated") + " |= ! Objects.equals(" + this.hotRodEntityField(fieldName) + ", migrated);");
                    pw.println("        " + this.hotRodEntityField(fieldName) + " = migrated;");
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_ADD: {
                    TypeMirror collectionItemType = Util.getGenericsDeclaration(hotRodFieldType).get(0);
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    if (!GenerateHotRodEntityImplementationsProcessor.this.isImmutableFinalType(firstParameterType)) {
                        pw.println("        p0 = " + GenerateHotRodEntityImplementationsProcessor.this.deepClone(firstParameterType, "p0") + ";");
                    }
                    if (GenerateHotRodEntityImplementationsProcessor.this.isCollection(firstParameterType)) {
                        pw.println("        if (p0 != null) " + GenerateHotRodEntityImplementationsProcessor.this.removeUndefined(firstParameterType, "p0") + ";");
                    }
                    pw.println("        if (" + GenerateHotRodEntityImplementationsProcessor.this.isUndefined("p0") + ") return;");
                    pw.println("        if (" + this.hotRodEntityField(fieldName) + " == null) { " + this.hotRodEntityField(fieldName) + " = " + GenerateHotRodEntityImplementationsProcessor.this.interfaceToImplementation(typeElement, "") + "; }");
                    pw.println("        " + collectionItemType.toString() + " migrated = " + this.migrateToType(collectionItemType, firstParameterType, "p0") + ";");
                    if (Util.isSetType(typeElement)) {
                        pw.println("        " + this.hotRodEntityField("updated") + " |= " + this.hotRodEntityField(fieldName) + ".add(migrated);");
                    } else {
                        pw.println("        " + this.hotRodEntityField(fieldName) + ".add(migrated);");
                        pw.println("        " + this.hotRodEntityField("updated") + " = true;");
                    }
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_DELETE: {
                    TypeMirror collectionItemType = Util.getGenericsDeclaration(hotRodFieldType).get(0);
                    boolean needsReturn = method.getReturnType().getKind() != TypeKind.VOID;
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    if (Util.isMapType(typeElement)) {
                        pw.println("        boolean removed = " + this.hotRodUtils.getQualifiedName().toString() + ".removeFromSetByMapKey(" + this.hotRodEntityField(fieldName) + ", p0, " + this.keyGetterReference(collectionItemType) + ");");
                        pw.println("        " + this.hotRodEntityField("updated") + " |= removed;");
                    } else {
                        pw.println("        if (" + this.hotRodEntityField(fieldName) + " == null) { return" + (needsReturn ? " false" : "") + "; }");
                        pw.println("        boolean removed = " + this.hotRodEntityField(fieldName) + ".remove(p0);");
                        pw.println("        " + this.hotRodEntityField("updated") + " |= removed;");
                    }
                    if (needsReturn) {
                        pw.println("        return removed;");
                    }
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_DELETE_BY_ID: {
                    boolean needsReturn = method.getReturnType().getKind() != TypeKind.VOID;
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(String p0) {");
                    pw.println("        boolean removed = " + this.hotRodEntityField(fieldName) + " != null && " + this.hotRodEntityField(fieldName) + ".removeIf(o -> Objects.equals(o." + this.getFieldNameForCollectionKey(fieldType, method) + ", p0));");
                    pw.println("        " + this.hotRodEntityField("updated") + " |= removed;");
                    if (needsReturn) {
                        pw.println("        return removed;");
                    }
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_GET_BY_ID: {
                    TypeMirror collectionItemType = Util.getGenericsDeclaration(hotRodFieldType).get(0);
                    TypeMirror returnTypeGeneric = Util.getGenericsDeclaration(method.getReturnType()).get(0);
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(String p0) {");
                    pw.println("        if (" + this.hotRodEntityField(fieldName) + " == null || " + this.hotRodEntityField(fieldName) + ".isEmpty()) return Optional.empty();");
                    pw.println("        return " + this.hotRodEntityField(fieldName) + ".stream().filter(o -> Objects.equals(o." + this.getFieldNameForCollectionKey(fieldType, method) + ", p0)).findFirst().map(e -> " + this.migrateToType(returnTypeGeneric, collectionItemType, "e") + ");");
                    pw.println("    }");
                    return true;
                }
                case MAP_ADD: {
                    TypeMirror collectionItemType = Util.getGenericsDeclaration(hotRodFieldType).get(0);
                    TypeMirror secondParameterType = method.getParameters().get(1).asType();
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0, " + secondParameterType + " p1) {");
                    if (!GenerateHotRodEntityImplementationsProcessor.this.isImmutableFinalType(secondParameterType)) {
                        pw.println("        p1 = " + GenerateHotRodEntityImplementationsProcessor.this.deepClone(secondParameterType, "p1") + ";");
                    }
                    if (GenerateHotRodEntityImplementationsProcessor.this.isCollection(secondParameterType)) {
                        pw.println("        if (p1 != null) " + GenerateHotRodEntityImplementationsProcessor.this.removeUndefined(secondParameterType, "p1") + ";");
                    }
                    pw.println("        boolean valueUndefined = " + GenerateHotRodEntityImplementationsProcessor.this.isUndefined("p1") + ";");
                    pw.println("        if (" + this.hotRodEntityField(fieldName) + " == null && !valueUndefined) { " + this.hotRodEntityField(fieldName) + " = " + GenerateHotRodEntityImplementationsProcessor.this.interfaceToImplementation((TypeElement)GenerateHotRodEntityImplementationsProcessor.this.types.asElement(GenerateHotRodEntityImplementationsProcessor.this.types.erasure(hotRodFieldType)), "") + "; }");
                    pw.println("        " + this.hotRodEntityField("updated") + " |= " + this.hotRodUtils.getQualifiedName().toString() + ".removeFromSetByMapKey(" + this.hotRodEntityField(fieldName) + ", p0, " + this.keyGetterReference(collectionItemType) + ");");
                    pw.println("        " + this.hotRodEntityField("updated") + " |= !valueUndefined && " + this.hotRodEntityField(fieldName) + ".add(" + this.migrateToType(collectionItemType, new TypeMirror[]{firstParameterType, secondParameterType}, new String[]{"p0", "p1"}) + ");");
                    pw.println("    }");
                    return true;
                }
                case MAP_GET: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    TypeMirror collectionItemType = Util.getGenericsDeclaration(hotRodFieldType).get(0);
                    pw.println("        return " + this.hotRodUtils.getQualifiedName().toString() + ".getMapValueFromSet(" + this.hotRodEntityField(fieldName) + ", p0, " + this.keyGetterReference(collectionItemType) + ", " + this.valueGetterReference(collectionItemType) + ");");
                    pw.println("    }");
                    return true;
                }
            }
            return false;
        }

        private String migrateToType(TypeMirror toType, TypeMirror fromType, String fieldName) {
            return this.migrateToType(toType, new TypeMirror[]{fromType}, new String[]{fieldName});
        }

        private String toSimpleName(TypeMirror typeMirror) {
            TypeElement e = GenerateHotRodEntityImplementationsProcessor.this.elements.getTypeElement(GenerateHotRodEntityImplementationsProcessor.this.types.erasure(typeMirror).toString());
            return e.getSimpleName().toString();
        }

        private boolean hasField(TypeElement type, String fieldName) {
            Optional<VariableElement> hotRodVariable = GenerateHotRodEntityImplementationsProcessor.this.elements.getAllMembers(type).stream().filter(VariableElement.class::isInstance).map(VariableElement.class::cast).filter(variableElement -> variableElement.getSimpleName().toString().equals(fieldName)).findFirst();
            return hotRodVariable.isPresent();
        }

        private String keyGetterReference(TypeMirror type) {
            TypeElement typeElement = GenerateHotRodEntityImplementationsProcessor.this.elements.getTypeElement(GenerateHotRodEntityImplementationsProcessor.this.types.erasure(type).toString());
            if (this.hasField(typeElement, "id")) {
                return "e -> e.id";
            }
            return this.hotRodUtils.getQualifiedName().toString() + "::getKey";
        }

        private String valueGetterReference(TypeMirror type) {
            if (GenerateHotRodEntityImplementationsProcessor.this.types.isAssignable(type, this.abstractHotRodEntity.asType())) {
                return this.toSimpleName(type) + "Delegate::new";
            }
            return this.hotRodUtils.getQualifiedName().toString() + "::getValue";
        }

        private boolean isAssignable(TypeMirror fromType, TypeMirror toType) {
            return GenerateHotRodEntityImplementationsProcessor.this.types.isAssignable(GenerateHotRodEntityImplementationsProcessor.this.types.erasure(fromType), GenerateHotRodEntityImplementationsProcessor.this.types.erasure(toType));
        }

        private String migrateToType(TypeMirror toType, TypeMirror[] fromType, String[] fieldNames) {
            if (fromType.length == 1 && this.isAssignable(fromType[0], toType) && !GenerateHotRodEntityImplementationsProcessor.this.isCollection(fromType[0])) {
                return fieldNames[0];
            }
            if (fromType.length == 1) {
                if (this.isAssignable(fromType[0], toType)) {
                    TypeMirror toGeneric;
                    TypeMirror fromGeneric = Util.getGenericsDeclaration(fromType[0]).get(0);
                    if (this.isAssignable(fromGeneric, toGeneric = Util.getGenericsDeclaration(toType).get(0))) {
                        return fieldNames[0];
                    }
                    return this.hotRodUtils.getQualifiedName().toString() + ".migrate" + this.toSimpleName(fromType[0]) + "(" + fieldNames[0] + ", collectionItem -> " + this.migrateToType(toGeneric, fromGeneric, "collectionItem") + ")";
                }
                if (Util.isSetType((TypeElement)GenerateHotRodEntityImplementationsProcessor.this.types.asElement(GenerateHotRodEntityImplementationsProcessor.this.types.erasure(toType))) && Util.isMapType((TypeElement)GenerateHotRodEntityImplementationsProcessor.this.types.asElement(GenerateHotRodEntityImplementationsProcessor.this.types.erasure(fromType[0])))) {
                    TypeMirror setType = Util.getGenericsDeclaration(toType).get(0);
                    return this.hotRodUtils.getQualifiedName().toString() + ".migrateMapToSet(" + fieldNames[0] + ", " + this.hotRodUtils.getQualifiedName().toString() + "::create" + this.toSimpleName(setType) + "FromMapEntry)";
                }
                if (Util.isMapType((TypeElement)GenerateHotRodEntityImplementationsProcessor.this.types.asElement(GenerateHotRodEntityImplementationsProcessor.this.types.erasure(toType))) && Util.isSetType((TypeElement)GenerateHotRodEntityImplementationsProcessor.this.types.asElement(GenerateHotRodEntityImplementationsProcessor.this.types.erasure(fromType[0])))) {
                    TypeMirror setType = Util.getGenericsDeclaration(fromType[0]).get(0);
                    return this.hotRodUtils.getQualifiedName().toString() + ".migrateSetToMap(" + fieldNames[0] + ", " + this.keyGetterReference(setType) + ", " + this.valueGetterReference(setType) + ")";
                }
            }
            if (this.isAssignable(fromType[0], this.enumWithStableId.asType())) {
                return fieldNames[0] + ".getStableIndex()";
            }
            if (this.isAssignable(toType, this.enumWithStableId.asType())) {
                return toType.toString() + ".valueOfInteger(" + fieldNames[0] + ")";
            }
            if (this.findSuitableConstructor(toType, fromType).isPresent()) {
                return "new " + toType.toString() + "(" + String.join((CharSequence)", ", fieldNames) + ")";
            }
            if (this.isAssignable(toType, this.abstractHotRodEntity.asType())) {
                OptionalInt anotherMapEntityIndex = IntStream.range(0, fromType.length).filter(i -> this.isAssignable(fromType[i], this.abstractEntity.asType())).findFirst();
                return "((" + this.generalHotRodDelegate.getQualifiedName().toString() + "<" + toType.toString() + ">) " + fieldNames[anotherMapEntityIndex.orElse(0)] + ").getHotRodEntity()";
            }
            OptionalInt anotherHotRodEntityIndex = IntStream.range(0, fromType.length).filter(i -> this.isAssignable(fromType[i], this.abstractHotRodEntity.asType())).findFirst();
            if (anotherHotRodEntityIndex.isPresent()) {
                return "new " + fromType[anotherHotRodEntityIndex.getAsInt()] + "Delegate(" + String.join((CharSequence)", ", fieldNames) + ")";
            }
            return this.hotRodUtils.getQualifiedName().toString() + ".migrate" + Arrays.stream(fromType).map(this::toSimpleName).collect(Collectors.joining("")) + "To" + this.toSimpleName(toType) + "(" + String.join((CharSequence)", ", fieldNames) + ")";
        }

        private Optional<ExecutableElement> findSuitableConstructor(TypeMirror desiredType, TypeMirror[] parameters) {
            TypeElement type = (TypeElement)GenerateHotRodEntityImplementationsProcessor.this.types.asElement(desiredType);
            return GenerateHotRodEntityImplementationsProcessor.this.elements.getAllMembers(type).stream().filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(ee -> ee.getKind() == ElementKind.CONSTRUCTOR).filter(ee -> ee.getParameters().size() == parameters.length).filter(method -> IntStream.range(0, parameters.length).allMatch(i -> this.deepCompareTypes(parameters[i], method.getParameters().get(i).asType()))).findFirst();
        }

        private boolean deepCompareTypes(TypeMirror fromType, TypeMirror toType) {
            return GenerateHotRodEntityImplementationsProcessor.this.types.isAssignable(GenerateHotRodEntityImplementationsProcessor.this.types.erasure(fromType), GenerateHotRodEntityImplementationsProcessor.this.types.erasure(toType)) && this.deepCompareTypes(Util.getGenericsDeclaration(fromType), Util.getGenericsDeclaration(toType));
        }

        private boolean deepCompareTypes(List<TypeMirror> fromTypes, List<TypeMirror> toTypes) {
            if (fromTypes.size() == 0 && toTypes.size() == 0) {
                return true;
            }
            if (fromTypes.size() != toTypes.size()) {
                return false;
            }
            for (int i = 0; i < fromTypes.size(); ++i) {
                if (this.deepCompareTypes(fromTypes.get(i), toTypes.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    private class HotRodEntityDescriptorGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private HotRodEntityDescriptorGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            GenerateHotRodEntityImplementation hotRodAnnotation = e.getAnnotation(GenerateHotRodEntityImplementation.class);
            if (!hotRodAnnotation.topLevelEntity()) {
                return;
            }
            if (hotRodAnnotation.modelClass().isEmpty()) {
                Logger.getLogger(GenerateEntityImplementationsProcessor.class.getName()).log(Level.SEVERE, "HotRod top-level class needs to have model-class defined");
            }
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String descriptorClassName = className + "Descriptor";
            String descriptorSimpleClassName = simpleClassName + "Descriptor";
            JavaFileObject file = GenerateHotRodEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(descriptorClassName, new Element[0]);
            try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                if (packageName != null) {
                    ((PrintWriter)pw).println("package " + packageName + ";");
                }
                ((PrintWriter)pw).println("import org.infinispan.protostream.GeneratedSchema;");
                ((PrintWriter)pw).println("import java.util.function.Function;");
                GenerateHotRodEntityImplementationsProcessor.this.generatedAnnotation(pw);
                ((PrintWriter)pw).println("public class " + descriptorSimpleClassName + " implements org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor<" + className + ", " + className + "Delegate> {");
                ((PrintWriter)pw).println("    @Override\n    public Class<?> getModelTypeClass() {\n        return " + hotRodAnnotation.modelClass() + ".class;\n    }");
                ((PrintWriter)pw).println("    @Override\n    public Class<" + className + "> getEntityTypeClass() {\n        return " + className + ".class;\n    }");
                boolean isMethodCall = hotRodAnnotation.cacheName().contains("(");
                String quotes = isMethodCall ? "" : "\"";
                ((PrintWriter)pw).println("    @Override\n    public String getCacheName() {\n" + (hotRodAnnotation.cacheName().isEmpty() ? "        return org.keycloak.models.map.storage.ModelEntityUtil.getModelName(" + hotRodAnnotation.modelClass() + ".class);\n" : "        return " + quotes + hotRodAnnotation.cacheName() + quotes + ";\n") + "    }");
                ((PrintWriter)pw).println("    @Override\n    public Function<" + className + ", " + className + "Delegate> getHotRodDelegateProvider() {\n        return " + className + "Delegate::new;\n    }");
                ((PrintWriter)pw).println("    @Override\n    public Integer getCurrentVersion() {\n        return " + className + ".VERSION;\n    }");
                ((PrintWriter)pw).println("    @Override\n    public GeneratedSchema getProtoSchema() {\n        return " + className + "." + simpleClassName + "Schema.INSTANCE;\n    }");
                ((PrintWriter)pw).println("}");
            }
            autogenerated.add("        ENTITY_DESCRIPTOR_MAP.put(" + hotRodAnnotation.modelClass() + ".class, new " + descriptorClassName + "());");
        }
    }
}

