/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.infinispan;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.infinispan.PublicKeyStorageInvalidationEvent;
import org.keycloak.keys.infinispan.PublicKeysEntry;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.cache.infinispan.ClearCacheEvent;

public class InfinispanPublicKeyStorageProvider
implements PublicKeyStorageProvider {
    private static final Logger log = Logger.getLogger(InfinispanPublicKeyStorageProvider.class);
    private final KeycloakSession session;
    private final Cache<String, PublicKeysEntry> keys;
    private final Map<String, FutureTask<PublicKeysEntry>> tasksInProgress;
    private final int minTimeBetweenRequests;
    private Set<String> invalidations = new HashSet<String>();
    private boolean transactionEnlisted = false;

    public InfinispanPublicKeyStorageProvider(KeycloakSession session, Cache<String, PublicKeysEntry> keys, Map<String, FutureTask<PublicKeysEntry>> tasksInProgress, int minTimeBetweenRequests) {
        this.session = session;
        this.keys = keys;
        this.tasksInProgress = tasksInProgress;
        this.minTimeBetweenRequests = minTimeBetweenRequests;
    }

    public void clearCache() {
        this.keys.clear();
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        cluster.notify("KEYS_CLEAR_CACHE_EVENTS", (ClusterEvent)new ClearCacheEvent(), true, ClusterProvider.DCNotify.ALL_DCS);
    }

    void addInvalidation(String cacheKey) {
        if (!this.transactionEnlisted) {
            this.session.getTransactionManager().enlistAfterCompletion(this.getAfterTransaction());
            this.transactionEnlisted = true;
        }
        this.invalidations.add(cacheKey);
    }

    protected KeycloakTransaction getAfterTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
            }

            public void commit() {
                InfinispanPublicKeyStorageProvider.this.runInvalidations();
            }

            public void rollback() {
                InfinispanPublicKeyStorageProvider.this.runInvalidations();
            }

            public void setRollbackOnly() {
            }

            public boolean getRollbackOnly() {
                return false;
            }

            public boolean isActive() {
                return true;
            }
        };
    }

    protected void runInvalidations() {
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        for (String cacheKey : this.invalidations) {
            this.keys.remove((Object)cacheKey);
            cluster.notify("PUBLIC_KEY_STORAGE_INVALIDATION_EVENT", (ClusterEvent)PublicKeyStorageInvalidationEvent.create(cacheKey), true, ClusterProvider.DCNotify.ALL_DCS);
        }
    }

    public KeyWrapper getPublicKey(String modelKey, String kid, PublicKeyLoader loader) {
        return this.getPublicKey(modelKey, kid, null, loader);
    }

    public KeyWrapper getFirstPublicKey(String modelKey, String algorithm, PublicKeyLoader loader) {
        return this.getPublicKey(modelKey, null, algorithm, loader);
    }

    private KeyWrapper getPublicKey(String modelKey, String kid, String algorithm, PublicKeyLoader loader) {
        PublicKeysEntry entry;
        block13: {
            entry = (PublicKeysEntry)this.keys.get((Object)modelKey);
            if (entry != null) {
                KeyWrapper publicKey;
                KeyWrapper keyWrapper = publicKey = algorithm != null ? this.getPublicKeyByAlg(entry.getCurrentKeys(), algorithm) : this.getPublicKey(entry.getCurrentKeys(), kid);
                if (publicKey != null) {
                    return publicKey;
                }
            }
            int lastRequestTime = entry == null ? 0 : entry.getLastRequestTime();
            int currentTime = Time.currentTime();
            if (currentTime > lastRequestTime + this.minTimeBetweenRequests) {
                WrapperCallable wrapperCallable = new WrapperCallable(modelKey, loader);
                FutureTask<PublicKeysEntry> task = new FutureTask<PublicKeysEntry>(wrapperCallable);
                FutureTask<PublicKeysEntry> existing = this.tasksInProgress.putIfAbsent(modelKey, task);
                if (existing == null) {
                    task.run();
                } else {
                    task = existing;
                }
                try {
                    KeyWrapper publicKey;
                    entry = task.get();
                    KeyWrapper keyWrapper = publicKey = algorithm != null ? this.getPublicKeyByAlg(entry.getCurrentKeys(), algorithm) : this.getPublicKey(entry.getCurrentKeys(), kid);
                    if (publicKey != null) {
                        KeyWrapper keyWrapper2 = publicKey;
                        return keyWrapper2;
                    }
                    break block13;
                }
                catch (ExecutionException ee) {
                    throw new RuntimeException("Error when loading public keys: " + ee.getMessage(), ee);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("Error. Interrupted when loading public keys", ie);
                }
                finally {
                    if (existing == null) {
                        this.tasksInProgress.remove(modelKey);
                    }
                }
            }
            log.warnf("Won't load the keys for model '%s' . Last request time was %d", (Object)modelKey, (Object)lastRequestTime);
        }
        Set availableKids = entry == null ? Collections.emptySet() : entry.getCurrentKeys().keySet();
        log.warnf("PublicKey wasn't found in the storage. Requested kid: '%s' . Available kids: '%s'", (Object)kid, availableKids);
        return null;
    }

    private KeyWrapper getPublicKey(Map<String, KeyWrapper> publicKeys, String kid) {
        if (kid == null && !publicKeys.isEmpty()) {
            return publicKeys.values().iterator().next();
        }
        return publicKeys.get(kid);
    }

    private KeyWrapper getPublicKeyByAlg(Map<String, KeyWrapper> publicKeys, String algorithm) {
        if (algorithm == null) {
            return null;
        }
        for (KeyWrapper keyWrapper : publicKeys.values()) {
            if (!algorithm.equals(keyWrapper.getAlgorithm())) continue;
            return keyWrapper;
        }
        return null;
    }

    public void close() {
    }

    private class WrapperCallable
    implements Callable<PublicKeysEntry> {
        private final String modelKey;
        private final PublicKeyLoader delegate;

        public WrapperCallable(String modelKey, PublicKeyLoader delegate) {
            this.modelKey = modelKey;
            this.delegate = delegate;
        }

        @Override
        public PublicKeysEntry call() throws Exception {
            PublicKeysEntry entry = (PublicKeysEntry)InfinispanPublicKeyStorageProvider.this.keys.get((Object)this.modelKey);
            int lastRequestTime = entry == null ? 0 : entry.getLastRequestTime();
            int currentTime = Time.currentTime();
            if (currentTime > lastRequestTime + InfinispanPublicKeyStorageProvider.this.minTimeBetweenRequests) {
                Map publicKeys = this.delegate.loadKeys();
                if (log.isDebugEnabled()) {
                    log.debugf("Public keys retrieved successfully for model %s. New kids: %s", (Object)this.modelKey, (Object)publicKeys.keySet().toString());
                }
                entry = new PublicKeysEntry(currentTime, publicKeys);
                InfinispanPublicKeyStorageProvider.this.keys.put((Object)this.modelKey, (Object)entry);
            }
            return entry;
        }
    }
}

