/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.TokenRevocationStoreProvider;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanTokenRevocationStoreProvider
implements TokenRevocationStoreProvider {
    public static final Logger logger = Logger.getLogger(InfinispanTokenRevocationStoreProvider.class);
    private final Supplier<BasicCache<String, ActionTokenValueEntity>> tokenCache;
    private final KeycloakSession session;
    private final String REVOKED_KEY = "revoked";

    public InfinispanTokenRevocationStoreProvider(KeycloakSession session, Supplier<BasicCache<String, ActionTokenValueEntity>> tokenCache) {
        this.session = session;
        this.tokenCache = tokenCache;
    }

    public void putRevokedToken(String tokenId, long lifespanSeconds) {
        Map<String, String> data = Collections.singletonMap("revoked", "true");
        ActionTokenValueEntity tokenValue = new ActionTokenValueEntity(data);
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.tokenCache.get();
            cache.put((Object)tokenId, (Object)tokenValue, lifespanSeconds + 1L, TimeUnit.SECONDS);
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when adding revoked token %s", (Object)tokenId);
            }
            throw re;
        }
    }

    public boolean isRevoked(String tokenId) {
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.tokenCache.get();
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.get((Object)tokenId);
            if (existing == null) {
                return false;
            }
            return existing.getNotes().containsKey("revoked");
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when trying to get revoked token %s", (Object)tokenId);
            }
            return false;
        }
    }

    public void close() {
    }
}

