/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.remoting.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.sessions.infinispan.initializer.BaseCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.InitializerState;
import org.keycloak.models.sessions.infinispan.initializer.SessionInitializerWorker;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;
import org.keycloak.models.utils.KeycloakModelUtils;

public class InfinispanCacheInitializer
extends BaseCacheInitializer {
    private static final Logger log = Logger.getLogger(InfinispanCacheInitializer.class);
    private final int maxErrors;

    public InfinispanCacheInitializer(KeycloakSessionFactory sessionFactory, Cache<String, Serializable> workCache, SessionLoader sessionLoader, String stateKeySuffix, int sessionsPerSegment, int maxErrors) {
        super(sessionFactory, workCache, sessionLoader, stateKeySuffix, sessionsPerSegment);
        this.maxErrors = maxErrors;
    }

    @Override
    public void initCache() {
        block2: {
            ComponentRegistry cr = this.workCache.getAdvancedCache().getComponentRegistry();
            try {
                cr.registerComponent((Object)this.sessionFactory, KeycloakSessionFactory.class);
            }
            catch (UnsupportedOperationException | CacheConfigurationException ex) {
                if (cr.getComponent(KeycloakSessionFactory.class) == this.sessionFactory) break block2;
                throw ex;
            }
        }
    }

    @Override
    protected void startLoading() {
        InitializerState state = this.getStateFromCache();
        final SessionLoader.LoaderContext[] ctx = new SessionLoader.LoaderContext[1];
        if (state == null) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    InfinispanCacheInitializer.this.sessionLoader.init(session);
                }
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    ctx[0] = InfinispanCacheInitializer.this.sessionLoader.computeLoaderContext(session);
                }
            });
            state = new InitializerState(ctx[0].getSegmentsCount());
        } else {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    ctx[0] = InfinispanCacheInitializer.this.sessionLoader.computeLoaderContext(session);
                }
            });
        }
        log.debugf("Start loading with loader: '%s', ctx: '%s' , state: %s", (Object)this.sessionLoader.toString(), (Object)ctx[0].toString(), (Object)state.toString());
        this.startLoadingImpl(state, ctx[0]);
    }

    protected void startLoadingImpl(InitializerState state, SessionLoader.LoaderContext loaderCtx) {
        int processors = Runtime.getRuntime().availableProcessors();
        Transport transport = this.workCache.getCacheManager().getTransport();
        ClusterExecutor clusterExecutor = this.workCache.getCacheManager().executor().singleNodeSubmission(3);
        int errors = 0;
        int segmentToLoad = 0;
        SessionLoader.WorkerResult previousResult = null;
        SessionLoader.WorkerResult nextResult = null;
        int distributedWorkersCount = 0;
        boolean firstTryForSegment = true;
        while (segmentToLoad < state.getSegmentsCount()) {
            if (firstTryForSegment) {
                int nodesCount = transport == null ? 1 : transport.getMembers().size();
                distributedWorkersCount = processors * nodesCount;
            }
            log.debugf("Starting next iteration with %d workers", distributedWorkersCount);
            List<Integer> segments = state.getSegmentsToLoad(segmentToLoad, distributedWorkersCount);
            if (log.isTraceEnabled()) {
                log.trace((Object)("unfinished segments for this iteration: " + segments));
            }
            LinkedList<CompletableFuture> futures = new LinkedList<CompletableFuture>();
            ConcurrentLinkedQueue results = new ConcurrentLinkedQueue();
            CompletableFuture completableFuture = null;
            for (Integer segment : segments) {
                Object workerCtx = this.sessionLoader.computeWorkerContext(loaderCtx, segment, segment - segmentToLoad, previousResult);
                SessionInitializerWorker worker = new SessionInitializerWorker();
                worker.setWorkerEnvironment(loaderCtx, (SessionLoader.WorkerContext)workerCtx, this.sessionLoader, this.workCache.getName());
                completableFuture = clusterExecutor.submitConsumer((Function)worker, (address, workerResult, throwable) -> {
                    log.tracef("Calling triConsumer on address %s, throwable message: %s, segment: %s", address, (Object)(throwable == null ? "null" : throwable.getMessage()), (Object)workerResult.getSegment());
                    if (throwable != null) {
                        throw new CacheException(throwable);
                    }
                    results.add(workerResult);
                });
                futures.add(completableFuture);
            }
            boolean anyFailure = false;
            for (CompletableFuture future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException ie) {
                    anyFailure = true;
                    log.error((Object)("Interruped exception when computed future. Errors: " + ++errors), (Throwable)ie);
                }
                catch (ExecutionException ee) {
                    anyFailure = true;
                    log.error((Object)("ExecutionException when computed future. Errors: " + ++errors), (Throwable)ee);
                }
            }
            for (SessionLoader.WorkerResult result : results) {
                if (result.isSuccess()) {
                    state.markSegmentFinished(result.getSegment());
                    if (result.getSegment() != segmentToLoad + distributedWorkersCount - 1) continue;
                    nextResult = result;
                    continue;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Segment %d failed to compute", result.getSegment());
                }
                anyFailure = true;
            }
            if (errors >= this.maxErrors) {
                throw new RuntimeException("Maximum count of worker errors occured. Limit was " + this.maxErrors + ". See server.log for details");
            }
            if (!anyFailure) {
                segmentToLoad += distributedWorkersCount;
                firstTryForSegment = true;
                previousResult = nextResult;
                nextResult = null;
                if (!log.isTraceEnabled()) continue;
                log.debugf("New initializer state is: %s", (Object)state);
                continue;
            }
            firstTryForSegment = false;
        }
        this.saveStateToCache(state);
        this.sessionLoader.afterAllSessionsLoaded(this);
    }
}

