/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.entities.InRealm;
import org.keycloak.models.cache.infinispan.entities.Revisioned;

@SerializeWith(value=ExternalizerImpl.class)
public class InRealmPredicate
implements Predicate<Map.Entry<String, Revisioned>>,
Serializable {
    private String realm;

    public static InRealmPredicate create() {
        return new InRealmPredicate();
    }

    public InRealmPredicate realm(String id) {
        this.realm = id;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, Revisioned> entry) {
        Revisioned value = entry.getValue();
        if (value == null) {
            return false;
        }
        if (!(value instanceof InRealm)) {
            return false;
        }
        return this.realm.equals(((InRealm)value).getRealm());
    }

    public static class ExternalizerImpl
    implements Externalizer<InRealmPredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, InRealmPredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realm, (ObjectOutput)output);
        }

        public InRealmPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public InRealmPredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            InRealmPredicate res = new InRealmPredicate();
            res.realm = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

