/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.DefaultLazyLoader;
import org.keycloak.models.cache.infinispan.LazyLoader;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedGroup
extends AbstractRevisioned
implements InRealm {
    private final String realm;
    private final String name;
    private final String parentId;
    private final LazyLoader<GroupModel, MultivaluedHashMap<String, String>> attributes;
    private final LazyLoader<GroupModel, Set<String>> roleMappings;
    private final LazyLoader<GroupModel, Set<String>> subGroups;

    public CachedGroup(Long revision, RealmModel realm, GroupModel group) {
        super(revision, group.getId());
        this.realm = realm.getId();
        this.name = group.getName();
        this.parentId = group.getParentId();
        this.attributes = new DefaultLazyLoader<GroupModel, MultivaluedHashMap>(source -> new MultivaluedHashMap(source.getAttributes()), MultivaluedHashMap::new);
        this.roleMappings = new DefaultLazyLoader<GroupModel, Set>(source -> source.getRoleMappingsStream().map(RoleModel::getId).collect(Collectors.toSet()), Collections::emptySet);
        this.subGroups = new DefaultLazyLoader<GroupModel, Set>(source -> source.getSubGroupsStream().map(GroupModel::getId).collect(Collectors.toSet()), Collections::emptySet);
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public MultivaluedHashMap<String, String> getAttributes(Supplier<GroupModel> group) {
        return this.attributes.get(group);
    }

    public Set<String> getRoleMappings(Supplier<GroupModel> group) {
        if (group == null) {
            return Collections.emptySet();
        }
        return this.roleMappings.get(group);
    }

    public String getName() {
        return this.name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Set<String> getSubGroups(Supplier<GroupModel> group) {
        return this.subGroups.get(group);
    }
}

