/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.CodeToTokenStoreProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanCodeToTokenStoreProvider
implements CodeToTokenStoreProvider {
    public static final Logger logger = Logger.getLogger(InfinispanCodeToTokenStoreProvider.class);
    private final Supplier<BasicCache<UUID, ActionTokenValueEntity>> codeCache;
    private final KeycloakSession session;

    public InfinispanCodeToTokenStoreProvider(KeycloakSession session, Supplier<BasicCache<UUID, ActionTokenValueEntity>> actionKeyCache) {
        this.session = session;
        this.codeCache = actionKeyCache;
    }

    public void put(UUID codeId, int lifespanSeconds, Map<String, String> codeData) {
        ActionTokenValueEntity tokenValue = new ActionTokenValueEntity(codeData);
        try {
            BasicCache<UUID, ActionTokenValueEntity> cache = this.codeCache.get();
            long lifespanMs = InfinispanUtil.toHotrodTimeMs(cache, Time.toMillis((long)lifespanSeconds));
            cache.put((Object)codeId, (Object)tokenValue, lifespanMs, TimeUnit.MILLISECONDS);
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when adding code %s", (Object)codeId);
            }
            throw re;
        }
    }

    public Map<String, String> remove(UUID codeId) {
        try {
            BasicCache<UUID, ActionTokenValueEntity> cache = this.codeCache.get();
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.remove((Object)codeId);
            return existing == null ? null : existing.getNotes();
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when removing code %s", (Object)codeId);
            }
            return null;
        }
    }

    public void close() {
    }
}

