/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.UUID;
import java.util.function.Supplier;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.SamlArtifactSessionMappingStoreProvider;
import org.keycloak.models.SamlArtifactSessionMappingStoreProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanSamlArtifactSessionMappingStoreProvider;
import org.keycloak.models.sessions.infinispan.InfinispanSingleUseTokenStoreProviderFactory;

public class InfinispanSamlArtifactSessionMappingStoreProviderFactory
implements SamlArtifactSessionMappingStoreProviderFactory {
    private static final Logger LOG = Logger.getLogger(InfinispanSamlArtifactSessionMappingStoreProviderFactory.class);
    private volatile Supplier<BasicCache<UUID, String[]>> codeCache;

    public SamlArtifactSessionMappingStoreProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanSamlArtifactSessionMappingStoreProvider(this.codeCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.codeCache == null) {
            InfinispanSamlArtifactSessionMappingStoreProviderFactory infinispanSamlArtifactSessionMappingStoreProviderFactory = this;
            synchronized (infinispanSamlArtifactSessionMappingStoreProviderFactory) {
                if (this.codeCache == null) {
                    this.codeCache = InfinispanSingleUseTokenStoreProviderFactory.getActionTokenCache(session);
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }
}

