/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.util.Objects;
import java.util.Set;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

public class PermissionTicketRemovedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;
    private String owner;
    private String resource;
    private String scope;
    private String serverId;
    private String requester;
    private String resourceName;

    public static PermissionTicketRemovedEvent create(String id, String owner, String requester, String resource, String resourceName, String scope, String serverId) {
        PermissionTicketRemovedEvent event = new PermissionTicketRemovedEvent();
        event.id = id;
        event.owner = owner;
        event.requester = requester;
        event.resource = resource;
        event.resourceName = resourceName;
        event.scope = scope;
        event.serverId = serverId;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PermissionTicketRemovedEvent that = (PermissionTicketRemovedEvent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.resource, that.resource) && Objects.equals(this.serverId, that.serverId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id, this.resource, this.serverId);
    }

    public String toString() {
        return String.format("PermissionTicketRemovedEvent [ id=%s, name=%s]", this.id, this.resource);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.permissionTicketRemoval(this.id, this.owner, this.requester, this.resource, this.resourceName, this.scope, this.serverId, invalidations);
    }
}

