/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.infinispan;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.infinispan.PublicKeyStorageInvalidationEvent;
import org.keycloak.keys.infinispan.PublicKeysEntry;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;

public class InfinispanPublicKeyStorageProvider
implements PublicKeyStorageProvider {
    private static final Logger log = Logger.getLogger(InfinispanPublicKeyStorageProvider.class);
    private final KeycloakSession session;
    private final Cache<String, PublicKeysEntry> keys;
    private final Map<String, FutureTask<PublicKeysEntry>> tasksInProgress;
    private final int minTimeBetweenRequests;
    private final int maxCacheTime;
    private final Set<String> invalidations = new HashSet<String>();
    private boolean transactionEnlisted = false;

    public InfinispanPublicKeyStorageProvider(KeycloakSession session, Cache<String, PublicKeysEntry> keys, Map<String, FutureTask<PublicKeysEntry>> tasksInProgress, int minTimeBetweenRequests, int maxCacheTime) {
        this.session = session;
        this.keys = keys;
        this.tasksInProgress = tasksInProgress;
        this.minTimeBetweenRequests = minTimeBetweenRequests;
        this.maxCacheTime = maxCacheTime;
    }

    void addInvalidation(String cacheKey) {
        if (!this.transactionEnlisted) {
            this.session.getTransactionManager().enlistAfterCompletion(this.getAfterTransaction());
            this.transactionEnlisted = true;
        }
        this.invalidations.add(cacheKey);
    }

    protected KeycloakTransaction getAfterTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
            }

            public void commit() {
                InfinispanPublicKeyStorageProvider.this.runInvalidations();
            }

            public void rollback() {
                InfinispanPublicKeyStorageProvider.this.runInvalidations();
            }

            public void setRollbackOnly() {
            }

            public boolean getRollbackOnly() {
                return false;
            }

            public boolean isActive() {
                return true;
            }
        };
    }

    protected void runInvalidations() {
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        for (String cacheKey : this.invalidations) {
            this.keys.remove((Object)cacheKey);
            cluster.notify("PUBLIC_KEY_STORAGE_INVALIDATION_EVENT", (ClusterEvent)PublicKeyStorageInvalidationEvent.create(cacheKey), true, ClusterProvider.DCNotify.ALL_DCS);
        }
    }

    public KeyWrapper getFirstPublicKey(String modelKey, String algorithm, PublicKeyLoader loader) {
        return this.getPublicKey(modelKey, null, algorithm, loader);
    }

    public KeyWrapper getPublicKey(String modelKey, String kid, String algorithm, PublicKeyLoader loader) {
        KeyWrapper publicKey;
        KeyWrapper publicKey2;
        boolean isSendingRequestAllowed;
        PublicKeysEntry entry = (PublicKeysEntry)this.keys.get((Object)modelKey);
        int lastRequestTime = entry == null ? 0 : entry.getLastRequestTime();
        int currentTime = Time.currentTime();
        boolean bl = isSendingRequestAllowed = currentTime > lastRequestTime + this.minTimeBetweenRequests;
        if (!(entry == null || kid == null && isSendingRequestAllowed || (publicKey2 = entry.getCurrentKeys().getKeyByKidAndAlg(kid, algorithm)) == null)) {
            return publicKey2.cloneKey();
        }
        PublicKeysEntry updatedEntry = this.reloadKeys(modelKey, entry, currentTime, loader);
        entry = updatedEntry == null ? entry : updatedEntry;
        KeyWrapper keyWrapper = publicKey = entry == null ? null : entry.getCurrentKeys().getKeyByKidAndAlg(kid, algorithm);
        if (publicKey != null) {
            return publicKey.cloneKey();
        }
        List availableKids = entry == null ? Collections.emptyList() : entry.getCurrentKeys().getKids();
        log.warnf("PublicKey wasn't found in the storage. Requested kid: '%s' . Available kids: '%s'", (Object)kid, (Object)availableKids);
        return null;
    }

    public KeyWrapper getFirstPublicKey(String modelKey, Predicate<KeyWrapper> predicate, PublicKeyLoader loader) {
        KeyWrapper key;
        KeyWrapper key2;
        PublicKeysEntry entry = (PublicKeysEntry)this.keys.get((Object)modelKey);
        if (entry != null && (key2 = entry.getCurrentKeys().getKeyByPredicate(predicate)) != null) {
            return key2.cloneKey();
        }
        int currentTime = Time.currentTime();
        if ((entry = this.reloadKeys(modelKey, entry, currentTime, loader)) != null && (key = entry.getCurrentKeys().getKeyByPredicate(predicate)) != null) {
            return key.cloneKey();
        }
        return null;
    }

    public List<KeyWrapper> getKeys(String modelKey, PublicKeyLoader loader) {
        PublicKeysEntry updatedEntry;
        PublicKeysEntry entry = (PublicKeysEntry)this.keys.get((Object)modelKey);
        int currentTime = Time.currentTime();
        if ((entry == null || currentTime > entry.getLastRequestTime() + this.maxCacheTime) && (updatedEntry = this.reloadKeys(modelKey, entry, currentTime, loader)) != null) {
            entry = updatedEntry;
        }
        return entry == null ? Collections.emptyList() : entry.getCurrentKeys().getKeys().stream().map(KeyWrapper::cloneKey).collect(Collectors.toList());
    }

    public boolean reloadKeys(String modelKey, PublicKeyLoader loader) {
        int currentTime;
        PublicKeysEntry entry = (PublicKeysEntry)this.keys.get((Object)modelKey);
        return this.reloadKeys(modelKey, entry, currentTime = Time.currentTime(), loader) != null;
    }

    private PublicKeysEntry reloadKeys(String modelKey, PublicKeysEntry entry, int currentTime, PublicKeyLoader loader) {
        if (entry == null || currentTime > entry.getLastRequestTime() + this.minTimeBetweenRequests) {
            WrapperCallable wrapperCallable = new WrapperCallable(modelKey, loader);
            FutureTask<PublicKeysEntry> task = new FutureTask<PublicKeysEntry>(wrapperCallable);
            FutureTask<PublicKeysEntry> existing = this.tasksInProgress.putIfAbsent(modelKey, task);
            if (existing == null) {
                log.debugf("Reloading keys for model key '%s'.", (Object)modelKey);
                task.run();
            } else {
                task = existing;
            }
            try {
                PublicKeysEntry publicKeysEntry = task.get();
                return publicKeysEntry;
            }
            catch (ExecutionException ee) {
                throw new RuntimeException("Error when loading public keys: " + ee.getMessage(), ee);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Error. Interrupted when loading public keys", ie);
            }
            finally {
                if (existing == null) {
                    this.tasksInProgress.remove(modelKey);
                }
            }
        }
        log.warnf("Won't load the keys for model '%s'. Last request time was %d", (Object)modelKey, (Object)entry.getLastRequestTime());
        return null;
    }

    public void close() {
    }

    private class WrapperCallable
    implements Callable<PublicKeysEntry> {
        private final String modelKey;
        private final PublicKeyLoader delegate;

        public WrapperCallable(String modelKey, PublicKeyLoader delegate) {
            this.modelKey = modelKey;
            this.delegate = delegate;
        }

        @Override
        public PublicKeysEntry call() throws Exception {
            PublicKeysEntry entry = (PublicKeysEntry)InfinispanPublicKeyStorageProvider.this.keys.get((Object)this.modelKey);
            int lastRequestTime = entry == null ? 0 : entry.getLastRequestTime();
            int currentTime = Time.currentTime();
            if (currentTime > lastRequestTime + InfinispanPublicKeyStorageProvider.this.minTimeBetweenRequests) {
                PublicKeysWrapper publicKeys = this.delegate.loadKeys();
                if (log.isDebugEnabled()) {
                    log.debugf("Public keys retrieved successfully for model %s. New kids: %s", (Object)this.modelKey, (Object)publicKeys.getKids());
                }
                entry = new PublicKeysEntry(currentTime, publicKeys);
                InfinispanPublicKeyStorageProvider.this.keys.put((Object)this.modelKey, (Object)entry);
            }
            return entry;
        }
    }
}

