/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.sessions.infinispan.initializer.BaseCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.InitializerState;
import org.keycloak.models.sessions.infinispan.initializer.SessionInitializerWorker;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;
import org.keycloak.models.utils.KeycloakModelUtils;

public class InfinispanCacheInitializer
extends BaseCacheInitializer {
    private static final Logger log = Logger.getLogger(InfinispanCacheInitializer.class);
    private final int maxErrors;
    private final int stalledTimeoutInSeconds;

    public InfinispanCacheInitializer(KeycloakSessionFactory sessionFactory, Cache<String, Serializable> workCache, SessionLoader sessionLoader, String stateKeySuffix, int sessionsPerSegment, int maxErrors, int stalledTimeoutInSeconds) {
        super(sessionFactory, workCache, sessionLoader, stateKeySuffix, sessionsPerSegment);
        this.maxErrors = maxErrors;
        this.stalledTimeoutInSeconds = stalledTimeoutInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initCache() {
        Cache cache = this.workCache;
        synchronized (cache) {
            ComponentRegistry cr = this.workCache.getAdvancedCache().getComponentRegistry();
            if (cr.getComponent(KeycloakSessionFactory.class) != this.sessionFactory) {
                cr.registerComponent((Object)this.sessionFactory, KeycloakSessionFactory.class);
            }
        }
    }

    @Override
    protected void startLoading() {
        InitializerState state = this.getStateFromCache();
        final SessionLoader.LoaderContext[] ctx = new SessionLoader.LoaderContext[1];
        if (state == null) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    InfinispanCacheInitializer.this.sessionLoader.init(session);
                }
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    ctx[0] = InfinispanCacheInitializer.this.sessionLoader.computeLoaderContext(session);
                }
            });
            state = new InitializerState(ctx[0].getSegmentsCount());
        } else {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    ctx[0] = InfinispanCacheInitializer.this.sessionLoader.computeLoaderContext(session);
                }
            });
        }
        log.debugf("Start loading with loader: '%s', ctx: '%s' , state: %s", (Object)this.sessionLoader.toString(), (Object)ctx[0].toString(), (Object)state.toString());
        this.startLoadingImpl(state, ctx[0]);
    }

    @Override
    protected int getStalledTimeoutInSeconds() {
        return this.stalledTimeoutInSeconds;
    }

    protected void startLoadingImpl(InitializerState state, SessionLoader.LoaderContext loaderCtx) {
        int errors = 0;
        int segmentToLoad = 0;
        SessionLoader.WorkerResult previousResult = null;
        SessionLoader.WorkerResult nextResult = null;
        int distributedWorkersCount = 1;
        while (segmentToLoad < state.getSegmentsCount()) {
            log.debugf("Starting next iteration with %d workers", distributedWorkersCount);
            List<Integer> segments = state.getSegmentsToLoad(segmentToLoad, distributedWorkersCount);
            if (log.isTraceEnabled()) {
                log.trace((Object)("unfinished segments for this iteration: " + segments));
            }
            ConcurrentLinkedQueue<SessionLoader.WorkerResult> results = new ConcurrentLinkedQueue<SessionLoader.WorkerResult>();
            for (Integer segment : segments) {
                Object workerCtx = this.sessionLoader.computeWorkerContext(loaderCtx, segment, segment - segmentToLoad, previousResult);
                SessionInitializerWorker worker = new SessionInitializerWorker();
                worker.setWorkerEnvironment(loaderCtx, (SessionLoader.WorkerContext)workerCtx, this.sessionLoader);
                results.add(worker.apply(this.sessionFactory));
            }
            boolean anyFailure = false;
            for (SessionLoader.WorkerResult result : results) {
                if (result.isSuccess()) {
                    state.markSegmentFinished(result.getSegment());
                    if (result.getSegment() != segmentToLoad + distributedWorkersCount - 1) continue;
                    nextResult = result;
                    continue;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Segment %d failed to compute", result.getSegment());
                }
                anyFailure = true;
            }
            if (errors >= this.maxErrors) {
                throw new RuntimeException("Maximum count of worker errors occured. Limit was " + this.maxErrors + ". See server.log for details");
            }
            if (anyFailure) continue;
            segmentToLoad += distributedWorkersCount;
            previousResult = nextResult;
            nextResult = null;
            if (!log.isTraceEnabled()) continue;
            log.debugf("New initializer state is: %s", (Object)state);
        }
        this.saveStateToCache(state);
        this.sessionLoader.afterAllSessionsLoaded(this);
    }
}

