/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class UserFederationLinkRemovedEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    private String userId;
    private String realmId;
    private String identityProviderId;
    private String socialUserId;

    public static UserFederationLinkRemovedEvent create(String userId, String realmId, FederatedIdentityModel socialLink) {
        UserFederationLinkRemovedEvent event = new UserFederationLinkRemovedEvent();
        event.userId = userId;
        event.realmId = realmId;
        if (socialLink != null) {
            event.identityProviderId = socialLink.getIdentityProvider();
            event.socialUserId = socialLink.getUserId();
        }
        return event;
    }

    @Override
    public String getId() {
        return this.userId;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getSocialUserId() {
        return this.socialUserId;
    }

    public String toString() {
        return String.format("UserFederationLinkRemovedEvent [ userId=%s, identityProviderId=%s, socialUserId=%s ]", this.userId, this.identityProviderId, this.socialUserId);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.federatedIdentityLinkRemovedInvalidation(this.userId, this.realmId, this.identityProviderId, this.socialUserId, invalidations);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserFederationLinkRemovedEvent that = (UserFederationLinkRemovedEvent)o;
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.realmId, that.realmId) && Objects.equals(this.identityProviderId, that.identityProviderId) && Objects.equals(this.socialUserId, that.socialUserId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userId, this.realmId, this.identityProviderId, this.socialUserId);
    }

    public static class ExternalizerImpl
    implements Externalizer<UserFederationLinkRemovedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, UserFederationLinkRemovedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.userId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.identityProviderId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.socialUserId, (ObjectOutput)output);
        }

        public UserFederationLinkRemovedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public UserFederationLinkRemovedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            UserFederationLinkRemovedEvent res = new UserFederationLinkRemovedEvent();
            res.userId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.identityProviderId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.socialUserId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

