/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.SessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionsChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.changes.UserSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshChecker;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionStore;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class UserSessionAdapter<T extends SessionRefreshStore & UserSessionProvider>
implements UserSessionModel {
    private final KeycloakSession session;
    private final T provider;
    private final SessionsChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx;
    private final SessionsChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx;
    private final RealmModel realm;
    private final UserModel user;
    private final UserSessionEntity entity;
    private final boolean offline;
    private UserSessionModel.SessionPersistenceState persistenceState;
    private static final int MINIMUM_INACTIVE_CLIENT_SESSIONS_TO_CLEANUP = 5;

    public UserSessionAdapter(KeycloakSession session, UserModel user, T provider, SessionsChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx, SessionsChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx, RealmModel realm, UserSessionEntity entity, boolean offline) {
        this.session = session;
        this.user = user;
        this.provider = provider;
        this.userSessionUpdateTx = userSessionUpdateTx;
        this.clientSessionUpdateTx = clientSessionUpdateTx;
        this.realm = realm;
        this.entity = entity;
        this.offline = offline;
    }

    public Map<String, AuthenticatedClientSessionModel> getAuthenticatedClientSessions() {
        AuthenticatedClientSessionStore clientSessionEntities = this.entity.getAuthenticatedClientSessions();
        HashMap result = new HashMap();
        LinkedList<String> removedClientUUIDS = new LinkedList<String>();
        if (clientSessionEntities != null) {
            clientSessionEntities.forEach((key, value) -> {
                ClientModel client = this.realm.getClientById(key);
                if (client != null) {
                    AuthenticatedClientSessionModel clientSession = ((UserSessionProvider)this.provider).getClientSession((UserSessionModel)this, client, value.toString(), this.offline);
                    if (clientSession != null) {
                        result.put(key, clientSession);
                    }
                } else {
                    removedClientUUIDS.add((String)key);
                }
            });
        }
        this.removeAuthenticatedClientSessions(removedClientUUIDS);
        return Collections.unmodifiableMap(result);
    }

    public AuthenticatedClientSessionModel getAuthenticatedClientSessionByClient(String clientUUID) {
        AuthenticatedClientSessionStore clientSessionEntities = this.entity.getAuthenticatedClientSessions();
        UUID clientSessionId = clientSessionEntities.get(clientUUID);
        if (clientSessionId == null) {
            return null;
        }
        ClientModel client = this.realm.getClientById(clientUUID);
        if (client != null) {
            return ((UserSessionProvider)this.provider).getClientSession((UserSessionModel)this, client, clientSessionId, this.offline);
        }
        this.removeAuthenticatedClientSessions(Collections.singleton(clientUUID));
        return null;
    }

    public void removeAuthenticatedClientSessions(final Collection<String> removedClientUUIDS) {
        if (removedClientUUIDS == null || removedClientUUIDS.isEmpty()) {
            return;
        }
        if (removedClientUUIDS.size() >= 5) {
            UserSessionUpdateTask task = new UserSessionUpdateTask(){

                @Override
                public void runUpdate(UserSessionEntity entity) {
                    removedClientUUIDS.forEach(entity.getAuthenticatedClientSessions()::remove);
                }

                @Override
                public boolean isOffline() {
                    return UserSessionAdapter.this.offline;
                }
            };
            this.update(task);
        }
        List<UUID> clientSessionUuids = removedClientUUIDS.stream().map(this.entity.getAuthenticatedClientSessions()::get).filter(Objects::nonNull).collect(Collectors.toList());
        clientSessionUuids.forEach(clientSessionId -> this.clientSessionUpdateTx.addTask((UUID)clientSessionId, Tasks.removeSync(this.offline)));
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getBrokerSessionId() {
        return this.entity.getBrokerSessionId();
    }

    public String getBrokerUserId() {
        return this.entity.getBrokerUserId();
    }

    public UserModel getUser() {
        return this.user;
    }

    public String getLoginUsername() {
        if (this.entity.getLoginUsername() == null) {
            return this.getUser().getUsername();
        }
        return this.entity.getLoginUsername();
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public boolean isRememberMe() {
        return this.entity.isRememberMe();
    }

    public int getStarted() {
        return this.entity.getStarted();
    }

    public int getLastSessionRefresh() {
        return this.entity.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(final int lastSessionRefresh) {
        Boolean ignoreRemoteCacheUpdate;
        if (lastSessionRefresh <= this.entity.getLastSessionRefresh()) {
            return;
        }
        if (!(Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS) || !this.offline || (ignoreRemoteCacheUpdate = (Boolean)this.session.getAttribute("IGNORE_REMOTE_CACHE_UPDATE")) != null && ignoreRemoteCacheUpdate.booleanValue())) {
            this.provider.getPersisterLastSessionRefreshStore().putLastSessionRefresh(this.session, this.entity.getId(), this.realm.getId(), lastSessionRefresh);
        }
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public void runUpdate(UserSessionEntity entity) {
                if (entity.getLastSessionRefresh() >= lastSessionRefresh) {
                    return;
                }
                entity.setLastSessionRefresh(lastSessionRefresh);
            }

            @Override
            public SessionUpdateTask.CrossDCMessageStatus getCrossDCMessageStatus(SessionEntityWrapper<UserSessionEntity> sessionWrapper) {
                return new CrossDCLastSessionRefreshChecker(UserSessionAdapter.this.provider.getLastSessionRefreshStore(), UserSessionAdapter.this.provider.getOfflineLastSessionRefreshStore()).shouldSaveUserSessionToRemoteCache(UserSessionAdapter.this.session, UserSessionAdapter.this.realm, sessionWrapper, UserSessionAdapter.this.offline, lastSessionRefresh);
            }

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }

            public String toString() {
                return "setLastSessionRefresh(" + lastSessionRefresh + ")";
            }
        };
        this.update(task);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public String getNote(String name) {
        return this.entity.getNotes() != null ? this.entity.getNotes().get(name) : null;
    }

    public void setNote(final String name, final String value) {
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public void runUpdate(UserSessionEntity entity) {
                if (value == null) {
                    if (entity.getNotes().containsKey(name)) {
                        UserSessionAdapter.this.removeNote(name);
                    }
                    return;
                }
                entity.getNotes().put(name, value);
            }

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }
        };
        this.update(task);
    }

    public void removeNote(final String name) {
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public void runUpdate(UserSessionEntity entity) {
                entity.getNotes().remove(name);
            }

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }
        };
        this.update(task);
    }

    public Map<String, String> getNotes() {
        return this.entity.getNotes();
    }

    public UserSessionModel.State getState() {
        return this.entity.getState();
    }

    public void setState(final UserSessionModel.State state) {
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }

            @Override
            public void runUpdate(UserSessionEntity entity) {
                entity.setState(state);
            }
        };
        this.update(task);
    }

    public UserSessionModel.SessionPersistenceState getPersistenceState() {
        return this.persistenceState;
    }

    public void setPersistenceState(UserSessionModel.SessionPersistenceState persistenceState) {
        this.persistenceState = persistenceState;
    }

    public void restartSession(final RealmModel realm, final UserModel user, final String loginUsername, final String ipAddress, final String authMethod, final boolean rememberMe, final String brokerSessionId, final String brokerUserId) {
        UserSessionUpdateTask task = new UserSessionUpdateTask(){

            @Override
            public boolean isOffline() {
                return UserSessionAdapter.this.offline;
            }

            @Override
            public void runUpdate(UserSessionEntity entity) {
                InfinispanUserSessionProvider.updateSessionEntity(entity, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
                entity.setState(null);
                entity.getNotes().clear();
                entity.getAuthenticatedClientSessions().clear();
            }
        };
        this.update(task);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public UserSessionEntity getEntity() {
        return this.entity;
    }

    void update(UserSessionUpdateTask task) {
        this.userSessionUpdateTx.addTask(this.getId(), task);
    }
}

